/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import wily.betterfurnaces.blockentity.IInventoryBlockEntity;
import wily.factoryapi.base.FactoryItemHandler;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.CompoundTagUtil;

public abstract class InventoryBlockEntity
extends BaseContainerBlockEntity
implements IInventoryBlockEntity,
MenuProvider,
Nameable,
IFactoryStorage {
    public FactoryItemHandler inventory = new FactoryItemHandler(this.getInventorySize(), (BlockEntity)this, TransportState.EXTRACT_INSERT){

        public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
            return super.canTakeItem(container, i, itemStack) && InventoryBlockEntity.this.IcanExtractItem(i, itemStack);
        }
    };

    public InventoryBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void updateBlockState() {
        this.level.sendBlockUpdated(this.getBlockPos(), this.level.getBlockState(this.getBlockPos()), this.getBlockState(), 2);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void breakDurabilityItem(ItemStack stack) {
        if (!stack.isEmpty() && stack.isDamageableItem()) {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                stack.hurtAndBreak(1, serverLevel, null, i -> {});
            }
            if (stack.getDamageValue() >= stack.getMaxDamage()) {
                stack.shrink(1);
                this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void syncAdditionalMenuData(AbstractContainerMenu menu, Player player) {
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty((CompoundTag)tag, (String)"inventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("inventory", (Tag)this.inventory.serializeTag());
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory.getItems();
    }

    protected void setItems(NonNullList<ItemStack> nonNullList) {
        this.inventory.getItems().clear();
        this.inventory.getItems().addAll(nonNullList);
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    protected Component getDefaultName() {
        return this.getBlockState().getBlock().getName();
    }

    @NotNull
    public IPlatformItemHandler getInv() {
        return this.inventory;
    }

    public void onRemoved(boolean withContents) {
        if (withContents) {
            Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this.inventory);
        }
    }

    @Override
    public abstract boolean IcanExtractItem(int var1, ItemStack var2);
}

