/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.BFRConfig;
import wily.betterfurnaces.blockentity.FactoryUpgradeSettings;
import wily.betterfurnaces.blockentity.ForgeBlockEntity;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blockentity.LRUCache;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.compat.ProjectMMO;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.SlotFuel;
import wily.betterfurnaces.inventory.SlotInput;
import wily.betterfurnaces.inventory.SlotOutput;
import wily.betterfurnaces.inventory.SlotUpgrade;
import wily.betterfurnaces.inventory.SmeltingMenu;
import wily.betterfurnaces.items.FuelEfficiencyUpgradeItem;
import wily.betterfurnaces.items.GeneratorUpgradeItem;
import wily.betterfurnaces.items.LiquidFuelUpgradeItem;
import wily.betterfurnaces.items.OreProcessingUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryEnergyStorage;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.FuelManager;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.factoryapi.util.CompoundTagUtil;
import wily.factoryapi.util.FactoryItemUtil;
import wily.factoryapi.util.FluidInstance;

public class SmeltingBlockEntity
extends InventoryBlockEntity
implements RecipeCraftingHolder,
StackedContentsCompatible {
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    public int showInventorySettings;
    public boolean showOrientation;
    protected int timer;
    private int furnaceBurnTime;
    public int cookTime;
    public int totalCookTime = this.getCookTime();
    private int recipesUsed;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    public RecipeType<? extends AbstractCookingRecipe> recipeType;
    public FactoryUpgradeSettings furnaceSettings;
    protected final Map<RecipeType<? extends AbstractCookingRecipe>, LRUCache<Item, Optional<RecipeHolder<AbstractCookingRecipe>>>> caches = new HashMap<RecipeType<? extends AbstractCookingRecipe>, LRUCache<Item, Optional<RecipeHolder<AbstractCookingRecipe>>>>();
    public final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> SmeltingBlockEntity.this.furnaceBurnTime;
                case 1 -> SmeltingBlockEntity.this.recipesUsed;
                case 2 -> SmeltingBlockEntity.this.cookTime;
                case 3 -> SmeltingBlockEntity.this.totalCookTime;
                case 4 -> SmeltingBlockEntity.this.showInventorySettings;
                case 5 -> SmeltingBlockEntity.this.energyStorage.getEnergyStored();
                case 6 -> SmeltingBlockEntity.this.energyStorage.getMaxEnergyStored();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    SmeltingBlockEntity.this.furnaceBurnTime = value;
                    break;
                }
                case 1: {
                    SmeltingBlockEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    SmeltingBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    SmeltingBlockEntity.this.totalCookTime = value;
                    break;
                }
                case 4: {
                    SmeltingBlockEntity.this.showInventorySettings = value;
                    break;
                }
                case 5: {
                    SmeltingBlockEntity.this.energyStorage.setEnergyStored(value);
                    break;
                }
            }
        }

        public int getCount() {
            return 7;
        }
    };
    public static final SlotsIdentifier XP = new SlotsIdentifier(ChatFormatting.GREEN, "green");
    public final IPlatformFluidHandler fluidTank = new FactoryFluidHandler(this.getLiquidCapacity(), (BlockEntity)this, fs -> LiquidFuelUpgradeItem.supportsFluid(fs.getFluid()), SlotsIdentifier.LAVA, TransportState.EXTRACT_INSERT);
    public final IPlatformFluidHandler xpTank = new FactoryFluidHandler(2000, (BlockEntity)this, xp -> xp.getFluid().isSame(BFRConfig.getLiquidXP()), XP, TransportState.EXTRACT_INSERT);
    public final IPlatformEnergyStorage energyStorage = new FactoryEnergyStorage(this.getEnergyCapacity(), (BlockEntity)this);
    TagKey<Item> ore = this.getItemTag(FactoryAPI.createLocation((String)(FactoryAPI.getLoader().isForgeLike() ? "forge" : "c"), (String)"ores"));

    public int getEnergyConsume() {
        return 500;
    }

    public int getLiquidCapacity() {
        return 4000;
    }

    public int getEnergyCapacity() {
        return 16000;
    }

    public boolean isForge() {
        return this instanceof ForgeBlockEntity;
    }

    public ResourceLocation getInteractStat() {
        return this.recipeType == RecipeType.SMOKING ? Stats.INTERACT_WITH_SMOKER : (this.recipeType == RecipeType.BLASTING ? Stats.INTERACT_WITH_BLAST_FURNACE : Stats.INTERACT_WITH_FURNACE);
    }

    public SmeltingBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.recipeType = RecipeType.SMELTING;
        this.furnaceSettings = new FactoryUpgradeSettings(){

            @Override
            public ItemStack getContainer() {
                return SmeltingBlockEntity.this.getUpgradeTypeSlotItem((UpgradeItem)((Object)ModObjects.FACTORY.get()));
            }

            @Override
            public void onChanged() {
                SmeltingBlockEntity.this.setChanged();
            }
        };
    }

    public SmeltingBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get(), pos, state);
    }

    public int[] getFuelIndexes() {
        int[] inputs = new int[]{1};
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            inputs = new int[]{1, 7};
        }
        return inputs;
    }

    public int getHeaterIndex() {
        return this.getFuelIndexes()[0];
    }

    public int[] getUpgradeIndexes() {
        return new int[]{3, 4, 5};
    }

    public int getFirstInputIndex() {
        return this.getInputs()[0];
    }

    public int getLastInput() {
        return this.getInputs()[this.getInputs().length - 1];
    }

    public int getFirstOutput() {
        return this.getOutputs()[0];
    }

    public int getLastOutput() {
        return this.getOutputs()[this.getOutputs().length - 1];
    }

    public int[] getInputs() {
        int[] inputs = new int[]{0};
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            inputs = new int[]{0, 6};
        }
        return inputs;
    }

    public int[] getOutputs() {
        int[] outputs = new int[]{2};
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            outputs = new int[]{2, 8};
        }
        return outputs;
    }

    public int[] getAllInputs() {
        return ArrayUtils.addAll((int[])this.getInputs(), (int[])this.getFuelIndexes());
    }

    public int[] getAllSlots() {
        return ArrayUtils.addAll((int[])this.getAllInputs(), (int[])this.getOutputs());
    }

    public int getRecipeCookingTime(AbstractCookingRecipe recipe) {
        return recipe.cookingTime();
    }

    private int getFromCache(LRUCache<Item, Optional<RecipeHolder<AbstractCookingRecipe>>> cache, Item key) {
        Optional recipe = (Optional)cache.get(key);
        if (recipe == null || recipe.isEmpty()) {
            return 0;
        }
        return this.getRecipeCookingTime((AbstractCookingRecipe)((RecipeHolder)recipe.get()).value());
    }

    public boolean hasRecipe(ItemStack stack) {
        return this.grabRecipe(stack).isPresent();
    }

    protected LRUCache<Item, Optional<RecipeHolder<AbstractCookingRecipe>>> getCache() {
        return this.caches.computeIfAbsent(this.recipeType, key -> LRUCache.newInstance((Integer)BFRConfig.cacheCapacity.get()));
    }

    private Optional<RecipeHolder<AbstractCookingRecipe>> getRecipe(ItemStack stack, RecipeType<AbstractCookingRecipe> recipeType) {
        return CommonRecipeManager.getRecipeFor(recipeType, (RecipeInput)new SingleRecipeInput(stack), (Level)this.level);
    }

    private Optional<RecipeHolder<AbstractCookingRecipe>> grabRecipe(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        return this.getCache().computeIfAbsent(item, i -> this.getRecipe(stack, this.recipeType));
    }

    public boolean hasXPTank() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.XP.get()));
    }

    public boolean hasEnder() {
        return this.hasUpgradeType((UpgradeItem)((Object)ModObjects.FUEL.get()));
    }

    public int getEnderMultiplier() {
        if (this.hasEnder()) {
            return ((FuelEfficiencyUpgradeItem)this.getUpgradeTypeSlotItem((UpgradeItem)((UpgradeItem)((Object)ModObjects.FUEL.get()))).getItem()).getMultiplier;
        }
        return 1;
    }

    public boolean isLiquid() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.LIQUID.get()));
    }

    private boolean isEnergy() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) && this.energyStorage.getEnergyStored() >= this.getEnergyConsume();
    }

    public int getCookTime() {
        if (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) || this.arraySlotAllEmpty(this.getInputs())) {
            return this.getDefaultCookTime();
        }
        int speed = this.getSpeed();
        if (speed == -1) {
            return -1;
        }
        return Math.max(1, speed);
    }

    protected int getSpeed() {
        int j = 0;
        int length = this.getInputs().length;
        for (int i : this.getInputs()) {
            int iC;
            ItemStack stack = this.inventory.getItem(i);
            int cache = this.getFromCache(this.getCache(), stack.getItem());
            int n = iC = cache <= 0 ? this.grabRecipe(stack).map(v -> this.getRecipeCookingTime((AbstractCookingRecipe)v.value())).orElse(-1) : cache;
            if (iC <= 0) {
                --length;
                continue;
            }
            j += iC;
        }
        int n = j = length <= 0 ? 0 : j / length;
        if (j < this.getDefaultCookTime()) {
            return (int)((float)j * ((float)this.getDefaultCookTime() / 200.0f));
        }
        return this.getDefaultCookTime();
    }

    public List<UpgradeItem> getUpgrades() {
        ArrayList<UpgradeItem> list = new ArrayList<UpgradeItem>();
        for (int slot : this.getUpgradeIndexes()) {
            Item item = this.inventory.getItem(slot).getItem();
            if (!(item instanceof UpgradeItem)) continue;
            UpgradeItem upg = (UpgradeItem)item;
            list.add(upg);
        }
        return list;
    }

    public boolean hasUpgrade(UpgradeItem upg) {
        for (int slot : this.getUpgradeIndexes()) {
            if (!((Object)((Object)upg)).equals(this.inventory.getItem(slot).getItem()) || !upg.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpgradeType(UpgradeItem upg) {
        return this.getUpgradeTypeSlot(upg) >= 0;
    }

    public int getDefaultCookTime() {
        return this.level != null && this.getBlockState().getBlock() instanceof SmeltingBlock ? ((SmeltingBlock)this.getBlockState().getBlock()).defaultCookTime.get() : 200;
    }

    public ItemStack getUpgradeTypeSlotItem(UpgradeItem upg) {
        int i = this.getUpgradeTypeSlot(upg);
        return i < 0 ? ItemStack.EMPTY : this.inventory.getItem(i);
    }

    public int getUpgradeTypeSlot(UpgradeItem upg) {
        for (int slot : this.getUpgradeIndexes()) {
            UpgradeItem upgradeItem;
            Item item = this.inventory.getItem(slot).getItem();
            if (!(item instanceof UpgradeItem) || !(upgradeItem = (UpgradeItem)item).isEnabled() || !upg.isSameType(upgradeItem)) continue;
            return slot;
        }
        return -1;
    }

    public ItemStack getUpgradeSlotItem(Item upg) {
        for (int slot : this.getUpgradeIndexes()) {
            if (upg != this.inventory.getItem(slot).getItem()) continue;
            return this.inventory.getItem(slot);
        }
        return ItemStack.EMPTY;
    }

    public static int getFluidBurnTime(FluidInstance stack) {
        return stack == null ? 0 : FuelManager.getBurnTime((Item)stack.getFluid().getBucket());
    }

    public void forceUpdateAllStates() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue() != this.isBurning()) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
    }

    public int correspondentOutputSlot(int input) {
        return this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get())) ? Arrays.stream(this.getOutputs()).filter(i -> this.canSmelt(this.irecipeSlot(input), input, i)).min().orElse(-1) : this.getFirstOutput() - this.getFirstInputIndex() + input;
    }

    public void trySmelt() {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
            int i = this.correspondentOutputSlot(this.getFirstInputIndex());
            if (i >= 0) {
                this.smeltItem(this.irecipeSlot(this.getFirstInputIndex()), this.getFirstInputIndex(), i);
            }
        } else {
            for (int i : this.getInputs()) {
                RecipeHolder<AbstractCookingRecipe> recipe = this.irecipeSlot(i);
                if (!this.canSmelt(recipe, i, this.correspondentOutputSlot(i))) continue;
                this.smeltItem(recipe, i, this.correspondentOutputSlot(i));
            }
        }
    }

    public int getUpdatedType() {
        return this.hasUpgrade((UpgradeItem)((Object)ModObjects.BLAST.get())) ? 1 : (this.hasUpgrade((UpgradeItem)((Object)ModObjects.SMOKE.get())) ? 2 : (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) ? 3 : 0));
    }

    @Override
    public Component getDefaultName() {
        String tier = BuiltInRegistries.BLOCK.getKey((Object)this.getBlockState().getBlock()).getPath().split("_")[0];
        return this.getUpdatedType() != 0 ? Component.translatable((String)("tooltip.betterfurnacesreforged." + tier + "_tier"), (Object[])new Object[]{this.getUpdatedType() == 1 ? Blocks.BLAST_FURNACE.getName().getString() : (this.getUpdatedType() == 2 ? Blocks.SMOKER.getName().getString() : (this.getUpdatedType() == 3 ? Component.translatable((String)"tooltip.betterfurnacesreforged.generator").getString() : ""))}) : super.getDefaultName();
    }

    public RecipeHolder<AbstractCookingRecipe> irecipeSlot(int input) {
        if (!ArrayUtils.contains((int[])this.getInputs(), (int)input)) {
            return null;
        }
        if (!this.inventory.getItem(input).isEmpty()) {
            return this.grabRecipe(this.inventory.getItem(input)).orElse(null);
        }
        return null;
    }

    public boolean hasArraySlotSpace(int[] slots) {
        for (int i : slots) {
            boolean noFull;
            boolean bl = noFull = this.inventory.getItem(i).getCount() < this.inventory.getItem(i).getMaxStackSize() && !this.inventory.getItem(i).isEmpty();
            if (noFull) continue;
            return true;
        }
        return false;
    }

    public boolean arraySlotFilled(int[] slots, boolean isFilled) {
        for (int i : slots) {
            boolean filled = this.inventory.getItem(i).isEmpty();
            if (!isFilled) {
                boolean bl = filled = !filled;
            }
            if (filled) continue;
            return true;
        }
        return false;
    }

    public boolean arraySlotAllEmpty(int[] slots) {
        for (int i : slots) {
            boolean empty = this.inventory.getItem(i).isEmpty();
            if (empty) continue;
            return false;
        }
        return true;
    }

    public boolean canGeneratorWork() {
        if (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            ItemStack stack = this.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
            return ItemContainerPlatform.isFluidContainer((ItemStack)stack) && ItemContainerPlatform.getFluid((ItemStack)stack).getAmount() > 0 && this.energyStorage.getEnergySpace() > 0;
        }
        return false;
    }

    public boolean smeltValid() {
        if (!this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            for (int i : this.getInputs()) {
                if (!this.canSmelt(this.irecipeSlot(i), i, this.correspondentOutputSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState blockState, SmeltingBlockEntity be) {
        boolean wasBurning = be.isBurning();
        boolean setChanged = false;
        if (be.isBurning()) {
            --be.furnaceBurnTime;
        }
        if (be.hasXPTank()) {
            be.grantStoredRecipeExperience(level, null);
        }
        if (!be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get())) && be.showOrientation) {
            be.showOrientation = false;
        }
        ItemStack fuel = be.inventory.getItem(be.getFuelIndexes()[0]);
        if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.COLOR.get()))) {
            if (!((Boolean)level.getBlockState(be.getBlockPos()).getValue((Property)SmeltingBlock.COLORED)).booleanValue()) {
                level.setBlock(be.getBlockPos(), (BlockState)level.getBlockState(be.getBlockPos()).setValue((Property)SmeltingBlock.COLORED, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (((Boolean)level.getBlockState(be.getBlockPos()).getValue((Property)SmeltingBlock.COLORED)).booleanValue()) {
            level.setBlock(be.getBlockPos(), (BlockState)level.getBlockState(be.getBlockPos()).setValue((Property)SmeltingBlock.COLORED, (Comparable)Boolean.valueOf(false)), 3);
        }
        int updatedType = be.getUpdatedType();
        RecipeType[] recipeTypes = new RecipeType[]{RecipeType.SMELTING, RecipeType.BLASTING, RecipeType.SMOKING};
        if (updatedType == 3) {
            for (int i : new int[]{be.getFirstInputIndex(), be.getFirstOutput()}) {
                ItemStack stack = be.inventory.getItem(i);
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)be.getBlockPos().getX(), (double)(be.getBlockPos().getY() + 1), (double)be.getBlockPos().getZ(), (ItemStack)stack);
            }
        } else if (be.recipeType != recipeTypes[updatedType]) {
            be.recipeType = recipeTypes[updatedType];
        }
        if (!be.isForge() && (Integer)level.getBlockState(be.getBlockPos()).getValue((Property)SmeltingBlock.TYPE) != updatedType) {
            level.setBlock(be.getBlockPos(), (BlockState)level.getBlockState(be.getBlockPos()).setValue((Property)SmeltingBlock.TYPE, (Comparable)Integer.valueOf(updatedType)), 3);
        }
        if (!level.isClientSide) {
            ItemContainerPlatform.ItemFluidContext context;
            long amount;
            int mode;
            int get_cook_time = be.getCookTime();
            ++be.timer;
            if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                Direction[] directionArray = Direction.values();
                int n = directionArray.length;
                for (int i = 0; i < n; ++i) {
                    IPlatformEnergyStorage energyStorage;
                    Direction d = directionArray[i];
                    BlockEntity other = be.getLevel().getBlockEntity(be.getBlockPos().relative(d));
                    if (other == null || (energyStorage = (IPlatformEnergyStorage)FactoryAPIPlatform.getPlatformFactoryStorage((BlockEntity)other).getStorage(FactoryStorage.ENERGY, d.getOpposite()).get()) == null) continue;
                    be.energyStorage.consumeEnergy(energyStorage.receiveEnergy(Math.min(energyStorage.getMaxReceive(), be.energyStorage.getMaxConsume()), false), false);
                }
            }
            if (be.hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()))) {
                ItemStack storageFuel;
                ItemStack storageInput = be.inventory.getItem(6);
                if (!storageInput.isEmpty()) {
                    be.inventory.setItem(6, be.inventory.insertItem(be.getFirstInputIndex(), storageInput, false));
                }
                if (!(storageFuel = be.inventory.getItem(7)).isEmpty()) {
                    be.inventory.setItem(7, be.inventory.insertItem(be.getFuelIndexes()[0], storageFuel, false));
                }
            } else if (!be.isForge()) {
                for (int i : new int[]{6, 7, 8}) {
                    ItemStack stack = be.inventory.getItem(i);
                    if (stack.isEmpty()) continue;
                    Containers.dropItemStack((Level)level, (double)be.getBlockPos().getX(), (double)(be.getBlockPos().getY() + 1), (double)be.getBlockPos().getZ(), (ItemStack)stack);
                }
            }
            if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) && ItemContainerPlatform.isEnergyContainer((ItemStack)fuel) && ItemContainerPlatform.getEnergy((ItemStack)fuel) > 0 && be.energyStorage.getEnergySpace() > 0) {
                be.energyStorage.receiveEnergy(ItemContainerPlatform.extractEnergy((int)be.energyStorage.getEnergySpace(), (ItemStack)fuel).contextEnergy(), false);
                be.inventory.setItem(be.getFuelIndexes()[0], fuel);
            }
            if (be.totalCookTime != get_cook_time) {
                be.totalCookTime = get_cook_time;
            }
            if ((mode = be.getRedstoneSetting()) != 0) {
                if (mode == 2) {
                    int i = 0;
                    for (Direction side : Direction.values()) {
                        if (level.getSignal(worldPosition.relative(side), side) <= 0) continue;
                        ++i;
                    }
                    if (i != 0) {
                        be.cookTime = 0;
                        be.furnaceBurnTime = 0;
                        be.forceUpdateAllStates();
                        return;
                    }
                }
                if (mode == 1) {
                    boolean flag = false;
                    for (Direction side : Direction.values()) {
                        if (level.getSignal(worldPosition.relative(side), side) <= 0) continue;
                        flag = true;
                    }
                    if (!flag) {
                        be.cookTime = 0;
                        be.furnaceBurnTime = 0;
                        be.forceUpdateAllStates();
                        return;
                    }
                }
                for (i = 0; i < Direction.values().length; ++i) {
                    be.provides[i] = be.getBlockState().getDirectSignal((BlockGetter)be.level, worldPosition, Direction.values()[i]);
                }
            } else {
                for (i = 0; i < Direction.values().length; ++i) {
                    be.provides[i] = 0;
                }
            }
            if (be.doesNeedUpdateSend()) {
                be.onUpdateSent();
            }
            if (be.isLiquid() && LiquidFuelUpgradeItem.supportsItemFluidHandler(fuel) && (amount = (long)be.fluidTank.fill((context = ItemContainerPlatform.drainItem((int)be.fluidTank.getTotalSpace(), (ItemStack)fuel)).fluidInstance(), false)) > 0L) {
                level.playSound(null, (double)worldPosition.getX(), (double)worldPosition.getY(), (double)worldPosition.getZ(), SoundEvents.BUCKET_FILL_LAVA, SoundSource.PLAYERS, 0.6f, 0.8f);
                be.inventory.setItem(be.getFuelIndexes()[0], context.container());
            }
            if ((be.isBurning() || !fuel.isEmpty() || be.isLiquid() || be.isEnergy() && !be.canGeneratorWork()) && (be.arraySlotFilled(be.getInputs(), true) || be.canGeneratorWork())) {
                boolean valid;
                boolean bl = valid = be.smeltValid() || be.canGeneratorWork();
                if (!be.isBurning() && valid) {
                    if (be.isLiquid() && !be.fluidTank.getFluidInstance().isEmpty() && SmeltingBlockEntity.getFluidBurnTime(be.fluidTank.getFluidInstance()) > 0) {
                        int fluidAmount = 200000 / SmeltingBlockEntity.getFluidBurnTime(be.fluidTank.getFluidInstance());
                        if (be.fluidTank.getFluidInstance().getAmount() >= fluidAmount) {
                            be.recipesUsed = be.furnaceBurnTime = be.getEnderMultiplier() * get_cook_time;
                            be.fluidTank.drain(fluidAmount, false);
                        }
                    } else if (be.isEnergy()) {
                        be.recipesUsed = be.furnaceBurnTime = be.getEnderMultiplier() * get_cook_time;
                        for (int a : be.getInputs()) {
                            be.energyStorage.consumeEnergy(be.getEnergyConsume() * be.getOreProcessingMultiplier(be.inventory.getItem(a)), false);
                        }
                    } else {
                        be.recipesUsed = be.furnaceBurnTime = (int)Math.ceil((double)(be.getEnderMultiplier() * SmeltingBlockEntity.getBurnTime(fuel)) * ((double)get_cook_time / 200.0));
                    }
                    if (be.isBurning()) {
                        setChanged = true;
                        if (be.hasEnder() && be.hasUpgrade((UpgradeItem)((Object)ModObjects.FUEL.get()))) {
                            be.breakDurabilityItem(be.getUpgradeSlotItem((Item)ModObjects.FUEL.get()));
                        }
                        if (!(be.isLiquid() && be.fluidTank.getFluidInstance().getAmount() >= 10 || be.isEnergy())) {
                            if (ItemContainerPlatform.isFluidContainer((ItemStack)fuel)) {
                                ItemContainerPlatform.ItemFluidContext context2 = ItemContainerPlatform.drainItem((int)be.fluidTank.getTotalSpace(), (ItemStack)fuel);
                                be.inventory.setItem(be.getFuelIndexes()[0], context2.container());
                            }
                            if (!fuel.isEmpty() && FuelManager.isFuel((ItemStack)fuel)) {
                                fuel.shrink(1);
                                if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.FUEL.get()))) {
                                    be.breakDurabilityItem(be.getUpgradeSlotItem((Item)ModObjects.FUEL.get()));
                                }
                            }
                        }
                    }
                }
                if (be.isBurning() && valid) {
                    ++be.cookTime;
                    if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                        ItemContainerPlatform.ItemFluidContext context3 = ItemContainerPlatform.drainItem((int)1, (ItemStack)be.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get()));
                        if (!context3.fluidInstance().isEmpty()) {
                            be.inventory.setItem(be.getUpgradeTypeSlot((UpgradeItem)((Object)ModObjects.GENERATOR.get())), context3.container());
                        }
                        be.energyStorage.receiveEnergy(Math.round(500.0f / (float)get_cook_time), false);
                    }
                    if (be.cookTime >= be.totalCookTime) {
                        be.cookTime = 0;
                        be.totalCookTime = be.getCookTime();
                        if (!be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                            be.trySmelt();
                            if (be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
                                be.handleAutoIO();
                            }
                        }
                        setChanged = true;
                    }
                } else {
                    be.cookTime = 0;
                }
            } else if (!be.isBurning() && be.cookTime > 0) {
                be.cookTime = Mth.clamp((int)(be.cookTime - 2), (int)0, (int)be.totalCookTime);
            }
            if (wasBurning != be.isBurning()) {
                setChanged = true;
                be.level.setBlock(be.worldPosition, (BlockState)be.level.getBlockState(be.worldPosition).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(be.isBurning())), 3);
            }
            if (be.timer % 24 == 0 && be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get())) && be.cookTime <= 0) {
                if (be.arraySlotFilled(be.getInputs(), false)) {
                    be.handleAutoIO();
                    setChanged = true;
                } else if (be.hasArraySlotSpace(be.getInputs())) {
                    be.handleAutoIO();
                    setChanged = true;
                }
                if (be.arraySlotFilled(be.getOutputs(), true)) {
                    be.handleAutoIO();
                    setChanged = true;
                }
                if (be.inventory.getItem(be.getFuelIndexes()[0]).isEmpty() && !be.isLiquid() && !be.isEnergy()) {
                    be.handleAutoIO();
                    setChanged = true;
                } else if (be.inventory.getItem(be.getFuelIndexes()[0]).getCount() < be.inventory.getItem(be.getFuelIndexes()[0]).getMaxStackSize() || ItemContainerPlatform.isFluidContainer((ItemStack)fuel) && ItemContainerPlatform.getFluid((ItemStack)fuel).getAmount() < be.fluidTank.getTotalSpace()) {
                    be.handleAutoIO();
                    setChanged = true;
                }
            }
        }
        if (setChanged) {
            be.setChanged();
        }
    }

    public float[] getColor() {
        ItemStack colorUpgrade = this.getUpgradeSlotItem((Item)ModObjects.COLOR.get());
        if (colorUpgrade.isEmpty()) {
            return new float[]{1.0f, 1.0f, 1.0f};
        }
        return ((ModObjects.BlockTint)colorUpgrade.getOrDefault((DataComponentType)ModObjects.BLOCK_TINT.get(), (Object)ModObjects.BlockTint.WHITE)).toFloatArray();
    }

    public int getSettingBottom() {
        return this.furnaceSettings.getSides(this.getIndexBottom());
    }

    public int getSettingTop() {
        return this.furnaceSettings.getSides(this.getIndexTop());
    }

    public int getSettingFront() {
        return this.furnaceSettings.getSides(this.getIndexFront());
    }

    public int getSettingBack() {
        return this.furnaceSettings.getSides(this.getIndexBack());
    }

    public int getSettingLeft() {
        return this.furnaceSettings.getSides(this.getIndexLeft());
    }

    public int getSettingRight() {
        return this.furnaceSettings.getSides(this.getIndexRight());
    }

    protected BlockSide[] getSidesOrder() {
        return BlockSide.values();
    }

    public int getIndexBottom() {
        return BlockSide.BOTTOM.blockStateToFacing(this.getBlockState(), this.getSidesOrder()).ordinal();
    }

    public int getIndexTop() {
        return BlockSide.TOP.blockStateToFacing(this.getBlockState(), this.getSidesOrder()).ordinal();
    }

    public int getIndexFront() {
        return BlockSide.FRONT.blockStateToFacing(this.getBlockState(), this.getSidesOrder()).ordinal();
    }

    public int getIndexBack() {
        return BlockSide.BACK.blockStateToFacing(this.getBlockState(), this.getSidesOrder()).ordinal();
    }

    public int getIndexLeft() {
        return BlockSide.LEFT.blockStateToFacing(this.getBlockState(), this.getSidesOrder()).ordinal();
    }

    public int getIndexRight() {
        return BlockSide.RIGHT.blockStateToFacing(this.getBlockState(), this.getSidesOrder()).ordinal();
    }

    public int getAutoInput() {
        return this.furnaceSettings.getAutoIO(0);
    }

    public int getAutoOutput() {
        return this.furnaceSettings.getAutoIO(1);
    }

    public int getRedstoneSetting() {
        return this.furnaceSettings.getRedstone(0);
    }

    public int getRedstoneComSub() {
        return this.furnaceSettings.getRedstone(1);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private TagKey<Item> getItemTag(ResourceLocation resourceLocation) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)resourceLocation);
    }

    private boolean hasRawOreTag(ItemStack stack) {
        if (((Boolean)BFRConfig.checkRawOresName.get()).booleanValue()) {
            return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath().startsWith("raw_");
        }
        if (FactoryAPI.getLoader().isForgeLike()) {
            return stack.is(this.getItemTag(FactoryAPI.createLocation((String)"forge", (String)"raw_materials")));
        }
        if (stack.is(this.getItemTag(FactoryAPI.createLocation((String)"c", (String)"raw_materials")))) {
            return true;
        }
        for (TagKey tag : stack.getTags().toList()) {
            if (!tag.location().toString().contains("raw_") || !tag.location().toString().contains("_ores")) continue;
            return true;
        }
        return false;
    }

    protected boolean isOre(ItemStack input) {
        if (((Boolean)BFRConfig.checkCommonOresName.get()).booleanValue()) {
            return BuiltInRegistries.ITEM.getKey((Object)input.getItem()).getPath().endsWith("_ore");
        }
        return input.is(this.ore);
    }

    protected boolean isRaw(ItemStack input) {
        return this.hasRawOreTag(input);
    }

    protected int getOreProcessingMultiplier(ItemStack input) {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.ORE_PROCESSING.get()))) {
            OreProcessingUpgradeItem oreup = (OreProcessingUpgradeItem)this.getUpgradeTypeSlotItem((UpgradeItem)((Object)ModObjects.ORE_PROCESSING.get())).getItem();
            if (this.isRaw(input) && oreup.acceptRaw || this.isOre(input) && oreup.acceptOre) {
                return oreup.multiplier;
            }
        }
        return input.isEmpty() ? 0 : 1;
    }

    @Override
    public void onRemoved(boolean withContents) {
        super.onRemoved(withContents);
        if (withContents) {
            this.grantStoredRecipeExperience(this.getLevel(), this.getBlockPos().getCenter());
        }
    }

    public AbstractContainerMenu createMenu(int i, Inventory playerInventory) {
        return new SmeltingMenu(i, this.level, this.getBlockPos(), playerInventory, this.fields);
    }

    protected boolean canSmelt(RecipeHolder<AbstractCookingRecipe> recipe, int inputIndex, int outputIndex) {
        ItemStack recipeOutput;
        ItemStack input = this.getInv().getItem(inputIndex);
        if (outputIndex >= 0 && !input.isEmpty() && recipe != null && !(recipeOutput = this.getResult((AbstractCookingRecipe)recipe.value(), input)).isEmpty()) {
            ItemStack output = this.getInv().getItem(outputIndex);
            if (output.isEmpty()) {
                return true;
            }
            if (!FactoryItemUtil.equalItems((ItemStack)output, (ItemStack)recipeOutput)) {
                return false;
            }
            return output.getCount() + recipeOutput.getCount() <= output.getMaxStackSize();
        }
        return false;
    }

    private ItemStack getResult(@Nullable AbstractCookingRecipe recipe, ItemStack input) {
        ItemStack out = recipe.assemble(new SingleRecipeInput(input), (HolderLookup.Provider)this.level.registryAccess());
        out.setCount(out.getCount() * this.getOreProcessingMultiplier(input));
        return out;
    }

    protected int addOrSetItem(ItemStack stack, Container inv, int index) {
        ItemStack slotStack = inv.getItem(index);
        if (slotStack.isEmpty()) {
            inv.setItem(index, stack.copy());
            return Math.min(inv.getMaxStackSize(), stack.getCount());
        }
        int resultCount = slotStack.getCount() + stack.getCount();
        int maxStack = Math.min(inv.getMaxStackSize(), slotStack.getMaxStackSize());
        if (slotStack.is(stack.getItem()) && slotStack.getCount() < maxStack) {
            if (resultCount <= maxStack) {
                slotStack.grow(Math.max(stack.getCount(), 1));
                return Math.max(stack.getCount(), 1);
            }
            int count = maxStack - slotStack.getCount();
            slotStack.setCount(maxStack);
            return count;
        }
        return 0;
    }

    protected void smeltItem(@Nullable RecipeHolder<AbstractCookingRecipe> recipe, int inputIndex, int outputIndex) {
        this.timer = 0;
        if (recipe != null && this.canSmelt(recipe, inputIndex, outputIndex)) {
            ItemStack input = this.getInv().getItem(inputIndex);
            if (this.addOrSetItem(this.getResult((AbstractCookingRecipe)recipe.value(), input), (Container)this.inventory, outputIndex) > 0 && this.hasUpgrade((UpgradeItem)((Object)ModObjects.ORE_PROCESSING.get())) && this.isOre(input)) {
                this.breakDurabilityItem(this.getUpgradeSlotItem((Item)ModObjects.ORE_PROCESSING.get()));
            }
            this.checkXP();
            this.setRecipeUsed(recipe);
            ItemStack fuel = this.inventory.getItem(this.getFuelIndexes()[0]);
            if (input.getItem() == Blocks.WET_SPONGE.asItem() && !fuel.isEmpty() && ItemContainerPlatform.isFluidContainer((ItemStack)fuel)) {
                ItemContainerPlatform.fillItem((ItemStack)fuel, (FluidInstance)FluidInstance.create((Fluid)Fluids.WATER, (int)1000));
                this.inventory.setItem(this.getFuelIndexes()[0], fuel);
            }
            if (FactoryAPI.isModLoaded((String)"pmmo")) {
                ProjectMMO.burnEvent(input, this.level, this.worldPosition);
            }
            input.shrink(1);
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.furnaceBurnTime = CompoundTagUtil.getInt((CompoundTag)tag, (String)"BurnTime").orElse(0);
        this.cookTime = CompoundTagUtil.getInt((CompoundTag)tag, (String)"CookTime").orElse(0);
        this.totalCookTime = CompoundTagUtil.getInt((CompoundTag)tag, (String)"CookTimeTotal").orElse(0);
        this.timer = 0;
        this.recipesUsed = SmeltingBlockEntity.getBurnTime(this.getInv().getItem(1));
        this.fluidTank.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty((CompoundTag)tag, (String)"fluidTank"));
        this.xpTank.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty((CompoundTag)tag, (String)"xpTank"));
        this.energyStorage.deserializeTag((Tag)CompoundTagUtil.getCompoundTagOrEmpty((CompoundTag)tag, (String)"energy"));
        CompoundTag compoundnbt = CompoundTagUtil.getCompoundTagOrEmpty((CompoundTag)tag, (String)"RecipesUsed");
        for (String s : compoundnbt.getAllKeys()) {
            this.recipes.put((Object)FactoryAPI.createLocation((String)s), CompoundTagUtil.getInt((CompoundTag)compoundnbt, (String)s).orElse(0));
        }
        this.showInventorySettings = CompoundTagUtil.getInt((CompoundTag)tag, (String)"ShowInvSettings").orElse(0);
        this.showOrientation = CompoundTagUtil.getBoolean((CompoundTag)tag, (String)"ShowOrientation").orElse(false);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("BurnTime", this.furnaceBurnTime);
        tag.putInt("CookTime", this.cookTime);
        tag.putInt("CookTimeTotal", this.totalCookTime);
        tag.put("fluidTank", (Tag)this.fluidTank.serializeTag());
        tag.put("xpTank", (Tag)this.xpTank.serializeTag());
        tag.put("energy", this.energyStorage.serializeTag());
        tag.putInt("ShowInvSettings", this.showInventorySettings);
        tag.putBoolean("ShowOrientation", this.showOrientation);
        CompoundTag compoundnbt = new CompoundTag();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.putInt(recipeId.toString(), craftedAmount.intValue()));
        tag.put("RecipesUsed", (Tag)compoundnbt);
        super.saveAdditional(tag, provider);
    }

    protected static int getBurnTime(ItemStack stack) {
        if (stack.isEmpty()) {
            return 0;
        }
        return FuelManager.getBurnTime((ItemStack)stack);
    }

    public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(FactoryStorage<T> storage, Direction facing) {
        if (storage == FactoryStorage.FLUID) {
            if (facing == null || !this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) && !this.hasXPTank() || facing.ordinal() == this.getIndexTop() || facing.ordinal() == this.getIndexBottom()) {
                if (this.isLiquid()) {
                    return () -> facing == null ? this.fluidTank : FactoryAPIPlatform.filteredOf((IPlatformFluidHandler)this.fluidTank, (Direction)Direction.NORTH, (TransportState)TransportState.INSERT);
                }
            } else {
                if (this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
                    ItemStack gen = this.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
                    return () -> {
                        IPlatformFluidHandler iPlatformFluidHandler;
                        Item patt0$temp = gen.getItem();
                        if (patt0$temp instanceof GeneratorUpgradeItem) {
                            GeneratorUpgradeItem item = (GeneratorUpgradeItem)patt0$temp;
                            iPlatformFluidHandler = facing == null ? item.getFluidStorage(gen) : FactoryAPIPlatform.filteredOf((IPlatformFluidHandler)item.getFluidStorage(gen), (Direction)Direction.NORTH, (TransportState)TransportState.INSERT);
                        } else {
                            iPlatformFluidHandler = null;
                        }
                        return iPlatformFluidHandler;
                    };
                }
                if (this.hasXPTank()) {
                    return () -> facing == null ? this.xpTank : FactoryAPIPlatform.filteredOf((IPlatformFluidHandler)this.xpTank, (Direction)Direction.NORTH, (TransportState)TransportState.EXTRACT);
                }
            }
        }
        if (storage == FactoryStorage.ITEM) {
            return () -> facing == null ? this.inventory : FactoryAPIPlatform.filteredOf((IPlatformItemHandler)this.inventory, (Direction)facing, (int[])((int[])this.getSlotsTransport(facing).key()), (TransportState)((TransportState)this.getSlotsTransport(facing).value()));
        }
        if (storage == FactoryStorage.ENERGY && (this.hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) || this.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())))) {
            return () -> facing == null || !this.hasUpgrade((UpgradeItem)((Object)((Object)ModObjects.GENERATOR.get()))) ? this.energyStorage : FactoryAPIPlatform.filteredOf((IPlatformEnergyStorage)this.energyStorage, (Direction)Direction.NORTH, (TransportState)TransportState.ofBoolean((boolean)true, (boolean)false));
        }
        return ArbitrarySupplier.empty();
    }

    @Override
    public Pair<int[], TransportState> getSlotsTransport(Direction side) {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
            if (this.furnaceSettings.getSides(side.ordinal()) == 1) {
                return Pair.of((Object)this.getAllInputs(), (Object)TransportState.INSERT);
            }
            if (this.furnaceSettings.getSides(side.ordinal()) == 2) {
                return Pair.of((Object)this.getOutputs(), (Object)TransportState.EXTRACT_INSERT);
            }
            if (this.furnaceSettings.getSides(side.ordinal()) == 3) {
                return Pair.of((Object)this.getAllSlots(), (Object)TransportState.EXTRACT_INSERT);
            }
            if (this.furnaceSettings.getSides(side.ordinal()) == 4) {
                return Pair.of((Object)new int[]{this.getFuelIndexes()[0]}, (Object)TransportState.EXTRACT_INSERT);
            }
        } else {
            if (side == Direction.UP) {
                return Pair.of((Object)this.getInputs(), (Object)TransportState.INSERT);
            }
            if (side == Direction.DOWN) {
                return Pair.of((Object)this.getOutputs(), (Object)TransportState.EXTRACT);
            }
            return Pair.of((Object)new int[]{this.getFuelIndexes()[0]}, (Object)TransportState.EXTRACT_INSERT);
        }
        return Pair.of((Object)new int[0], (Object)TransportState.NONE);
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack) {
        if (this.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
            return !ArrayUtils.contains((int[])this.getInputs(), (int)index) && !ArrayUtils.contains((int[])this.getUpgradeIndexes(), (int)index) && (!ArrayUtils.contains((int[])this.getFuelIndexes(), (int)index) || !FuelManager.isFuel((ItemStack)stack) && (!ItemContainerPlatform.isEnergyContainer((ItemStack)stack) || ItemContainerPlatform.getEnergy((ItemStack)stack) <= 0));
        }
        return ArrayUtils.contains((int[])this.getOutputs(), (int)index);
    }

    @Override
    public void addSlots(NonNullList<FactoryItemSlot> slots, @Nullable Player player) {
        slots.add((Object)new SlotInput(this, 0, 54, 18, s -> !this.hasUpgrade((UpgradeItem)((Object)((Object)ModObjects.GENERATOR.get())))));
        slots.add((Object)new SlotFuel(this, 1, 54, 54));
        slots.add((Object)new SlotOutput(player, this, 2, 116, 35, s -> !this.hasUpgrade((UpgradeItem)((Object)((Object)ModObjects.GENERATOR.get())))));
        slots.add((Object)new SlotUpgrade(this, 3, 8, 18));
        slots.add((Object)new SlotUpgrade(this, 4, 8, 36));
        slots.add((Object)new SlotUpgrade(this, 5, 8, 54));
        slots.add((Object)new SlotInput(this, 6, 36, 18, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)ModObjects.STORAGE.get())))));
        slots.add((Object)new SlotFuel(this, 7, 36, 54, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)ModObjects.STORAGE.get())))));
        slots.add((Object)new SlotOutput(player, this, 8, 138, 35, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)ModObjects.STORAGE.get())))));
    }

    public void clearRecipes() {
        this.recipes.clear();
    }

    public void checkXP() {
        boolean flag2 = false;
        if (this.recipes.size() > (Integer)BFRConfig.furnaceXPDropValue.get()) {
            this.grantStoredRecipeExperience(this.level, new Vec3((double)(this.worldPosition.getX() + this.level.random.nextInt(2) - 1), (double)this.worldPosition.getY(), (double)(this.worldPosition.getZ() + this.level.random.nextInt(2) - 1)));
            this.recipes.clear();
        } else {
            for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
                RecipeHolder recipe = CommonRecipeManager.byId((ResourceLocation)((ResourceLocation)entry.getKey()), this.recipeType);
                if (recipe == null || entry.getIntValue() <= (Integer)BFRConfig.furnaceAccumulatedXPDropValue.get()) continue;
                if (!flag2) {
                    this.grantStoredRecipeExperience(this.level, new Vec3((double)(this.worldPosition.getX() + this.level.random.nextInt(2) - 1), (double)this.worldPosition.getY(), (double)(this.worldPosition.getZ() + this.level.random.nextInt(2) - 1)));
                }
                flag2 = true;
            }
            if (flag2) {
                this.recipes.clear();
            }
        }
    }

    public void setRecipeUsed(RecipeHolder<?> recipeHolder) {
        this.recipes.addTo((Object)recipeHolder.id().location(), 1);
    }

    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void unlockRecipes(Player player) {
        player.awardRecipes(this.grantStoredRecipeExperience(player.level(), player.position()));
        this.clearRecipes();
    }

    public List<RecipeHolder<?>> grantStoredRecipeExperience(Level level, Vec3 worldPosition) {
        ArrayList list = Lists.newArrayList();
        this.recipes.object2IntEntrySet().fastForEach(entry -> {
            RecipeHolder recipe = CommonRecipeManager.byId((ResourceLocation)((ResourceLocation)entry.getKey()), this.recipeType);
            if (recipe == null) {
                return;
            }
            list.add(recipe);
            float experience = ((AbstractCookingRecipe)recipe.value()).experience();
            if (this.hasXPTank()) {
                int amountLiquidXp = Mth.floor((float)((float)entry.getIntValue() * experience)) * 5;
                if (amountLiquidXp >= 1) {
                    this.xpTank.fill(FluidInstance.create((Fluid)BFRConfig.getLiquidXP(), (int)amountLiquidXp), false);
                    this.recipes.clear();
                }
            } else if (worldPosition != null) {
                SmeltingBlockEntity.splitAndSpawnExperience(level, worldPosition, entry.getIntValue(), experience);
            }
        });
        return list;
    }

    public void handleAutoIO() {
        for (Direction dir : Direction.values()) {
            IPlatformItemHandler other;
            BlockEntity tile = this.getLevel().getBlockEntity(this.getBlockPos().relative(dir));
            if (tile == null || this.furnaceSettings.getSides(dir.ordinal()) != 1 && this.furnaceSettings.getSides(dir.ordinal()) != 2 && this.furnaceSettings.getSides(dir.ordinal()) != 3 && this.furnaceSettings.getSides(dir.ordinal()) != 4 || (other = (IPlatformItemHandler)FactoryAPIPlatform.getPlatformFactoryStorage((BlockEntity)tile).getStorage(FactoryStorage.ITEM, dir.getOpposite()).get()) == null || this.getAutoInput() == 0 && this.getAutoOutput() == 0) continue;
            if (this.getAutoInput() == 1) {
                ItemStack stack;
                int i;
                for (int INPUT : this.getInputs()) {
                    if (this.furnaceSettings.getSides(dir.ordinal()) != 1 && this.furnaceSettings.getSides(dir.ordinal()) != 3 || this.inventory.getItem(INPUT).getCount() >= this.inventory.getItem(INPUT).getMaxStackSize()) continue;
                    for (i = 0; i < other.getContainerSize(); ++i) {
                        if (other.getItem(i).isEmpty() || (!this.hasRecipe(stack = other.extractItem(i, other.getItem(i).getMaxStackSize(), true)) || !this.inventory.getItem(INPUT).isEmpty()) && !FactoryItemUtil.equalItems((ItemStack)this.inventory.getItem(INPUT), (ItemStack)stack)) continue;
                        this.inventory.insertItem(INPUT, other.extractItem(i, other.getItem(i).getMaxStackSize() - this.inventory.getItem(INPUT).getCount(), false), false);
                    }
                }
                for (int FUEL : this.getFuelIndexes()) {
                    if (this.furnaceSettings.getSides(dir.ordinal()) != 4 || this.inventory.getItem(FUEL).getCount() >= this.inventory.getItem(FUEL).getMaxStackSize()) continue;
                    for (i = 0; i < other.getContainerSize(); ++i) {
                        if (!FuelManager.isFuel((ItemStack)other.getItem(i)) || other.getItem(i).isEmpty() || (!FuelManager.isFuel((ItemStack)(stack = other.extractItem(i, other.getItem(i).getMaxStackSize(), true))) || !this.inventory.getItem(FUEL).isEmpty()) && !FactoryItemUtil.equalItems((ItemStack)this.inventory.getItem(FUEL), (ItemStack)stack)) continue;
                        this.inventory.insertItem(FUEL, other.extractItem(i, other.getItem(i).getMaxStackSize() - this.inventory.getItem(FUEL).getCount(), false), false);
                    }
                }
            }
            if (this.getAutoOutput() != 1) continue;
            for (int FUEL : this.getFuelIndexes()) {
                ItemStack fuel;
                if (this.furnaceSettings.getSides(dir.ordinal()) != 4 || this.inventory.getItem(FUEL).isEmpty() || FuelManager.isFuel((ItemStack)(fuel = this.inventory.getItem(FUEL)))) continue;
                for (int i = 0; i < other.getContainerSize(); ++i) {
                    ItemStack stack = this.inventory.extractItem(FUEL, this.inventory.getItem(FUEL).getMaxStackSize() - other.getItem(i).getCount(), true);
                    if (!other.canPlaceItem(i, stack) || !other.getItem(i).isEmpty() && (!other.canPlaceItem(i, stack) || !FactoryItemUtil.equalItems((ItemStack)other.getItem(i), (ItemStack)stack) || other.getItem(i).getCount() + stack.getCount() > other.getMaxStackSize())) continue;
                    this.inventory.setItem(FUEL, other.insertItem(i, stack, false));
                }
            }
            for (int output : this.getOutputs()) {
                if (this.furnaceSettings.getSides(dir.ordinal()) != 2 && this.furnaceSettings.getSides(dir.ordinal()) != 3 || this.inventory.getItem(output).isEmpty() || BuiltInRegistries.BLOCK.getKey((Object)tile.getBlockState().getBlock()).toString().contains("storagedrawers:")) continue;
                for (int i = 0; i < other.getContainerSize(); ++i) {
                    ItemStack stack = this.inventory.extractItem(output, this.inventory.getItem(output).getMaxStackSize() - other.getItem(i).getCount(), true);
                    if (!other.canPlaceItem(i, stack) || !other.getItem(i).isEmpty() && (!other.canPlaceItem(i, stack) || !FactoryItemUtil.equalItems((ItemStack)other.getItem(i), (ItemStack)stack) || other.getItem(i).getCount() + stack.getCount() > other.getMaxStackSize())) continue;
                    this.inventory.setItem(output, other.insertItem(i, stack, false));
                }
            }
        }
    }

    private static void splitAndSpawnExperience(Level level, Vec3 worldPosition, int craftedAmount, float experience) {
        int i = Mth.floor((float)((float)craftedAmount * experience));
        float f = Mth.frac((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.getExperienceValue((int)i);
            i -= j;
            level.addFreshEntity((Entity)new ExperienceOrb(level, worldPosition.x, worldPosition.y, worldPosition.z, j));
        }
    }

    public void fillStackedContents(StackedItemContents stackedContents) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            stackedContents.accountStack(this.inventory.getItem(i));
        }
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
    }
}

