/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.factoryapi.base.network.OpenExtraMenuPayload;

public class BFRBlock
extends Block {
    public BFRBlock(BlockBehaviour.Properties properties) {
        super(properties.strength(3.0f));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List customDrops = super.getDrops(state, builder);
        if (!customDrops.isEmpty()) {
            return customDrops;
        }
        return Collections.singletonList(new ItemStack((ItemLike)this));
    }

    protected boolean openBlockEntityMenu(Level world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider menu = (MenuProvider)blockEntity;
            OpenExtraMenuPayload.openMenuWithPos((ServerPlayer)((ServerPlayer)player), (MenuProvider)menu, (BlockPos)blockEntity.getBlockPos());
            return true;
        }
        return false;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean bl) {
        BlockEntity be;
        if (state.getBlock() != oldState.getBlock() && (be = level.getBlockEntity(pos)) instanceof InventoryBlockEntity) {
            InventoryBlockEntity inventory = (InventoryBlockEntity)be;
            this.onRemoveInventoryBlockEntity(level, pos, inventory, true);
        }
        super.onRemove(state, level, pos, oldState, bl);
    }

    public void onRemoveInventoryBlockEntity(Level level, BlockPos pos, InventoryBlockEntity inventory, boolean dropContents) {
        inventory.onRemoved(dropContents);
        level.updateNeighbourForOutputSignal(pos, (Block)this);
    }

    public void appendHoverText(ItemStack stack, Consumer<Component> tooltip, TooltipFlag flagIn) {
    }
}

