/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.CobblestoneGeneratorBlockEntity;
import wily.betterfurnaces.blocks.BFRBlock;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.base.FactoryItemSlot;

public class CobblestoneGeneratorBlock
extends BFRBlock
implements EntityBlock {
    public static final String COBBLESTONE_GENERATOR = "cobblestone_generator";
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"state", (int)0, (int)3);

    public CobblestoneGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(b -> {
            int s = (Integer)b.getValue((Property)TYPE);
            return s == 1 || s == 3 ? 9 : 0;
        }));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)TYPE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.openBlockEntityMenu(level, pos, player);
        return InteractionResult.CONSUME;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (this.interactInsert(level, blockPos, player, interactionHand)) {
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected boolean interactInsert(Level level, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity blockEntity;
        ItemStack handItem;
        block7: {
            block8: {
                handItem = player.getItemInHand(hand);
                if (handItem.getItem() == Items.LAVA_BUCKET || handItem.getItem() == Items.WATER_BUCKET) break block7;
                blockEntity = handItem.getItem();
                if (!(blockEntity instanceof UpgradeItem)) break block8;
                UpgradeItem upg = (UpgradeItem)blockEntity;
                if (upg.upgradeType == UpgradeItem.Type.ORE || upg.upgradeType == UpgradeItem.Type.FUEL) break block7;
            }
            return false;
        }
        if (!((blockEntity = level.getBlockEntity(pos)) instanceof CobblestoneGeneratorBlockEntity)) {
            return false;
        }
        CobblestoneGeneratorBlockEntity be = (CobblestoneGeneratorBlockEntity)blockEntity;
        ItemStack newStack = handItem.copyWithCount(1);
        for (int i : new int[]{0, 1, 3, 4}) {
            if (handItem.isEmpty() || !((FactoryItemSlot)be.getSlots(null).get(i)).mayPlace(handItem)) continue;
            if (!be.inventory.getItem(i).isEmpty() && !player.isCreative()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)be.inventory.getItem(i));
            }
            be.inventory.setItem(i, newStack);
        }
        level.playSound(null, be.getBlockPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.isCreative()) {
            player.getItemInHand(hand).shrink(1);
        }
        be.onUpdateSent();
        return true;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING, TYPE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new CobblestoneGeneratorBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, pos, state1, tile) -> {
            if (tile instanceof CobblestoneGeneratorBlockEntity) {
                CobblestoneGeneratorBlockEntity be = (CobblestoneGeneratorBlockEntity)tile;
                be.tick(state1);
            }
        };
    }
}

