/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.util.VoxelShapeUtil;

public class ForgeBlock
extends SmeltingBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape FORGE_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)ForgeBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ForgeBlock.box((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), ForgeBlock.box((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), ForgeBlock.box((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), ForgeBlock.box((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), ForgeBlock.box((double)1.75, (double)15.0, (double)1.75, (double)14.5, (double)15.0, (double)14.5), ForgeBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), ForgeBlock.box((double)1.0, (double)0.5, (double)1.0, (double)15.0, (double)15.0, (double)15.0)}), (BooleanOp)BooleanOp.AND);

    public ForgeBlock(BlockBehaviour.Properties properties, Supplier<Integer> defaultCookTime) {
        super(properties.noOcclusion(), defaultCookTime);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState p_48735_, BlockGetter p_48736_, BlockPos p_48737_, CollisionContext p_48738_) {
        return VoxelShapeUtil.rotate((VoxelShape)FORGE_SHAPE, (Direction)((Direction)p_48735_.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing = ctx.getNearestLookingDirection().getOpposite();
        boolean flag = ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    protected void interactUpgrade(SmeltingBlockEntity be, Level level, BlockPos pos, Player player, InteractionHand handIn, ItemStack handItem) {
        Item hand = player.getItemInHand(handIn).getItem();
        if (((UpgradeItem)hand).upgradeType == UpgradeItem.Type.ALTERNATIVE_FUEL) {
            if (!be.inventory.getItem(10).isEmpty() && !player.isCreative()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)be.getItem(10));
            }
            be.inventory.setItem(10, handItem.copyWithCount(1));
            level.playSound(null, be.getBlockPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!player.isCreative()) {
                player.getItemInHand(handIn).shrink(1);
            }
            be.onUpdateSent();
        } else {
            super.interactUpgrade(be, level, pos, player, handIn, handItem);
        }
    }

    @Override
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            if (world.getBlockEntity(pos) == null) {
                return;
            }
            if (!(world.getBlockEntity(pos) instanceof SmeltingBlockEntity)) {
                return;
            }
            if (state.getValue((Property)BlockStateProperties.FACING) == Direction.UP) {
                double d0 = (double)pos.getX() + 0.5;
                double d1 = (double)pos.getY() + rand.nextDouble() * 6.0 / 16.0;
                double d2 = (double)pos.getZ() + 0.5;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(d0, (double)pos.getY(), d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0);
            } else {
                for (int l = 0; l < 3; ++l) {
                    double d0 = (float)pos.getX() + rand.nextFloat();
                    double d1 = (float)pos.getY() + rand.nextFloat();
                    double d2 = (float)pos.getZ() + rand.nextFloat();
                    double d3 = ((double)rand.nextFloat() - 0.5) * 0.2;
                    double d4 = ((double)rand.nextFloat() - 0.5) * 0.2;
                    double d5 = ((double)rand.nextFloat() - 0.5) * 0.2;
                    world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_LAVA, d0, d1, d2, d3, d4, d5);
                }
            }
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityTypes.FORGE_TILE.get()).create(blockPos, blockState);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ForgeBlock.createFurnaceTicker(level, type, (BlockEntityType<? extends SmeltingBlockEntity>)((BlockEntityType)BlockEntityTypes.FORGE_TILE.get()));
    }

    @Override
    public BlockState rotate(BlockState p_185499_1_, Rotation p_185499_2_) {
        if (p_185499_2_ == Rotation.CLOCKWISE_90 || p_185499_2_ == Rotation.COUNTERCLOCKWISE_90) {
            if ((Direction)p_185499_1_.getValue(FACING) == Direction.WEST || (Direction)p_185499_1_.getValue(FACING) == Direction.EAST) {
                return (BlockState)p_185499_1_.setValue(FACING, (Comparable)Direction.UP);
            }
            if ((Direction)p_185499_1_.getValue(FACING) == Direction.UP || (Direction)p_185499_1_.getValue(FACING) == Direction.DOWN) {
                return (BlockState)p_185499_1_.setValue(FACING, (Comparable)Direction.WEST);
            }
        }
        return p_185499_1_;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING, WATERLOGGED, BlockStateProperties.LIT, COLORED});
    }
}

