/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.blocks.BFRBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.items.LiquidFuelUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.util.CompoundTagUtil;
import wily.factoryapi.util.FactoryItemUtil;

public class SmeltingBlock
extends BFRBlock
implements EntityBlock {
    public static final BooleanProperty COLORED = BooleanProperty.create((String)"colored");
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)0, (int)3);
    public boolean shouldDropContent = true;
    public Supplier<Integer> defaultCookTime;

    public SmeltingBlock(BlockBehaviour.Properties properties, Supplier<Integer> defaultCookTime) {
        super(properties.destroyTime(3.0f).lightLevel(b -> (Boolean)b.getValue((Property)BlockStateProperties.LIT) != false ? 14 : 0).noOcclusion().emissiveRendering(SmeltingBlock::getOrientation));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)COLORED, (Comparable)Boolean.valueOf(false)));
        this.defaultCookTime = defaultCookTime;
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public static boolean getOrientation(BlockState state, BlockGetter world, BlockPos pos) {
        return world.getBlockEntity(pos) != null && ((SmeltingBlockEntity)world.getBlockEntity((BlockPos)pos)).showOrientation;
    }

    @Override
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ItemStack drop = new ItemStack((ItemLike)this.asItem());
        ItemStack stack = (ItemStack)builder.getOptionalParameter(LootContextParams.TOOL);
        SmeltingBlockEntity be = (SmeltingBlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (FactoryItemUtil.getEnchantmentLevel((ItemStack)stack, (ResourceKey)Enchantments.SILK_TOUCH, (RegistryAccess)builder.getLevel().registryAccess()) > 0 && stack.isCorrectToolForDrops(state)) {
            ItemStack colorUpgrade = be.getUpgradeTypeSlotItem((UpgradeItem)((Object)ModObjects.COLOR.get()));
            if (!colorUpgrade.isEmpty()) {
                drop.set((DataComponentType)ModObjects.BLOCK_TINT.get(), (Object)((ModObjects.BlockTint)colorUpgrade.getOrDefault((DataComponentType)ModObjects.BLOCK_TINT.get(), (Object)ModObjects.BlockTint.WHITE)));
            }
            BlockItem.setBlockEntityData((ItemStack)drop, (BlockEntityType)be.getType(), (CompoundTag)be.getUpdateTag((HolderLookup.Provider)be.getLevel().registryAccess()));
            drop.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)be.inventory.getItems()));
        }
        return Collections.singletonList(drop);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState p_180633_3_, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            SmeltingBlockEntity be = (SmeltingBlockEntity)world.getBlockEntity(pos);
            be.forceUpdateAllStates();
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        SmeltingBlockEntity be = (SmeltingBlockEntity)level.getBlockEntity(pos);
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (this.openBlockEntityMenu(level, pos, player)) {
            player.awardStat(be.getInteractStat());
        }
        return InteractionResult.CONSUME;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        SmeltingBlockEntity be = (SmeltingBlockEntity)level.getBlockEntity(blockPos);
        if (this.interactItem(be, level, blockPos, player, interactionHand, player.getItemInHand(interactionHand))) {
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    protected boolean interactItem(SmeltingBlockEntity be, Level level, BlockPos pos, Player player, InteractionHand handIn, ItemStack handItem) {
        UpgradeItem upg;
        Item item = handItem.getItem();
        if (item instanceof UpgradeItem && (upg = (UpgradeItem)item).isValid(be) && !player.isCrouching()) {
            this.interactUpgrade(be, level, pos, player, handIn, handItem);
            return true;
        }
        if (ItemContainerPlatform.isFluidContainer((ItemStack)handItem) && !player.isCrouching()) {
            Bearer fluidAmount = Bearer.of((Object)0);
            if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) && ItemContainerPlatform.getFluid((ItemStack)handItem).getFluid().isSame((Fluid)Fluids.WATER) && ItemContainerPlatform.getFluid((ItemStack)be.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get())).getAmount() <= 3000) {
                fluidAmount.set((Object)FactoryAPIPlatform.getItemFluidHandler((ItemStack)be.getUpgradeSlotItem((Item)ModObjects.GENERATOR.get())).fill(ItemContainerPlatform.drainItem((int)1000, (Player)player, (InteractionHand)handIn), false));
            } else if (be.hasUpgrade((UpgradeItem)((Object)ModObjects.LIQUID.get())) && LiquidFuelUpgradeItem.supportsFluid(ItemContainerPlatform.getFluid((ItemStack)handItem).getFluid())) {
                be.getStorage(FactoryStorage.FLUID, null).ifPresent(e -> {
                    if (e.getTotalSpace() > 0 && e.getFluidInstance().isFluidEqual(ItemContainerPlatform.getFluid((ItemStack)handItem)) || e.getFluidInstance().isEmpty()) {
                        fluidAmount.set((Object)e.fill(ItemContainerPlatform.drainItem((int)e.getTotalSpace(), (Player)player, (InteractionHand)handIn), false));
                    }
                });
            }
            return (Integer)fluidAmount.get() > 0;
        }
        return false;
    }

    protected void interactUpgrade(SmeltingBlockEntity be, Level level, BlockPos pos, Player player, InteractionHand handIn, ItemStack handItem) {
        if (be.hasUpgradeType((UpgradeItem)handItem.getItem())) {
            if (!player.isCreative()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)be.getUpgradeTypeSlotItem((UpgradeItem)handItem.getItem()));
            } else {
                be.getUpgradeTypeSlotItem((UpgradeItem)handItem.getItem()).shrink(1);
            }
        }
        for (int upg : be.getUpgradeIndexes()) {
            if (!((FactoryItemSlot)be.getSlots(null).get(upg)).mayPlace(handItem) || handItem.isEmpty()) continue;
            if (!be.inventory.getItem(upg).isEmpty() && upg == be.getUpgradeIndexes()[be.getUpgradeIndexes().length - 1]) {
                if (!player.isCreative()) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), (ItemStack)be.inventory.getItem(upg));
                } else {
                    be.inventory.getItem(upg).shrink(1);
                }
            }
            if (!be.inventory.getItem(upg).isEmpty()) continue;
            be.inventory.setItem(upg, handItem.copyWithCount(1));
            if (!player.isCreative()) {
                player.getItemInHand(handIn).shrink(1);
            }
            level.playSound(null, be.getBlockPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        be.onUpdateSent();
    }

    @Override
    public void appendHoverText(ItemStack stack, Consumer<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag;
        CompoundTag compoundTag = tag = stack.has(DataComponents.CUSTOM_DATA) ? ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag() : null;
        if (tag != null) {
            if (CompoundTagUtil.getInt((CompoundTag)tag, (String)"type").orElse(0) == 1) {
                tooltip.accept((Component)Component.translatable((String)"tooltip.betterfurnacesreforged.furnace.only", (Object[])new Object[]{((UpgradeItem)((Object)ModObjects.BLAST.get())).getName(ItemStack.EMPTY)}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_RED)));
            } else if (CompoundTagUtil.getInt((CompoundTag)tag, (String)"type").orElse(0) == 2) {
                tooltip.accept((Component)Component.translatable((String)"tooltip.betterfurnacesreforged.furnace.only", (Object[])new Object[]{((UpgradeItem)((Object)ModObjects.SMOKE.get())).getName(ItemStack.EMPTY)}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_RED)));
            }
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            double d7;
            double d6;
            double d5;
            double d4;
            Direction.Axis direction$axis;
            Direction direction;
            double d2;
            double d1;
            double d0;
            int type = (Integer)state.getValue((Property)TYPE);
            if (type == 0 || type == 3) {
                if (world.getBlockEntity(pos) == null) {
                    return;
                }
                if (!(world.getBlockEntity(pos) instanceof SmeltingBlockEntity)) {
                    return;
                }
                d0 = (double)pos.getX() + 0.5;
                d1 = pos.getY();
                d2 = (double)pos.getZ() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                direction$axis = direction.getAxis();
                d4 = rand.nextDouble() * 0.6 - 0.3;
                d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
                d6 = rand.nextDouble() * 6.0 / 16.0;
                d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
            if (type == 1) {
                d0 = (double)pos.getX() + 0.5;
                d1 = pos.getY();
                d2 = (double)pos.getZ() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(d0, d1, d2, SoundEvents.BLASTFURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                direction$axis = direction.getAxis();
                d4 = rand.nextDouble() * 0.6 - 0.3;
                d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
                d6 = rand.nextDouble() * 9.0 / 16.0;
                d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
            if (type == 2) {
                d0 = (double)pos.getX() + 0.5;
                d1 = pos.getY();
                d2 = (double)pos.getZ() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(d0, d1, d2, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1 + 1.1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof SmeltingBlockEntity) {
            SmeltingBlockEntity smeltBe = (SmeltingBlockEntity)blockEntity;
            ItemStack itemStack = player.getMainHandItem();
            this.onRemoveInventoryBlockEntity(level, blockPos, smeltBe, FactoryItemUtil.getEnchantmentLevel((ItemStack)itemStack, (ResourceKey)Enchantments.SILK_TOUCH, (RegistryAccess)level.registryAccess()) == 0 || !itemStack.isCorrectToolForDrops(blockState));
            level.removeBlockEntity(blockPos);
        }
        return super.playerWillDestroy(level, blockPos, blockState, player);
    }

    public BlockState rotate(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)p_185499_2_.rotate((Direction)p_185499_1_.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.rotate(p_185471_2_.getRotation((Direction)p_185471_1_.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
    }

    public boolean isSignalSource(BlockState p_149744_1_) {
        return true;
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        SmeltingBlockEntity be = (SmeltingBlockEntity)level.getBlockEntity(blockPos);
        if (be != null) {
            int i;
            int mode = be.furnaceSettings.getRedstone(0);
            int n = i = !be.hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get())) || mode == 3 || mode == 4 ? AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be.inventory) : 0;
            if (mode != 4) {
                return i;
            }
            return Math.max(i - be.furnaceSettings.getRedstone(1), 0);
        }
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.LIT, COLORED, TYPE});
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get()).create(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return SmeltingBlock.createFurnaceTicker(level, type, (BlockEntityType<? extends SmeltingBlockEntity>)((BlockEntityType)BlockEntityTypes.BETTER_FURNACE_TILE.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createFurnaceTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends SmeltingBlockEntity> blockEntityType1) {
        return level.isClientSide ? null : SmeltingBlock.createTickerHelper(blockEntityType, blockEntityType1, SmeltingBlockEntity::tick);
    }
}

