/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.util.DirectionUtil;

public class FurnaceRenderer
implements BlockEntityRenderer<SmeltingBlockEntity> {
    BlockEntityRendererProvider.Context context;

    public FurnaceRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public static ResourceLocation getFront(int type, boolean active) {
        return FurnaceOverlay.values()[type].getId(active);
    }

    public void render(SmeltingBlockEntity be, float f, PoseStack stack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockRenderDispatcher dispatcher = this.context.getBlockRenderDispatcher();
        BakedModel furnace = (Boolean)be.getBlockState().getValue((Property)SmeltingBlock.COLORED) != false ? FactoryAPIClient.getExtraModel((ResourceLocation)BetterFurnacesReforged.createModLocation("colored_furnace")) : dispatcher.getBlockModel(be.getBlockState());
        BakedModel front = FactoryAPIClient.getExtraModel((ResourceLocation)FurnaceRenderer.getFront((Integer)be.getBlockState().getValue((Property)SmeltingBlock.TYPE), (Boolean)be.getBlockState().getValue((Property)BlockStateProperties.LIT)));
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        stack.mulPose(DirectionUtil.getHorizontalRotation((Direction)((Direction)be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING))));
        stack.translate(-0.5, -0.5, -0.5);
        float[] color = be.getColor();
        dispatcher.getModelRenderer().renderModel(stack.last(), multiBufferSource.getBuffer(Sheets.solidBlockSheet()), be.getBlockState(), furnace, color[0], color[1], color[2], i, j);
        if (be.showOrientation) {
            dispatcher.getModelRenderer().renderModel(stack.last(), multiBufferSource.getBuffer(RenderType.cutoutMipped()), be.getBlockState(), FactoryAPIClient.getExtraModel((ResourceLocation)BetterFurnacesReforged.createModLocation("nsweud")), 1.0f, 1.0f, 1.0f, i, j);
        }
        stack.translate(0.5, 0.5, 0.5);
        stack.scale(1.001f, 1.001f, 1.001f);
        stack.translate(-0.5, -0.5, -0.5);
        dispatcher.getModelRenderer().renderModel(stack.last(), multiBufferSource.getBuffer(Sheets.cutoutBlockSheet()), be.getBlockState(), front, 1.0f, 1.0f, 1.0f, i, j);
        stack.popPose();
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRender(SmeltingBlockEntity be, Vec3 vec) {
        return Vec3.atCenterOf((Vec3i)be.getBlockPos()).multiply(1.0, 0.0, 1.0).closerThan((Position)vec.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }

    public static enum FurnaceOverlay {
        FURNACE("furnace"),
        BLAST("blast"),
        SMOKER("smoker"),
        GENERATOR("generator");

        public final ResourceLocation id;
        public final ResourceLocation activeId;

        private FurnaceOverlay(String id) {
            this.id = BetterFurnacesReforged.createModLocation(id + "_overlay");
            this.activeId = BetterFurnacesReforged.createModLocation(id + "_on_overlay");
        }

        public ResourceLocation getId(boolean active) {
            return active ? this.activeId : this.id;
        }
    }
}

