/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.blockentity.CobblestoneGeneratorBlockEntity;
import wily.betterfurnaces.client.screen.AbstractBasicScreen;
import wily.betterfurnaces.client.screen.BetterFurnacesDrawables;
import wily.betterfurnaces.inventory.CobblestoneGeneratorMenu;
import wily.betterfurnaces.network.CobblestoneGeneratorSyncPayload;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.drawable.FactoryDrawableButton;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.FluidInstance;
import wily.factoryapi.util.FluidRenderUtil;

public class CobblestoneGeneratorScreen
extends AbstractBasicScreen<CobblestoneGeneratorMenu> {
    public static final ResourceLocation GUI = BetterFurnacesReforged.createModLocation("textures/container/cobblestone_generator_gui.png");
    Inventory playerInv;
    Component name;
    public static final FluidInstance waterInstance = FluidInstance.create((Fluid)Fluids.WATER);
    public static final FluidInstance lavaInstance = FluidInstance.create((Fluid)Fluids.LAVA);
    protected FactoryDrawableButton changeRecipeButton;
    protected FactoryDrawableButton autoOutputButton;

    public CobblestoneGeneratorScreen(CobblestoneGeneratorMenu t, Inventory inv, Component name) {
        super(t, inv, name);
        this.playerInv = inv;
        this.name = name;
    }

    @Override
    protected void init() {
        super.init();
        this.titleLabelX = 7 + this.imageWidth / 2 - this.font.width(this.name.getString()) / 2;
        this.changeRecipeButton = (FactoryDrawableButton)((FactoryDrawableButton)new FactoryDrawableButton(this.leftPos + 81, this.topPos + 25, BetterFurnacesDrawables.BUTTON).onPress((b, i) -> CommonNetwork.sendToServer((CommonNetwork.Payload)new CobblestoneGeneratorSyncPayload(((CobblestoneGeneratorMenu)this.getMenu()).getPos(), i == 0 ? CobblestoneGeneratorSyncPayload.Sync.NEXT_RECIPE : CobblestoneGeneratorSyncPayload.Sync.PREVIOUS_RECIPE)))).grave(0.3f);
        this.addNestedRenderable(this.changeRecipeButton);
        this.autoOutputButton = (FactoryDrawableButton)((FactoryDrawableButton)new FactoryDrawableButton(this.leftPos + 9, this.topPos + 55, BetterFurnacesDrawables.SURFACE_BUTTON).icon(BetterFurnacesDrawables.getButtonIcon(1))).onPress((b, i) -> CommonNetwork.sendToServer((CommonNetwork.Payload)new CobblestoneGeneratorSyncPayload(((CobblestoneGeneratorMenu)this.getMenu()).getPos(), ((CobblestoneGeneratorMenu)this.menu).hasAutoOutput() ? CobblestoneGeneratorSyncPayload.Sync.DISABLE_AUTO_OUTPUT : CobblestoneGeneratorSyncPayload.Sync.AUTO_OUTPUT)));
        this.addNestedRenderable(this.autoOutputButton);
    }

    public static void renderStretchedFluid(GuiGraphics graphics, int x, int y, int width, int height, FluidInstance fluid, boolean hasColor) {
        if (hasColor) {
            FactoryGuiGraphics.of((GuiGraphics)graphics).setColor(FluidRenderUtil.getFixedColor((FluidInstance)fluid));
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(x, y, 0, width, height, FactoryAPIClient.getFluidStillTexture((Fluid)fluid.getFluid()));
        if (hasColor) {
            FactoryGuiGraphics.of((GuiGraphics)graphics).clearColor();
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(GUI, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.pose().pushPose();
        graphics.pose().translate((float)(this.leftPos + 88), (float)(this.topPos + 32), 0.0f);
        graphics.pose().scale(0.75f, 0.75f, 0.75f);
        graphics.pose().translate(-8.0f, -8.0f, 0.0f);
        ItemStack result = ((CobblestoneGeneratorBlockEntity)((CobblestoneGeneratorMenu)this.getMenu()).be).getResult();
        graphics.renderItem(result, 0, 0);
        graphics.pose().popPose();
        ((FactoryDrawableButton)this.changeRecipeButton.clearTooltips()).tooltip(result.getHoverName());
        ((FactoryDrawableButton)((FactoryDrawableButton)this.autoOutputButton.select(Boolean.valueOf(((CobblestoneGeneratorMenu)this.menu).hasAutoOutput()))).clearTooltips()).tooltips(List.of(Component.translatable((String)"tooltip.betterfurnacesreforged.gui_auto_output"), Component.translatable((String)("options." + (((CobblestoneGeneratorMenu)this.menu).hasAutoOutput() ? "on" : "off")))));
        int i = ((CobblestoneGeneratorMenu)this.getMenu()).getCobTimeScaled(16);
        if (i > 0) {
            CobblestoneGeneratorScreen.renderStretchedFluid(graphics, this.leftPos + 58, this.topPos + 44, 17, 12, lavaInstance, false);
            CobblestoneGeneratorScreen.renderStretchedFluid(graphics, this.leftPos + 101, this.topPos + 44, 17, 12, waterInstance, true);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blit(GUI, this.leftPos + 58, this.topPos + 44, 176, 24, i + 1, 12);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blit(GUI, this.leftPos + 117 - i, this.topPos + 44, 192 - i, 36, 17, 12);
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(GUI, this.leftPos + 58, this.topPos + 44, 176, 0, 17, 12);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(GUI, this.leftPos + 101, this.topPos + 44, 176, 12, 17, 12);
    }
}

