/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.client.screen;

import com.mojang.blaze3d.platform.Lighting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import wily.betterfurnaces.blocks.ForgeBlock;
import wily.betterfurnaces.client.screen.AbstractUpgradeScreen;
import wily.betterfurnaces.client.screen.BetterFurnacesDrawables;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.items.ColorUpgradeItem;
import wily.betterfurnaces.network.SliderColorSyncPayload;
import wily.factoryapi.base.client.drawable.FactoryDrawableButton;
import wily.factoryapi.base.client.drawable.FactoryDrawableSlider;
import wily.factoryapi.base.network.CommonNetwork;

public class ColorUpgradeScreen
extends AbstractUpgradeScreen<ColorUpgradeItem.ColorUpgradeMenu> {
    private int buttonState = 0;
    protected final FactoryDrawableSlider redSlider = this.createChannelSlider(SliderColorSyncPayload.Channel.R);
    protected final FactoryDrawableSlider greenSlider = this.createChannelSlider(SliderColorSyncPayload.Channel.G);
    protected final FactoryDrawableSlider blueSlider = this.createChannelSlider(SliderColorSyncPayload.Channel.B);
    private ItemStack displayStack = ItemStack.EMPTY;

    public ColorUpgradeScreen(ColorUpgradeItem.ColorUpgradeMenu container, Inventory inv, Component name) {
        super(container, inv, name);
    }

    @Override
    protected void init() {
        super.init();
        this.addNestedRenderable(this.redSlider).setPosition(this.leftPos + 5, this.topPos + 24);
        this.addNestedRenderable(this.greenSlider).setPosition(this.leftPos + 5, this.topPos + 46);
        this.addNestedRenderable(this.blueSlider).setPosition(this.leftPos + 5, this.topPos + 68);
        this.updateDisplayStack();
        this.addNestedRenderable((FactoryDrawableButton)((FactoryDrawableButton)((FactoryDrawableButton)new FactoryDrawableButton(this.leftPos + 8, this.topPos + 8, BetterFurnacesDrawables.BUTTON).icon(BetterFurnacesDrawables.getButtonIcon(12 + this.buttonState))).tooltip((Component)(this.buttonState == 0 ? Blocks.FURNACE : (Block)ModObjects.EXTREME_FORGE.get()).getName())).onPress((b, i) -> {
            this.buttonState = this.buttonState == 1 ? 0 : 1;
            this.updateDisplayStack();
            ((FactoryDrawableButton)((FactoryDrawableButton)b.clearTooltips()).tooltip((Component)(this.buttonState == 0 ? Blocks.FURNACE : (Block)ModObjects.EXTREME_FORGE.get()).getName())).icon(BetterFurnacesDrawables.getButtonIcon(12 + this.buttonState));
        }));
    }

    protected FactoryDrawableSlider createChannelSlider(SliderColorSyncPayload.Channel channel) {
        return (FactoryDrawableSlider)((FactoryDrawableSlider)new FactoryDrawableSlider(0, 0, i -> Component.translatable((String)("gui.betterfurnacesreforged.color." + channel.id)).append("" + i.value), BetterFurnacesDrawables.VANILLA_BUTTON, BetterFurnacesDrawables.VANILLA_BUTTON_BACKGROUND, 8, this.imageWidth - 10, ((ModObjects.BlockTint)((ColorUpgradeItem.ColorUpgradeMenu)this.menu).itemStackBeingHeld.getOrDefault((DataComponentType)ModObjects.BLOCK_TINT.get(), (Object)ModObjects.BlockTint.WHITE)).getChannel(channel), 255).grave(1.0f)).onPress((s, b) -> this.onSliderChange((FactoryDrawableSlider)s, channel));
    }

    protected void onSliderChange(FactoryDrawableSlider slider, SliderColorSyncPayload.Channel channel) {
        this.updateDisplayStack();
        CommonNetwork.sendToServer((CommonNetwork.Payload)new SliderColorSyncPayload(channel, slider.getValue()));
    }

    protected void updateDisplayStack() {
        this.displayStack = new ItemStack((ItemLike)(this.buttonState == 0 ? (ItemLike)ModObjects.EXTREME_FURNACE.get() : ((ForgeBlock)((Object)ModObjects.EXTREME_FORGE.get())).asItem()));
        this.displayStack.set((DataComponentType)ModObjects.BLOCK_TINT.get(), (Object)new ModObjects.BlockTint(this.redSlider.getValue(), this.greenSlider.getValue(), this.blueSlider.getValue()));
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderColorFurnace(graphics);
    }

    protected void renderColorFurnace(GuiGraphics graphics) {
        Lighting.setupFor3DItems();
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.width / 2.0f, (float)(this.topPos - 40), 0.0f);
        graphics.pose().scale(4.0f, 4.0f, 1.0f);
        graphics.pose().translate(-8.0f, -8.0f, 0.0f);
        graphics.renderItem(this.displayStack, 0, 0);
        graphics.pose().popPose();
    }
}

