/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.blockentity.FactoryUpgradeSettings;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.client.screen.AbstractBasicScreen;
import wily.betterfurnaces.client.screen.BetterFurnacesDrawables;
import wily.betterfurnaces.client.screen.FactoryUpgradeWindow;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.SmeltingMenu;
import wily.betterfurnaces.items.FactoryUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.betterfurnaces.network.ShowSettingsSyncPayload;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.drawable.AbstractDrawableButton;
import wily.factoryapi.base.client.drawable.DrawableStatic;
import wily.factoryapi.base.client.drawable.DrawableStaticProgress;
import wily.factoryapi.base.client.drawable.FactoryDrawableButton;
import wily.factoryapi.base.client.drawable.IFactoryDrawableType;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.util.StorageStringUtil;

public class SmeltingScreen<T extends SmeltingMenu>
extends AbstractBasicScreen<T> {
    public static final ResourceLocation GUI = BetterFurnacesReforged.createModLocation("textures/container/furnace_gui.png");
    Inventory playerInv;
    private FactoryDrawableButton showConfigButton;

    public SmeltingScreen(T t, Inventory inv, Component name) {
        super(t, inv, name);
        this.playerInv = inv;
    }

    public ResourceLocation getGuiLocation() {
        return GUI;
    }

    protected int factoryShowButtonY() {
        return 3;
    }

    protected DrawableStatic fluidTankType() {
        return BetterFurnacesDrawables.FLUID_TANK.createStatic(this.leftPos + 73, this.topPos + 49);
    }

    protected DrawableStaticProgress energyTankType() {
        int[] nArray;
        if (((SmeltingBlockEntity)((SmeltingMenu)this.menu).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            int[] nArray2 = new int[2];
            nArray2[0] = 116;
            nArray = nArray2;
            nArray2[1] = 26;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = ((SmeltingBlockEntity)((SmeltingMenu)this.menu).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get())) ? 26 : 31;
            nArray = nArray3;
            nArray3[1] = 17;
        }
        int[] pos = nArray;
        return (((SmeltingBlockEntity)((SmeltingMenu)this.menu).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get())) ? BetterFurnacesDrawables.THIN_ENERGY_CELL : BetterFurnacesDrawables.ENERGY_CELL).createStatic(this.leftPos + pos[0], this.topPos + pos[1]);
    }

    protected DrawableStatic generatorTankType() {
        return BetterFurnacesDrawables.MINI_FLUID_TANK.createStatic(this.leftPos + 54, this.topPos + 18);
    }

    protected DrawableStatic xpTankType() {
        return BetterFurnacesDrawables.MINI_FLUID_TANK.createStatic(this.leftPos + 73, this.topPos + 49);
    }

    public boolean storedFactoryUpgradeType(int type) {
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.FACTORY.get()))) {
            FactoryUpgradeItem stack = (FactoryUpgradeItem)((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).getUpgradeTypeSlotItem((UpgradeItem)((Object)ModObjects.FACTORY.get())).getItem();
            return switch (type) {
                case 1 -> stack.canInput;
                case 2 -> stack.canOutput;
                case 3 -> stack.pipeSide;
                case 4 -> stack.redstoneSignal;
                default -> true;
            };
        }
        return false;
    }

    @Override
    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.minecraft.font.width(this.getTitle().getString())) / 2;
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).isForge()) {
            this.inventoryLabelX = (this.imageWidth - this.minecraft.font.width(this.playerInventoryTitle.getString())) / 2;
        }
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelY = this.imageHeight - 160;
        this.showConfigButton = this.addNestedRenderable((FactoryDrawableButton)((FactoryDrawableButton)((FactoryDrawableButton)new FactoryDrawableButton(this.leftPos + 7, this.topPos + this.factoryShowButtonY(), BetterFurnacesDrawables.FACTORY_BUTTON).selection(IFactoryDrawableType.Direction.HORIZONTAL)).visible(() -> this.storedFactoryUpgradeType(0))).onPress((b, i) -> CommonNetwork.sendToServer((CommonNetwork.Payload)new ShowSettingsSyncPayload(((SmeltingMenu)this.getMenu()).getPos(), b.isSelected() ? 1 : 0))));
        this.addNestedRenderable(new FactoryUpgradeWindow((AbstractDrawableButton<?>)this.showConfigButton, this.leftPos - 53, this.topPos + this.factoryShowButtonY(), this));
    }

    @Override
    public void render(GuiGraphics graphics, int i, int j, float f) {
        this.showConfigButton.select(Boolean.valueOf(((SmeltingMenu)this.getMenu()).showInventoryButtons()));
        if (this.showConfigButton.isSelected()) {
            this.showConfigButton.tooltips(SmeltingScreen.getShiftInfoGui());
        } else {
            this.showConfigButton.tooltip((Component)Component.translatable((String)"tooltip.betterfurnacesreforged.gui_open"));
        }
        super.render(graphics, i, j, f);
        this.showConfigButton.clearTooltips();
    }

    public static List<Component> getShiftInfoGui() {
        ArrayList list = Lists.newArrayList();
        list.add(Component.translatable((String)"tooltip.betterfurnacesreforged.gui_close"));
        MutableComponent tooltip1 = Component.translatable((String)"tooltip.betterfurnacesreforged.gui_hold_shift");
        MutableComponent shift = Component.literal((String)"[Shift]");
        MutableComponent tooltip2 = Component.translatable((String)"tooltip.betterfurnacesreforged.gui_shift_more_options");
        tooltip1.withStyle(ChatFormatting.GRAY);
        shift.withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC});
        tooltip2.withStyle(ChatFormatting.GRAY);
        list.add(tooltip1.append((Component)shift).append((Component)tooltip2));
        return list;
    }

    public Component getTitle() {
        return ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).getName();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.getTitle(), this.titleLabelX, this.titleLabelY, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        int actualMouseX = mouseX - this.leftPos;
        int actualMouseY = mouseY - this.topPos;
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).isLiquid() && this.fluidTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            graphics.renderTooltip(this.font, StorageStringUtil.getFluidTooltip((String)"tooltip.factory_api.fluid_stored", (IPlatformFluidHandler)((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).fluidTank), actualMouseX, actualMouseY);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get())) && this.generatorTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            ItemStack gen = ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
            graphics.renderTooltip(this.font, StorageStringUtil.getFluidTooltip((String)"tooltip.factory_api.fluid_stored", (IPlatformFluidHandler)FactoryAPIPlatform.getItemFluidHandler((ItemStack)gen)), actualMouseX, actualMouseY);
        }
        if ((((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) || ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) && this.energyTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            graphics.renderTooltip(this.font, (Component)StorageStringUtil.getEnergyTooltip((String)"tooltip.factory_api.energy_stored", (IPlatformEnergyStorage)((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).energyStorage), actualMouseX, actualMouseY);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasXPTank() && this.xpTankType().inMouseLimit((double)mouseX, (double)mouseY)) {
            graphics.renderTooltip(this.font, StorageStringUtil.getFluidTooltip((String)"tooltip.factory_api.fluid_stored", (IPlatformFluidHandler)((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).xpTank), actualMouseX, actualMouseY);
        }
    }

    protected void blitSmeltingSprites(GuiGraphics graphics) {
        int i;
        if (((SmeltingMenu)this.getMenu()).getBurnTime() > 0) {
            i = ((SmeltingMenu)this.getMenu()).getBurnLeftScaled(13);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blit(this.getGuiLocation(), this.leftPos + 55, this.topPos + 37 + 12 - i, 176, 12 - i, 14, i + 1);
        }
        i = ((SmeltingMenu)this.getMenu()).getCookScaled(24);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(this.getGuiLocation(), this.leftPos + 79, this.topPos + 34, 176, 14, i + 1, 16);
        BetterFurnacesDrawables.SLOT.draw(graphics, this.leftPos + 53, this.topPos + 17);
        boolean storage = ((SmeltingBlockEntity)((SmeltingMenu)this.menu).be).hasUpgrade((UpgradeItem)((Object)ModObjects.STORAGE.get()));
        if (storage) {
            BetterFurnacesDrawables.SLOT.draw(graphics, this.leftPos + 35, this.topPos + 17);
            BetterFurnacesDrawables.SLOT.draw(graphics, this.leftPos + 35, this.topPos + 53);
        }
        if (!((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            BetterFurnacesDrawables.BIG_SLOT.draw(graphics, this.leftPos + 111, this.topPos + 30);
            if (storage) {
                BetterFurnacesDrawables.SLOT.draw(graphics, this.leftPos + 137, this.topPos + 34);
            }
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FactoryGuiGraphics.of((GuiGraphics)graphics).blit(this.getGuiLocation(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.blitSmeltingSprites(graphics);
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get())) || ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            boolean storage = ((SmeltingBlockEntity)((SmeltingMenu)this.menu).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()));
            FactoryGuiGraphics.of((GuiGraphics)graphics).blit(BetterFurnacesDrawables.WIDGETS, this.energyTankType().getX(), this.energyTankType().getY(), 240 + (storage ? 8 : 0), 34 * (storage ? 2 : 1), 16 - (storage ? 8 : 0), 34);
            this.energyTankType().drawProgress(graphics, ((SmeltingMenu)this.getMenu()).getEnergyStored(), ((SmeltingMenu)this.getMenu()).getMaxEnergyStored());
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).isLiquid()) {
            FactoryGuiGraphics.of((GuiGraphics)graphics).blit(BetterFurnacesDrawables.WIDGETS, this.fluidTankType().getX(), this.fluidTankType().getY(), 192, 38, 20, 22);
            this.fluidTankType().drawAsFluidTank(graphics, ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).fluidTank.getFluidInstance(), ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).fluidTank.getMaxFluid(), true);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasXPTank()) {
            FactoryGuiGraphics.of((GuiGraphics)graphics).blit(BetterFurnacesDrawables.WIDGETS, this.xpTankType().getX(), this.xpTankType().getY(), 208, 0, 16, 16);
            this.xpTankType().drawAsFluidTank(graphics, ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).xpTank.getFluidInstance(), 1, true);
        }
        if (((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            ItemStack generatorUp = ((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).getUpgradeSlotItem((Item)ModObjects.GENERATOR.get());
            this.generatorTankType().drawAsFluidTank(graphics, FactoryAPIPlatform.getItemFluidHandler((ItemStack)generatorUp).getFluidInstance(), 4000, true);
        }
        if (this.storedFactoryUpgradeType(3) && this.showConfigButton.isSelected()) {
            boolean input = false;
            boolean output = false;
            boolean both = false;
            boolean fuel = false;
            for (int set : ((SmeltingBlockEntity)((SmeltingMenu)this.menu).be).furnaceSettings.getFurnaceSetting(FactoryUpgradeSettings.Type.SIDES)) {
                if (set == 1) {
                    input = true;
                    continue;
                }
                if (set == 2) {
                    output = true;
                    continue;
                }
                if (set == 3) {
                    both = true;
                    continue;
                }
                if (set != 4) continue;
                fuel = true;
            }
            this.blitSlotsLayer(graphics, input, both, fuel, output);
        }
    }

    protected void blitSlotsLayer(GuiGraphics graphics, boolean input, boolean both, boolean fuel, boolean output) {
        boolean storage = ((SmeltingBlockEntity)((SmeltingMenu)this.menu).be).hasUpgradeType((UpgradeItem)((Object)ModObjects.STORAGE.get()));
        if (!((SmeltingBlockEntity)((SmeltingMenu)this.getMenu()).be).hasUpgrade((UpgradeItem)((Object)ModObjects.GENERATOR.get()))) {
            if (input || both) {
                if (storage) {
                    BetterFurnacesDrawables.INPUT_SLOT_OUTLINE.draw(graphics, this.leftPos + 35, this.topPos + 17);
                }
                BetterFurnacesDrawables.INPUT_SLOT_OUTLINE.draw(graphics, this.leftPos + 53, this.topPos + 17);
            }
            if (output || both) {
                if (storage) {
                    BetterFurnacesDrawables.OUTPUT_SLOT_OUTLINE.draw(graphics, this.leftPos + 137, this.topPos + 34);
                }
                BetterFurnacesDrawables.BIG_OUTPUT_SLOT_OUTLINE.draw(graphics, this.leftPos + 111, this.topPos + 30);
            }
        }
        if (fuel) {
            if (storage) {
                BetterFurnacesDrawables.FUEL_SLOT_OUTLINE.draw(graphics, this.leftPos + 35, this.topPos + 53);
            }
            BetterFurnacesDrawables.FUEL_SLOT_OUTLINE.draw(graphics, this.leftPos + 53, this.topPos + 53);
        }
    }
}

