/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.inventory;

import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.HideableSlot;
import wily.betterfurnaces.items.LiquidFuelUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FuelManager;

public class SlotFuel
extends HideableSlot {
    public SlotFuel(InventoryBlockEntity be, int index, int x, int y) {
        super(be, index, x, y);
    }

    public SlotFuel(InventoryBlockEntity be, int index, int x, int y, Predicate<FactoryItemSlot> isActive) {
        super(be, index, x, y, isActive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayPlace(ItemStack stack) {
        if (!super.mayPlace(stack)) return false;
        if (stack.getItem() instanceof UpgradeItem) return false;
        if (FuelManager.isFuel((ItemStack)stack)) return true;
        InventoryBlockEntity inventoryBlockEntity = this.be;
        if (inventoryBlockEntity instanceof SmeltingBlockEntity) {
            SmeltingBlockEntity smeltBe = (SmeltingBlockEntity)inventoryBlockEntity;
            if (ItemContainerPlatform.isEnergyContainer((ItemStack)stack)) {
                if (smeltBe.hasUpgrade((UpgradeItem)((Object)ModObjects.ENERGY.get()))) return true;
            }
        }
        if (ItemContainerPlatform.isFluidContainer((ItemStack)stack)) return true;
        if (!LiquidFuelUpgradeItem.supportsItemFluidHandler(stack)) return false;
        return true;
    }

    public int getMaxStackSize(ItemStack stack) {
        return ItemContainerPlatform.isFluidContainer((ItemStack)stack) ? 1 : super.getMaxStackSize(stack);
    }
}

