/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;

public class SlotUpgrade
extends FactoryItemSlot {
    private final InventoryBlockEntity be;

    public SlotUpgrade(InventoryBlockEntity be, int slotIndex, int xPosition, int yPosition) {
        super((Container)be.inventory, SlotsIdentifier.GENERIC, TransportState.EXTRACT_INSERT, slotIndex, xPosition, yPosition);
        this.be = be;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mayPlace(ItemStack stack) {
        InventoryBlockEntity inventoryBlockEntity = this.be;
        if (!(inventoryBlockEntity instanceof SmeltingBlockEntity)) return false;
        SmeltingBlockEntity s = (SmeltingBlockEntity)inventoryBlockEntity;
        inventoryBlockEntity = stack.getItem();
        if (!(inventoryBlockEntity instanceof UpgradeItem)) return false;
        UpgradeItem upg = (UpgradeItem)((Object)inventoryBlockEntity);
        if (s.hasUpgrade(upg)) return false;
        if (s.isForge()) {
            if (upg.upgradeType == UpgradeItem.Type.ALTERNATIVE_FUEL) return false;
        }
        if (!upg.isValid(s)) return false;
        if (!s.hasUpgradeType((UpgradeItem)stack.getItem())) return true;
        inventoryBlockEntity = this.be.inventory.getItem(this.index).getItem();
        if (!(inventoryBlockEntity instanceof UpgradeItem)) return false;
        UpgradeItem upg2 = (UpgradeItem)((Object)inventoryBlockEntity);
        if (!upg2.isSameType(upg)) return false;
        return true;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public void setChanged() {
        InventoryBlockEntity inventoryBlockEntity = this.be;
        if (inventoryBlockEntity instanceof SmeltingBlockEntity) {
            SmeltingBlockEntity smeltingBe = (SmeltingBlockEntity)inventoryBlockEntity;
            smeltingBe.onUpdateSent();
        }
    }
}

