/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.items;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.AbstractUpgradeMenu;
import wily.betterfurnaces.items.UpgradeItem;

public class ColorUpgradeItem
extends UpgradeItem {
    public ColorUpgradeItem(Item.Properties properties, String tooltip) {
        super(properties, UpgradeItem.Type.COLOR, tooltip);
    }

    public static boolean itemContainsColor(ItemStack stack) {
        return stack.has((DataComponentType)ModObjects.BLOCK_TINT.get());
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        if (entity instanceof ServerPlayer) {
            ItemStack stack = entity.getItemInHand(InteractionHand.MAIN_HAND);
            entity.openMenu((MenuProvider)new SimpleMenuProvider((window, inv, player) -> new ColorUpgradeMenu(window, inv), stack.getHoverName()));
        }
        return ar;
    }

    public static class ColorUpgradeMenu
    extends AbstractUpgradeMenu {
        public ColorUpgradeMenu(int windowId, Inventory playerInv) {
            super((MenuType)ModObjects.COLOR_UPGRADE_CONTAINER.get(), windowId, playerInv, playerInv.player.getMainHandItem());
        }

        public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
            return null;
        }
    }
}

