/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.items;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import wily.betterfurnaces.blockentity.ForgeBlockEntity;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.IFluidHandlerItem;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.util.FluidInstance;

public class GeneratorUpgradeItem
extends UpgradeItem
implements IFluidHandlerItem<IPlatformFluidHandler> {
    public GeneratorUpgradeItem(Item.Properties properties) {
        super(properties, UpgradeItem.Type.MODE, (Component)Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.generator", (Object[])new Object[]{FactoryAPIPlatform.getPlatformEnergyComponent().getString()}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
    }

    public int getCapacity() {
        return 4000;
    }

    public boolean isFluidValid(FluidInstance fluidInstance) {
        return fluidInstance.getFluid().isSame((Fluid)Fluids.WATER);
    }

    @Override
    public boolean isValid(SmeltingBlockEntity blockEntity) {
        return super.isValid(blockEntity) && !(blockEntity instanceof ForgeBlockEntity);
    }

    @Override
    public boolean isUpgradeCompatibleWith(UpgradeItem upg) {
        return upg != ModObjects.ENERGY.get() && upg.upgradeType != UpgradeItem.Type.ORE && upg.upgradeType != UpgradeItem.Type.XP && upg.upgradeType != UpgradeItem.Type.STORAGE;
    }
}

