/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.items;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import wily.betterfurnaces.items.UpgradeItem;

public class OreProcessingUpgradeItem
extends UpgradeItem {
    public final int multiplier;
    public final boolean acceptOre;
    public final boolean acceptRaw;

    public OreProcessingUpgradeItem(Item.Properties properties, int multiplier, boolean acceptOre, boolean acceptRaw) {
        super(properties, UpgradeItem.Type.ORE);
        this.multiplier = multiplier;
        this.acceptOre = acceptOre;
        this.acceptRaw = acceptRaw;
    }

    @Override
    public boolean isUpgradeCompatibleWith(UpgradeItem upg) {
        return upg.upgradeType != UpgradeItem.Type.MODE;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Consumer<Component> consumer, TooltipFlag flagIn) {
        super.appendHoverText(itemStack, consumer, flagIn);
        String i = !itemStack.isDamageableItem() ? Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.infinitely").getString() : "";
        String o = this.acceptOre && !this.acceptRaw ? Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.ore").getString() : Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.raw").getString();
        if (this.acceptRaw && this.acceptOre) {
            o = Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.allore").getString();
        }
        String s = this.multiplier == 2 ? Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.double").getString() : (this.multiplier == 4 ? Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.quadruple").getString() : (this.multiplier > 4 ? Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.multiple").getString() : ""));
        consumer.accept((Component)Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.ores", (Object[])new Object[]{s, i, o}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
    }
}

