/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.items;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.items.UpgradeItem;
import wily.betterfurnaces.util.BFRComponents;
import wily.factoryapi.util.CompoundTagUtil;

public class TierUpgradeItem
extends UpgradeItem {
    public Block from;
    public Block to;

    public TierUpgradeItem(Item.Properties properties, Block from, Block to) {
        super(properties, UpgradeItem.Type.TIER, (Component)Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.tier", (Object[])new Object[]{from.getName(), to.getName()}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
        this.from = from;
        this.to = to;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Consumer<Component> consumer, TooltipFlag flagIn) {
        consumer.accept(BFRComponents.UPGRADE_SHIFT_RIGHT_CLICK);
        consumer.accept(this.tooltip);
    }

    @Override
    public boolean isValid(SmeltingBlockEntity blockEntity) {
        return false;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        if (!level.isClientSide) {
            BlockEntity fromBe = level.getBlockEntity(pos);
            BlockPlaceContext ctx2 = new BlockPlaceContext(ctx);
            BlockState state = level.getBlockState(pos);
            if (state.is(this.from) && (fromBe instanceof FurnaceBlockEntity || fromBe instanceof SmeltingBlockEntity)) {
                CompoundTag tag = fromBe.saveWithoutMetadata((HolderLookup.Provider)ctx.getLevel().registryAccess());
                level.removeBlockEntity(pos);
                level.removeBlock(pos, false);
                level.setBlock(pos, (BlockState)this.to.getStateForPlacement(ctx2).setValue((Property)BlockStateProperties.LIT, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.LIT))), 3);
                SmeltingBlockEntity toBe = (SmeltingBlockEntity)level.getBlockEntity(pos);
                level.blockEntityChanged(pos);
                if (fromBe instanceof FurnaceBlockEntity) {
                    toBe.inventory.deserializeTag(tag);
                }
                tag.putInt("BurnTime", (int)((float)CompoundTagUtil.getInt((CompoundTag)tag, (String)"BurnTime").orElse(0).intValue() * (float)toBe.getDefaultCookTime() / (float)Math.max(1, CompoundTagUtil.getInt((CompoundTag)tag, (String)"CookTimeTotal").orElse(0))));
                toBe.loadAdditional(toBe.saveWithoutMetadata((HolderLookup.Provider)ctx.getLevel().registryAccess()).merge(tag), (HolderLookup.Provider)ctx.getLevel().registryAccess());
                if (!ctx.getPlayer().isCreative()) {
                    ctx.getItemInHand().shrink(1);
                }
                level.playSound(null, toBe.getBlockPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_NETHERITE.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(ctx);
    }
}

