/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import it.unimi.dsi.fastutil.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blocks.CobblestoneGeneratorBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.CobblestoneGeneratorMenu;
import wily.betterfurnaces.inventory.SlotOutput;
import wily.betterfurnaces.inventory.SlotUpgrade;
import wily.betterfurnaces.items.FuelEfficiencyUpgradeItem;
import wily.betterfurnaces.items.OreProcessingUpgradeItem;
import wily.betterfurnaces.recipes.CobblestoneGeneratorRecipe;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.base.network.CommonRecipeManager;
import wily.factoryapi.util.CompoundTagUtil;
import wily.factoryapi.util.FactoryItemUtil;
import wily.factoryapi.util.FluidInstance;

public class CobblestoneGeneratorBlockEntity
extends InventoryBlockEntity {
    public static List<RecipeHolder<CobblestoneGeneratorRecipe>> recipes;
    protected CobblestoneGeneratorRecipe recipe;
    public static Predicate<ItemStack> HAS_LAVA;
    public static Predicate<ItemStack> HAS_WATER;
    public final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> CobblestoneGeneratorBlockEntity.this.cobTime;
                case 1 -> CobblestoneGeneratorBlockEntity.this.resultType;
                case 2 -> CobblestoneGeneratorBlockEntity.this.actualCobTime;
                case 3 -> {
                    if (CobblestoneGeneratorBlockEntity.this.autoOutput) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    CobblestoneGeneratorBlockEntity.this.cobTime = value;
                    break;
                }
                case 1: {
                    CobblestoneGeneratorBlockEntity.this.resultType = value;
                    break;
                }
                case 2: {
                    CobblestoneGeneratorBlockEntity.this.actualCobTime = value;
                    break;
                }
                case 3: {
                    CobblestoneGeneratorBlockEntity.this.autoOutput = value == 1;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    public static final int INPUT = 0;
    public static final int INPUT1 = 1;
    public static final int OUTPUT = 2;
    public static final int UPGRADE = 3;
    public static final int UPGRADE1 = 4;
    private int cobTime;
    private int actualCobTime = this.getCobTime();
    public int resultType = 0;
    public boolean autoOutput = false;

    @Override
    public Pair<int[], TransportState> getSlotsTransport(Direction side) {
        return Pair.of((Object)new int[0], (Object)TransportState.EXTRACT);
    }

    public static boolean hasFluidAsBucket(ItemStack stack, Fluid fluid) {
        return ItemContainerPlatform.isFluidContainer((ItemStack)stack) && ItemContainerPlatform.getFluid((ItemStack)stack).isFluidEqual(FluidInstance.create((Fluid)fluid, (int)1000));
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack) {
        return index == 2;
    }

    @Override
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory) {
        return new CobblestoneGeneratorMenu(i, this.level, this.worldPosition, playerInventory, this.fields);
    }

    public CobblestoneGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.COB_GENERATOR_TILE.get(), pos, state);
    }

    public boolean hasAutoOutput() {
        return this.autoOutput;
    }

    public void forceUpdateAllStates() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (((Integer)state.getValue((Property)CobblestoneGeneratorBlock.TYPE)).intValue() != this.cobGen()) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)CobblestoneGeneratorBlock.TYPE, (Comparable)Integer.valueOf(this.cobGen())), 3);
        }
    }

    protected List<RecipeHolder<CobblestoneGeneratorRecipe>> getSortedCobRecipes() {
        return CommonRecipeManager.byType((RecipeType)((RecipeType)ModObjects.ROCK_GENERATING_RECIPE.get())).stream().sorted(Comparator.comparing(o -> o.id().location().getPath())).toList();
    }

    public void initRecipes() {
        recipes = this.getSortedCobRecipes();
    }

    public void setRecipe(int index) {
        if (this.level != null) {
            this.recipe = (CobblestoneGeneratorRecipe)((RecipeHolder)Objects.requireNonNullElseGet(recipes, this::getSortedCobRecipes).get(index)).value();
        }
    }

    public void changeRecipe(boolean next) {
        if (recipes != null) {
            int newIndex = this.resultType + (next ? 1 : -1);
            if (newIndex > recipes.size() - 1) {
                newIndex = 0;
            }
            if (newIndex < 0) {
                newIndex = recipes.size() - 1;
            }
            this.setRecipe(newIndex);
            this.resultType = newIndex;
            this.updateBlockState();
        }
    }

    public void tick(BlockState state) {
        if (recipes == null) {
            this.initRecipes();
        }
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipe == null && recipes != null || this.level.isClientSide && recipes.indexOf(this.recipe) != this.resultType) {
            this.setRecipe(this.resultType);
            this.updateBlockState();
        }
        if (!this.level.isClientSide) {
            boolean can3;
            if (this.actualCobTime != this.getCobTime()) {
                this.actualCobTime = this.getCobTime();
            }
            if (this.cobTime > this.getCobTime()) {
                this.cobTime = this.getCobTime();
            }
            if (!this.getLevel().isClientSide) {
                this.forceUpdateAllStates();
            }
            ItemStack output = this.inventory.getItem(2);
            ItemStack upgrade = this.inventory.getItem(3);
            ItemStack upgrade1 = this.inventory.getItem(4);
            boolean active = true;
            for (Direction side : Direction.values()) {
                if (this.level.getSignal(this.worldPosition.relative(side), side) <= 0) continue;
                active = false;
            }
            boolean can = output.getCount() + 1 <= output.getMaxStackSize();
            boolean can1 = output.isEmpty();
            boolean bl = can3 = output.getItem() == this.getResult().getItem();
            if ((this.cobGen() == 3 || this.cobTime > 0 && this.cobTime < this.actualCobTime) && active && (can && can3 || can1)) {
                ++this.cobTime;
            }
            if (this.cobTime >= this.getCobTime() && (can && can3 || can1)) {
                if (can1) {
                    this.getInv().setItem(2, this.getResult());
                } else {
                    output.grow(this.getResult().getCount());
                }
                if (upgrade1.getItem() == ModObjects.ORE_PROCESSING.get()) {
                    this.breakDurabilityItem(upgrade1);
                }
                this.level.playSound(null, this.getBlockPos(), SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.3f, 0.3f);
                if (upgrade.getItem() == ModObjects.FUEL.get()) {
                    this.breakDurabilityItem(upgrade);
                }
                this.cobTime = 0;
                RandomSource rand = this.level.random;
                double d0 = (double)this.worldPosition.getX() + 0.5;
                double d1 = (double)this.worldPosition.getY() + 0.5;
                double d2 = (double)this.worldPosition.getZ() + 0.5;
                Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                Direction.Axis direction$axis = direction.getAxis();
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
                double d6 = rand.nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
                for (int i = 0; i < 6; ++i) {
                    ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0 + d5, d1 + d6, d2 + d7, 0, 0.0, 0.0, 0.0, 1.0);
                }
            }
            if (!output.isEmpty() && this.hasAutoOutput()) {
                CobblestoneGeneratorBlockEntity.handleAutoOutput(this, 2);
            }
        }
    }

    protected int cobGen() {
        ItemStack input = this.getInv().getItem(0);
        ItemStack input1 = this.getInv().getItem(1);
        if (HAS_LAVA.test(input) && input1.isEmpty()) {
            return 1;
        }
        if (HAS_WATER.test(input1) && input.isEmpty()) {
            return 2;
        }
        if (HAS_LAVA.test(input) && HAS_WATER.test(input1)) {
            return 3;
        }
        return 0;
    }

    protected int getFuelEfficiencyMultiplier() {
        ItemStack upgrade = this.inventory.getItem(3);
        if (!upgrade.isEmpty() && upgrade.getItem() instanceof FuelEfficiencyUpgradeItem) {
            return 2;
        }
        return 1;
    }

    protected int getCobTime() {
        if (this.recipe != null) {
            return this.recipe.duration() / this.getFuelEfficiencyMultiplier();
        }
        return -1;
    }

    public ItemStack getResult() {
        return this.recipe == null ? new ItemStack((ItemLike)Items.COBBLESTONE, this.getResultCount()) : this.recipe.result().copyWithCount(this.getResultCount());
    }

    protected int getResultCount() {
        ItemStack upgrade1 = this.inventory.getItem(4);
        if (upgrade1.getItem() instanceof OreProcessingUpgradeItem) {
            return 2;
        }
        return 1;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.cobTime = CompoundTagUtil.getInt((CompoundTag)tag, (String)"CobTime").orElse(0);
        this.resultType = CompoundTagUtil.getInt((CompoundTag)tag, (String)"ResultType").orElse(0);
        this.actualCobTime = CompoundTagUtil.getInt((CompoundTag)tag, (String)"ActualCobTime").orElse(0);
        this.autoOutput = CompoundTagUtil.getBoolean((CompoundTag)tag, (String)"autoOutput").orElse(false);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("CobTime", this.cobTime);
        tag.putInt("ResultType", this.resultType);
        tag.putInt("ActualCobTime", this.actualCobTime);
        tag.putBoolean("autoOutput", this.autoOutput);
        super.saveAdditional(tag, provider);
    }

    public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(FactoryStorage<T> storage, Direction facing) {
        if (!this.isRemoved() && storage == FactoryStorage.ITEM) {
            return () -> this.inventory;
        }
        return ArbitrarySupplier.empty();
    }

    @Override
    public void addSlots(Consumer<FactoryItemSlot> slots, @Nullable Player player) {
        slots.accept(new FactoryItemSlot(this, (Container)this.getInv(), SlotsIdentifier.LAVA, TransportState.INSERT, 0, 53, 27){

            public boolean mayPlace(ItemStack stack) {
                return HAS_LAVA.test(stack);
            }
        });
        slots.accept(new FactoryItemSlot(this, (Container)this.getInv(), SlotsIdentifier.WATER, TransportState.INSERT, 1, 108, 27){

            public boolean mayPlace(ItemStack stack) {
                return HAS_WATER.test(stack);
            }
        });
        slots.accept(new SlotOutput(player, this, 2, 80, 45));
        slots.accept(new SlotUpgrade(this, this, 3, 8, 18){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof FuelEfficiencyUpgradeItem;
            }
        });
        slots.accept(new SlotUpgrade(this, this, 4, 8, 36){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof OreProcessingUpgradeItem;
            }
        });
    }

    public static void handleAutoOutput(InventoryBlockEntity be, int output) {
        for (Direction dir : Direction.values()) {
            IPlatformItemHandler other;
            BlockEntity tile = be.getLevel().getBlockEntity(be.getBlockPos().relative(dir));
            if (tile == null || (other = (IPlatformItemHandler)FactoryAPIPlatform.getPlatformFactoryStorage((BlockEntity)tile).getStorage(FactoryStorage.ITEM, dir.getOpposite()).get()) == null || be.inventory.getItem(output).isEmpty() || BuiltInRegistries.BLOCK.getKey((Object)tile.getBlockState().getBlock()).getNamespace().equals("storagedrawers")) continue;
            for (int i = 0; i < other.getContainerSize(); ++i) {
                ItemStack stack = be.inventory.extractItem(output, be.inventory.getItem(output).getMaxStackSize() - other.getItem(i).getCount(), true);
                if (!other.canPlaceItem(i, stack) || !other.getItem(i).isEmpty() && (!other.canPlaceItem(i, stack) || !FactoryItemUtil.equalItems((ItemStack)other.getItem(i), (ItemStack)stack) || other.getItem(i).getCount() + stack.getCount() > other.getMaxStackSize())) continue;
                be.inventory.setItem(output, other.insertItem(i, stack, false));
            }
        }
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
    }

    static {
        HAS_LAVA = s -> CobblestoneGeneratorBlockEntity.hasFluidAsBucket(s, (Fluid)Fluids.LAVA);
        HAS_WATER = s -> CobblestoneGeneratorBlockEntity.hasFluidAsBucket(s, (Fluid)Fluids.WATER);
    }
}

