/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import it.unimi.dsi.fastutil.Pair;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.inventory.FuelVerifierMenu;
import wily.betterfurnaces.inventory.SlotFuel;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.FuelManager;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.CompoundTagUtil;

public class FuelVerifierBlockEntity
extends InventoryBlockEntity {
    public final ContainerData fields = new ContainerData(){

        public int get(int index) {
            if (index == 0) {
                return FuelVerifierBlockEntity.this.burnTime;
            }
            return 0;
        }

        public void set(int index, int value) {
            FuelVerifierBlockEntity.this.burnTime = value;
        }

        public int getCount() {
            return 1;
        }
    };
    private int burnTime;

    @Override
    public Pair<int[], TransportState> getSlotsTransport(Direction side) {
        return Pair.of((Object)new int[0], (Object)TransportState.EXTRACT);
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack) {
        return false;
    }

    @Override
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory) {
        return new FuelVerifierMenu(i, this.level, this.worldPosition, playerInventory, this.fields);
    }

    public FuelVerifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityTypes.FUEL_VERIFIER_TILE.get(), pos, state);
    }

    public void tick(BlockState blockState) {
        if (!this.level.isClientSide) {
            ItemStack fuel = this.inventory.getItem(0);
            this.burnTime = !fuel.isEmpty() ? FuelManager.getBurnTime((ItemStack)fuel) : 0;
        }
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.burnTime = CompoundTagUtil.getInt((CompoundTag)tag, (String)"BurnTime").orElse(0);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("BurnTime", this.burnTime);
        super.saveAdditional(tag, provider);
    }

    public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(FactoryStorage<T> storage, Direction facing) {
        if (!this.isRemoved() && storage == FactoryStorage.ITEM) {
            return () -> this.inventory;
        }
        return ArbitrarySupplier.empty();
    }

    @Override
    public void addSlots(Consumer<FactoryItemSlot> slots, @Nullable Player player) {
        slots.accept(new SlotFuel(this, 0, 80, 48));
    }
}

