/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import wily.betterfurnaces.blockentity.IInventoryBlockEntity;
import wily.factoryapi.base.FactoryItemHandler;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.CompoundTagUtil;

public abstract class InventoryBlockEntity
extends BlockEntity
implements IInventoryBlockEntity,
MenuProvider,
Nameable,
IFactoryStorage {
    private final NonNullList<FactoryItemSlot> slots = this.createSlots(null);
    public final FactoryItemHandler inventory = new FactoryItemHandler(this.getInventorySize(), this, TransportState.EXTRACT_INSERT){

        public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
            return super.canTakeItem(container, i, itemStack) && InventoryBlockEntity.this.IcanExtractItem(i, itemStack);
        }

        public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
            return super.canPlaceItem(slot, stack) && ((FactoryItemSlot)InventoryBlockEntity.this.getSlots().get(slot)).mayPlace(stack);
        }
    };
    private LockCode lockKey = LockCode.NO_LOCK;
    private Component name;

    public InventoryBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public NonNullList<FactoryItemSlot> getSlots() {
        return this.slots;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void updateBlockState() {
        this.level.sendBlockUpdated(this.getBlockPos(), this.level.getBlockState(this.getBlockPos()), this.getBlockState(), 2);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void breakDurabilityItem(ItemStack stack) {
        Level level;
        if (!stack.isEmpty() && stack.isDamageableItem() && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            stack.hurtAndBreak(1, serverLevel, null, i -> this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f));
        }
    }

    public void syncAdditionalMenuData(AbstractContainerMenu menu, Player player) {
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeTag(CompoundTagUtil.getCompoundTagOrEmpty((CompoundTag)tag, (String)"inventory"));
        this.lockKey = LockCode.fromTag((CompoundTag)tag, (HolderLookup.Provider)provider);
        CompoundTagUtil.getString((CompoundTag)tag, (String)"CustomName").ifPresent(nameJson -> {
            this.name = Component.Serializer.fromJson((String)nameJson, (HolderLookup.Provider)provider);
        });
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("inventory", (Tag)this.inventory.serializeTag());
        this.lockKey.addToTag(tag, provider);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)provider));
        }
    }

    public boolean canOpen(Player arg) {
        return BaseContainerBlockEntity.canUnlock((Player)arg, (LockCode)this.lockKey, (Component)this.getDisplayName());
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    public AbstractContainerMenu createMenu(int i, Inventory arg, Player arg2) {
        return this.canOpen(arg2) ? this.createMenu(i, arg) : null;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDisplayName();
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @NotNull
    public IPlatformItemHandler getInv() {
        return this.inventory;
    }

    public void onRemoved(boolean withContents) {
        if (withContents) {
            Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this.inventory);
        }
    }

    @Override
    public abstract boolean IcanExtractItem(int var1, ItemStack var2);

    protected void applyImplicitComponents(BlockEntity.DataComponentInput data) {
        super.applyImplicitComponents(data);
        this.setCustomName((Component)data.get(DataComponents.CUSTOM_NAME));
        this.lockKey = (LockCode)data.getOrDefault(DataComponents.LOCK, (Object)LockCode.NO_LOCK);
        ((ItemContainerContents)data.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.inventory.getItems());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder arg) {
        super.collectImplicitComponents(arg);
        arg.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        if (!this.lockKey.equals((Object)LockCode.NO_LOCK)) {
            arg.set(DataComponents.LOCK, (Object)this.lockKey);
        }
        arg.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)this.inventory.getItems()));
    }

    public void removeComponentsFromTag(CompoundTag arg) {
        arg.remove("CustomName");
        arg.remove("lock");
    }
}

