/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.blockentity.ForgeBlockEntity;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.util.DirectionUtil;

public class ForgeRenderer
implements BlockEntityRenderer<ForgeBlockEntity> {
    BlockEntityRendererProvider.Context context;

    public ForgeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(ForgeBlockEntity be, float f, PoseStack stack, MultiBufferSource multiBufferSource, int i, int j) {
        BlockRenderDispatcher dispatcher = this.context.getBlockRenderDispatcher();
        BakedModel model = (Boolean)be.getBlockState().getValue((Property)SmeltingBlock.COLORED) != false ? FactoryAPIClient.getExtraModel((ResourceLocation)BetterFurnacesReforged.createModLocation("colored_forge" + ((Boolean)be.getBlockState().getValue((Property)BlockStateProperties.LIT) != false ? "_on" : ""))) : dispatcher.getBlockModel(be.getBlockState());
        stack.pushPose();
        stack.translate(0.5, 0.5, 0.5);
        stack.mulPose(DirectionUtil.getRotation((Direction)((Direction)be.getBlockState().getValue((Property)BlockStateProperties.FACING))));
        stack.translate(-0.5, -0.5, -0.5);
        float[] color = be.getColor();
        dispatcher.getModelRenderer().renderModel(stack.last(), multiBufferSource.getBuffer(Sheets.cutoutBlockSheet()), be.getBlockState(), model, color[0], color[1], color[2], i, j);
        if (be.showOrientation) {
            dispatcher.getModelRenderer().renderModel(stack.last(), multiBufferSource.getBuffer(RenderType.cutoutMipped()), be.getBlockState(), FactoryAPIClient.getExtraModel((ResourceLocation)BetterFurnacesReforged.createModLocation("nsweud")), 1.0f, 1.0f, 1.0f, i, j);
        }
        stack.popPose();
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRender(ForgeBlockEntity be, Vec3 vec) {
        return be.getBlockPos().getCenter().multiply(1.0, 0.0, 1.0).closerThan((Position)vec.multiply(1.0, 0.0, 1.0), (double)this.getViewDistance());
    }
}

