/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.init;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import wily.betterfurnaces.BFRConfig;
import wily.betterfurnaces.blockentity.FactoryUpgradeSettings;
import wily.betterfurnaces.blocks.BFRBlock;
import wily.betterfurnaces.blocks.CobblestoneGeneratorBlock;
import wily.betterfurnaces.blocks.ForgeBlock;
import wily.betterfurnaces.blocks.FuelVerifierBlock;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.inventory.CobblestoneGeneratorMenu;
import wily.betterfurnaces.inventory.ForgeMenu;
import wily.betterfurnaces.inventory.FuelVerifierMenu;
import wily.betterfurnaces.inventory.SmeltingMenu;
import wily.betterfurnaces.items.ColorUpgradeItem;
import wily.betterfurnaces.items.EnergyFuelUpgradeItem;
import wily.betterfurnaces.items.FactoryUpgradeItem;
import wily.betterfurnaces.items.FuelEfficiencyUpgradeItem;
import wily.betterfurnaces.items.GeneratorUpgradeItem;
import wily.betterfurnaces.items.LiquidFuelUpgradeItem;
import wily.betterfurnaces.items.OreProcessingUpgradeItem;
import wily.betterfurnaces.items.StorageUpgradeItem;
import wily.betterfurnaces.items.TierUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.betterfurnaces.items.XpTankUpgradeItem;
import wily.betterfurnaces.network.SliderColorSyncPayload;
import wily.betterfurnaces.recipes.CobblestoneGeneratorRecipe;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.FactoryExtraMenuSupplier;
import wily.factoryapi.base.RegisterListing;
import wily.factoryapi.util.ColorUtil;

public class ModObjects {
    public static final RegisterListing<Block> FURNACES = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.BLOCK);
    public static final RegisterListing<Block> BLOCKS = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.BLOCK);
    public static final RegisterListing<Item> ITEMS = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.ITEM);
    public static final RegisterListing.Holder<CreativeModeTab> ITEM_GROUP = Registration.TABS.add("bfr_creative_tab", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).title((Component)Component.translatable((String)"itemGroup.betterfurnacesreforged.tab")).icon(() -> ((SmeltingBlock)((Object)((Object)((Object)EXTREME_FURNACE.get())))).asItem().getDefaultInstance()).displayItems((itemDisplayParameters, output) -> ITEMS.forEach(h -> output.accept(((Item)h.get()).getDefaultInstance()))).build());
    public static final RegisterListing.Holder<RecipeSerializer<CobblestoneGeneratorRecipe>> COB_GENERATION_SERIALIZER = Registration.RECIPES_SERIALIZERS.add("rock_generating", () -> CobblestoneGeneratorRecipe.SERIALIZER);
    public static final RegisterListing.Holder<RecipeType<CobblestoneGeneratorRecipe>> ROCK_GENERATING_RECIPE = Registration.RECIPES.add("rock_generating", () -> new RecipeType<CobblestoneGeneratorRecipe>(){});
    public static final RegisterListing.Holder<MenuType<SmeltingMenu>> FURNACE_CONTAINER = Registration.CONTAINERS.add("furnace", () -> FactoryExtraMenuSupplier.createMenuType((windowId, inv, data) -> new SmeltingMenu(windowId, inv.player.level(), ((RegistryFriendlyByteBuf)data.get()).readBlockPos(), inv)));
    public static final RegisterListing.Holder<MenuType<ForgeMenu>> FORGE_CONTAINER = Registration.CONTAINERS.add("forge", () -> FactoryExtraMenuSupplier.createMenuType((windowId, inv, data) -> new ForgeMenu(windowId, inv.player.level(), ((RegistryFriendlyByteBuf)data.get()).readBlockPos(), inv)));
    public static final RegisterListing.Holder<MenuType<ColorUpgradeItem.ColorUpgradeMenu>> COLOR_UPGRADE_CONTAINER = Registration.CONTAINERS.add("color_upgrade", () -> new MenuType(ColorUpgradeItem.ColorUpgradeMenu::new, FeatureFlags.VANILLA_SET));
    public static final RegisterListing.Holder<SmeltingBlock> IRON_FURNACE = Registration.registerBlockItem(FURNACES.add("iron_furnace", id -> new SmeltingBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.IRON_BLOCK), (ResourceLocation)id), new SmeltingBlock.Tier("iron", (Supplier<Integer>)BFRConfig.ironTierSpeed))), ITEMS);
    public static final RegisterListing.Holder<SmeltingBlock> GOLD_FURNACE = Registration.registerBlockItem(FURNACES.add("gold_furnace", id -> new SmeltingBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.GOLD_BLOCK), (ResourceLocation)id), new SmeltingBlock.Tier("gold", (Supplier<Integer>)BFRConfig.goldTierSpeed))), ITEMS);
    public static final RegisterListing.Holder<SmeltingBlock> DIAMOND_FURNACE = Registration.registerBlockItem(FURNACES.add("diamond_furnace", id -> new SmeltingBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.DIAMOND_BLOCK).noOcclusion(), (ResourceLocation)id), new SmeltingBlock.Tier("diamond", (Supplier<Integer>)BFRConfig.diamondTierSpeed))), ITEMS);
    public static final RegisterListing.Holder<SmeltingBlock> NETHERHOT_FURNACE = Registration.registerBlockItem(FURNACES.add("netherhot_furnace", id -> new SmeltingBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.REDSTONE_BLOCK), (ResourceLocation)id), new SmeltingBlock.Tier("netherhot", (Supplier<Integer>)BFRConfig.netherhotTierSpeed))), ITEMS);
    public static final RegisterListing.Holder<SmeltingBlock> EXTREME_FURNACE = Registration.registerBlockItem(FURNACES.add("extreme_furnace", id -> new SmeltingBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.DIAMOND_BLOCK).strength(20.0f, 3000.0f), (ResourceLocation)id), new SmeltingBlock.Tier("extreme", (Supplier<Integer>)BFRConfig.extremeTierSpeed))), ITEMS);
    public static final RegisterListing.Holder<ForgeBlock> EXTREME_FORGE = Registration.registerBlockItem(BLOCKS.add("extreme_forge", id -> new ForgeBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.NETHERITE_BLOCK).strength(30.0f, 6000.0f), (ResourceLocation)id), (Supplier<Integer>)BFRConfig.extremeTierSpeed)), ITEMS);
    public static final RegisterListing.Holder<CobblestoneGeneratorBlock> COBBLESTONE_GENERATOR = Registration.registerBlockItem(BLOCKS.add("cobblestone_generator", () -> new CobblestoneGeneratorBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.BLACKSTONE), COBBLESTONE_GENERATOR))), ITEMS);
    public static final RegisterListing.Holder<MenuType<CobblestoneGeneratorMenu>> COB_GENERATOR_CONTAINER = Registration.CONTAINERS.add("cobblestone_generator", () -> FactoryExtraMenuSupplier.createMenuType((windowId, inv, data) -> new CobblestoneGeneratorMenu(windowId, inv.player.level(), ((RegistryFriendlyByteBuf)data.get()).readBlockPos(), inv)));
    public static final RegisterListing.Holder<FuelVerifierBlock> FUEL_VERIFIER = Registration.registerBlockItem(BLOCKS.add("fuel_verifier", () -> new FuelVerifierBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.COBBLESTONE), FUEL_VERIFIER))), ITEMS);
    public static final RegisterListing.Holder<MenuType<FuelVerifierMenu>> FUEL_VERIFIER_CONTAINER = Registration.CONTAINERS.add("fuel_verifier", () -> FactoryExtraMenuSupplier.createMenuType((windowId, inv, data) -> new FuelVerifierMenu(windowId, inv.player.level(), ((RegistryFriendlyByteBuf)data.get()).readBlockPos(), inv)));
    public static final RegisterListing.Holder<BFRBlock> IRON_CONDUCTOR_BLOCK = Registration.registerBlockItem(BLOCKS.add("iron_conductor_block", () -> new BFRBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.IRON_BLOCK).strength(8.0f, 20.0f), IRON_CONDUCTOR_BLOCK))), ITEMS);
    public static final RegisterListing.Holder<BFRBlock> GOLD_CONDUCTOR_BLOCK = Registration.registerBlockItem(BLOCKS.add("gold_conductor_block", () -> new BFRBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.GOLD_BLOCK).strength(8.0f, 20.0f), GOLD_CONDUCTOR_BLOCK))), ITEMS);
    public static final RegisterListing.Holder<BFRBlock> NETHERHOT_CONDUCTOR_BLOCK = Registration.registerBlockItem(BLOCKS.add("netherhot_conductor_block", () -> new BFRBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)ModObjects.propertiesOf(Blocks.REDSTONE_BLOCK).strength(10.0f, 40.0f), NETHERHOT_CONDUCTOR_BLOCK))), ITEMS);
    public static final RegisterListing.Holder<TierUpgradeItem> IRON_UPGRADE = ITEMS.add("iron_upgrade", id -> new TierUpgradeItem(ModObjects.uniqueStackItemProperties(id), Blocks.FURNACE, (Block)IRON_FURNACE.get()));
    public static final RegisterListing.Holder<TierUpgradeItem> GOLD_UPGRADE = ITEMS.add("gold_upgrade", id -> new TierUpgradeItem(ModObjects.uniqueStackItemProperties(id), (Block)IRON_FURNACE.get(), (Block)GOLD_FURNACE.get()));
    public static final RegisterListing.Holder<TierUpgradeItem> DIAMOND_UPGRADE = ITEMS.add("diamond_upgrade", id -> new TierUpgradeItem(ModObjects.uniqueStackItemProperties(id), (Block)GOLD_FURNACE.get(), (Block)DIAMOND_FURNACE.get()));
    public static final RegisterListing.Holder<TierUpgradeItem> NETHERHOT_UPGRADE = ITEMS.add("netherhot_upgrade", id -> new TierUpgradeItem(ModObjects.uniqueStackItemProperties(id), (Block)DIAMOND_FURNACE.get(), (Block)NETHERHOT_FURNACE.get()));
    public static final RegisterListing.Holder<TierUpgradeItem> EXTREME_UPGRADE = ITEMS.add("extreme_upgrade", id -> new TierUpgradeItem(ModObjects.uniqueStackItemProperties(id), (Block)NETHERHOT_FURNACE.get(), (Block)EXTREME_FURNACE.get()));
    public static final RegisterListing.Holder<FuelEfficiencyUpgradeItem> FUEL = ITEMS.add("fuel_efficiency_upgrade", id -> new FuelEfficiencyUpgradeItem(ModObjects.uniqueStackItemProperties(id).durability(256), 2));
    public static final RegisterListing.Holder<OreProcessingUpgradeItem> ORE_PROCESSING = ITEMS.add("ore_processing_upgrade", id -> new OreProcessingUpgradeItem(ModObjects.uniqueStackItemProperties(id).durability(128), 2, true, false));
    public static final RegisterListing.Holder<OreProcessingUpgradeItem> RAW_ORE_PROCESSING = ITEMS.add("raw_ore_processing_upgrade", id -> new OreProcessingUpgradeItem(ModObjects.uniqueStackItemProperties(id), 2, false, true));
    public static final RegisterListing.Holder<FuelEfficiencyUpgradeItem> ADVANCED_FUEL = ITEMS.add("advanced_fuel_efficiency_upgrade", id -> new FuelEfficiencyUpgradeItem(ModObjects.uniqueStackItemProperties(id), 2));
    public static final RegisterListing.Holder<OreProcessingUpgradeItem> ADVANCED_ORE_PROCESSING = ITEMS.add("advanced_ore_processing_upgrade", id -> new OreProcessingUpgradeItem(ModObjects.uniqueStackItemProperties(id), 2, true, false));
    public static final RegisterListing.Holder<FactoryUpgradeItem> FACTORY = ITEMS.add("factory_upgrade", id -> new FactoryUpgradeItem(ModObjects.uniqueStackItemProperties(id), "factory", true, true, true, true));
    public static final RegisterListing.Holder<FactoryUpgradeItem> PIPING = ITEMS.add("piping_upgrade", id -> new FactoryUpgradeItem(ModObjects.uniqueStackItemProperties(id), "piping", false, false, true, false));
    public static final RegisterListing.Holder<FactoryUpgradeItem> OUTPUT = ITEMS.add("autooutput_upgrade", id -> new FactoryUpgradeItem(ModObjects.uniqueStackItemProperties(id), "output", true, false, true, false));
    public static final RegisterListing.Holder<FactoryUpgradeItem> INPUT = ITEMS.add("autoinput_upgrade", id -> new FactoryUpgradeItem(ModObjects.uniqueStackItemProperties(id), "input", false, true, true, false));
    public static final RegisterListing.Holder<FactoryUpgradeItem> REDSTONE = ITEMS.add("redstone_signal_upgrade", id -> new FactoryUpgradeItem(ModObjects.uniqueStackItemProperties(id), "redstone", false, false, false, true));
    public static final RegisterListing.Holder<ColorUpgradeItem> COLOR = ITEMS.add("color_upgrade", id -> new ColorUpgradeItem(ModObjects.uniqueStackItemProperties(id), "color"));
    public static final RegisterListing.Holder<LiquidFuelUpgradeItem> LIQUID = ITEMS.add("liquid_fuel_upgrade", id -> new LiquidFuelUpgradeItem(ModObjects.uniqueStackItemProperties(id), "liquid"));
    public static final RegisterListing.Holder<EnergyFuelUpgradeItem> ENERGY = ITEMS.add("energy_upgrade", id -> new EnergyFuelUpgradeItem(ModObjects.uniqueStackItemProperties(id), (Component)Component.translatable((String)"tooltip.betterfurnacesreforged.upgrade.energy", (Object[])new Object[]{FactoryAPIPlatform.getPlatformEnergyComponent().getString()}).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY))));
    public static final RegisterListing.Holder<XpTankUpgradeItem> XP = ITEMS.add("xp_tank_upgrade", id -> new XpTankUpgradeItem(ModObjects.uniqueStackItemProperties(id), "xp"));
    public static final RegisterListing.Holder<UpgradeItem> BLAST = ITEMS.add("blasting_upgrade", id -> new UpgradeItem(ModObjects.uniqueStackItemProperties(id), UpgradeItem.Type.MODE, "blasting"));
    public static final RegisterListing.Holder<UpgradeItem> SMOKE = ITEMS.add("smoking_upgrade", id -> new UpgradeItem(ModObjects.uniqueStackItemProperties(id), UpgradeItem.Type.MODE, "smoking"));
    public static final RegisterListing.Holder<GeneratorUpgradeItem> GENERATOR = ITEMS.add("generator_upgrade", id -> new GeneratorUpgradeItem(ModObjects.uniqueStackItemProperties(id)));
    public static final RegisterListing.Holder<StorageUpgradeItem> STORAGE = ITEMS.add("storage_upgrade", id -> new StorageUpgradeItem(ModObjects.uniqueStackItemProperties(id)));
    public static final RegisterListing.Holder<DataComponentType<BlockTint>> BLOCK_TINT = Registration.DATA_COMPONENTS.add("upgrade_color", () -> DataComponentType.builder().persistent(BlockTint.CODEC).networkSynchronized(ByteBufCodecs.INT.map(BlockTint::new, BlockTint::toRGB)).build());
    public static final RegisterListing.Holder<DataComponentType<UpgradeSetting>> SIDES_SETTING = ModObjects.registerFactoryUpgradeSetting("sides_setting");
    public static final RegisterListing.Holder<DataComponentType<UpgradeSetting>> AUTOIO_SETTING = ModObjects.registerFactoryUpgradeSetting("auto_input_output_setting");
    public static final RegisterListing.Holder<DataComponentType<UpgradeSetting>> REDSTONE_SETTING = ModObjects.registerFactoryUpgradeSetting("redstone_setting");

    public static void init() {
        FURNACES.register();
        BLOCKS.register();
        ITEMS.register();
    }

    private static Item.Properties uniqueStackItemProperties(ResourceLocation id) {
        return FactoryAPIPlatform.setupItemProperties((Item.Properties)new Item.Properties(), (ResourceLocation)id).stacksTo(1);
    }

    public static BlockBehaviour.Properties propertiesOf(Block block) {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)block);
    }

    public static RegisterListing.Holder<DataComponentType<UpgradeSetting>> registerFactoryUpgradeSetting(String id) {
        return Registration.DATA_COMPONENTS.add(id, () -> DataComponentType.builder().persistent(Codec.INT_STREAM.xmap(i -> new UpgradeSetting(i.toArray()), setting -> IntStream.of(setting.values()))).networkSynchronized(StreamCodec.of((buf, setting) -> buf.writeVarIntArray(setting.values()), buf -> new UpgradeSetting(buf.readVarIntArray()))).build());
    }

    public static RegisterListing.Holder<DataComponentType<UpgradeSetting>> getSettingComponent(FactoryUpgradeSettings.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case FactoryUpgradeSettings.Type.SIDES -> SIDES_SETTING;
            case FactoryUpgradeSettings.Type.AUTO_IO -> AUTOIO_SETTING;
            case FactoryUpgradeSettings.Type.REDSTONE -> REDSTONE_SETTING;
        };
    }

    public record UpgradeSetting(int[] values) {
    }

    public record BlockTint(int red, int green, int blue) {
        public static final Codec<BlockTint> CODEC = ColorRGBA.CODEC.xmap(rgba -> new BlockTint(rgba.rgba()), b -> new ColorRGBA(b.toRGB()));
        public static final BlockTint WHITE = new BlockTint(255, 255, 255);

        public BlockTint(int rgb) {
            this(ColorUtil.toInt((float)ColorUtil.getRed((int)rgb)), ColorUtil.toInt((float)ColorUtil.getGreen((int)rgb)), ColorUtil.toInt((float)ColorUtil.getBlue((int)rgb)));
        }

        public BlockTint(List<Integer> color) {
            this(color.get(0), color.get(1), color.get(2));
        }

        public BlockTint withChannel(SliderColorSyncPayload.Channel channel, int value) {
            return switch (channel) {
                default -> throw new MatchException(null, null);
                case SliderColorSyncPayload.Channel.R -> new BlockTint(value, this.green, this.blue);
                case SliderColorSyncPayload.Channel.G -> new BlockTint(this.red, value, this.blue);
                case SliderColorSyncPayload.Channel.B -> new BlockTint(this.red, this.green, value);
            };
        }

        public int getChannel(SliderColorSyncPayload.Channel channel) {
            return switch (channel) {
                default -> throw new MatchException(null, null);
                case SliderColorSyncPayload.Channel.R -> this.red;
                case SliderColorSyncPayload.Channel.G -> this.green;
                case SliderColorSyncPayload.Channel.B -> this.blue;
            };
        }

        public List<Integer> toList() {
            return List.of(Integer.valueOf(this.red), Integer.valueOf(this.green), Integer.valueOf(this.blue));
        }

        public int toRGB() {
            return ColorUtil.colorFromInt((int)this.red, (int)this.green, (int)this.blue, (int)0);
        }

        public float[] toFloatArray() {
            return new float[]{(float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f};
        }
    }
}

