/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.init;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import wily.betterfurnaces.blocks.BFRBlock;
import wily.betterfurnaces.init.BlockEntityTypes;
import wily.betterfurnaces.init.ModObjects;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.RegisterListing;
import wily.ultimatefurnaces.init.ModObjectsUF;

public class Registration {
    public static final RegisterListing<BlockEntityType<?>> BLOCK_ENTITIES = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE);
    public static final RegisterListing<MenuType<?>> CONTAINERS = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.MENU);
    static final RegisterListing<RecipeSerializer<?>> RECIPES_SERIALIZERS = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.RECIPE_SERIALIZER);
    static final RegisterListing<RecipeType<?>> RECIPES = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.RECIPE_TYPE);
    static final RegisterListing<DataComponentType<?>> DATA_COMPONENTS = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.DATA_COMPONENT_TYPE);
    public static final RegisterListing<CreativeModeTab> TABS = FactoryAPIPlatform.createRegister((String)"betterfurnacesreforged", (Registry)BuiltInRegistries.CREATIVE_MODE_TAB);

    public static void init() {
        ModObjects.init();
        DATA_COMPONENTS.register();
        ModObjectsUF.init();
        BlockEntityTypes.init();
        BLOCK_ENTITIES.register();
        CONTAINERS.register();
        RECIPES_SERIALIZERS.register();
        RECIPES.register();
        TABS.register();
    }

    public static <T extends Block> RegisterListing.Holder<T> registerBlockItem(RegisterListing.Holder<T> holder, RegisterListing<Item> items) {
        items.add(holder.getId().getPath(), () -> new BlockItem((Block)holder.get(), FactoryAPIPlatform.setupBlockItemProperties((Item.Properties)new Item.Properties(), (RegisterListing.Holder)holder)){

            public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
                Block block = this.getBlock();
                if (block instanceof BFRBlock) {
                    BFRBlock b = (BFRBlock)block;
                    b.appendHoverText(itemStack, tooltip::add, tooltipFlag);
                }
                super.appendHoverText(itemStack, tooltipContext, tooltip, tooltipFlag);
            }
        });
        return holder;
    }

    public static Stream<RegisterListing.Holder<Block>> getFurnaces() {
        return Stream.concat(ModObjects.FURNACES.stream(), ModObjectsUF.FURNACES.stream());
    }

    public static Stream<RegisterListing.Holder<? extends Block>> getForges() {
        return Stream.concat(Stream.of(ModObjects.EXTREME_FORGE), ModObjectsUF.FORGES.stream());
    }

    public static Stream<RegisterListing.Holder<? extends Block>> getSmeltingBlocks() {
        return Stream.concat(Registration.getFurnaces(), Registration.getForges());
    }

    public static Stream<RegisterListing.Holder<Item>> getItems() {
        return Stream.concat(ModObjects.ITEMS.stream(), ModObjectsUF.ITEMS.stream());
    }
}

