/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.inventory;

import java.util.function.Predicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.inventory.HideableSlot;
import wily.factoryapi.base.FactoryItemSlot;

public class SlotOutput
extends HideableSlot {
    private final Player player;
    private int removeCount;

    public SlotOutput(Player player, InventoryBlockEntity be, int slotIndex, int xPosition, int yPosition) {
        this(player, be, slotIndex, xPosition, yPosition, s -> true);
    }

    public SlotOutput(Player player, InventoryBlockEntity be, int slotIndex, int xPosition, int yPosition, Predicate<FactoryItemSlot> isActive) {
        super(be, slotIndex, xPosition, yPosition, isActive);
        this.player = player;
        this.be = be;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public void onTake(Player thePlayer, ItemStack stack) {
        this.checkTakeAchievements(stack);
        super.onTake(thePlayer, stack);
    }

    protected void onCrafting(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.onCrafting(stack);
    }

    protected void onQuickCraft(ItemStack stack, int p_75210_2_) {
        if (this.player != null) {
            InventoryBlockEntity inventoryBlockEntity;
            stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
            if (!this.player.level().isClientSide && (inventoryBlockEntity = this.be) instanceof SmeltingBlockEntity) {
                SmeltingBlockEntity smeltBe = (SmeltingBlockEntity)inventoryBlockEntity;
                smeltBe.unlockRecipes(this.player);
            }
            this.removeCount = 0;
        }
    }

    protected void onCrafting(ItemStack stack) {
    }
}

