/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.init.ModObjects;
import wily.betterfurnaces.inventory.AbstractInventoryMenu;
import wily.betterfurnaces.network.FluidSyncPayload;
import wily.factoryapi.base.network.CommonNetwork;

public class SmeltingMenu
extends AbstractInventoryMenu<SmeltingBlockEntity> {
    public SmeltingMenu(int windowId, Level world, BlockPos pos, Inventory playerInventory, ContainerData data) {
        this((MenuType)ModObjects.FURNACE_CONTAINER.get(), windowId, world, pos, playerInventory, data);
    }

    public SmeltingMenu(int windowId, Level world, BlockPos pos, Inventory playerInventory) {
        this((MenuType)ModObjects.FURNACE_CONTAINER.get(), windowId, world, pos, playerInventory);
    }

    public SmeltingMenu(MenuType<?> containerType, int windowId, final Level world, final BlockPos pos, Inventory playerInventory) {
        this(containerType, windowId, world, pos, playerInventory, (ContainerData)new SimpleContainerData(7){

            public void set(int i, int j) {
                BlockEntity blockEntity;
                if (i == 5 && (blockEntity = world.getBlockEntity(pos)) instanceof SmeltingBlockEntity) {
                    SmeltingBlockEntity smeltingBe = (SmeltingBlockEntity)blockEntity;
                    smeltingBe.energyStorage.setEnergyStored(j);
                }
                super.set(i, j);
            }
        });
    }

    public SmeltingMenu(MenuType<?> containerType, int windowId, Level world, BlockPos pos, Inventory playerInventory, ContainerData data) {
        super(containerType, windowId, world, pos, playerInventory, data);
        SmeltingMenu.checkContainerDataCount((ContainerData)this.data, (int)7);
    }

    public boolean showInventoryButtons() {
        return this.data.get(4) == 1;
    }

    public int getRedstoneMode() {
        return ((SmeltingBlockEntity)this.be).getRedstoneSetting();
    }

    public int getComSub() {
        return ((SmeltingBlockEntity)this.be).getRedstoneComSub();
    }

    public boolean getAutoInput() {
        return ((SmeltingBlockEntity)this.be).getAutoInput() == 1;
    }

    public boolean getAutoOutput() {
        return ((SmeltingBlockEntity)this.be).getAutoOutput() == 1;
    }

    @Override
    public BlockPos getPos() {
        return ((SmeltingBlockEntity)this.be).getBlockPos();
    }

    public int getCookScaled(int pixels) {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getBurnLeftScaled(int pixels) {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.get(0) * pixels / i;
    }

    public int getBurnTime() {
        return this.data.get(0);
    }

    public int getEnergyStored() {
        return this.data.get(5);
    }

    public int getMaxEnergyStored() {
        return this.data.get(6);
    }

    @Override
    protected void updateChanges() {
        super.updateChanges();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            CommonNetwork.sendToPlayer((ServerPlayer)sp, (CommonNetwork.Payload)new FluidSyncPayload(((SmeltingBlockEntity)this.be).getBlockPos(), ((SmeltingBlockEntity)this.be).fluidTank.getFluidInstance()));
        }
    }

    @Override
    public boolean stillValid(Player playerIn) {
        return SmeltingMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)((SmeltingBlockEntity)this.be).getLevel(), (BlockPos)((SmeltingBlockEntity)this.be).getBlockPos()), (Player)this.player, (Block)((SmeltingBlockEntity)this.be).getBlockState().getBlock());
    }
}

