/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.items;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.betterfurnaces.util.BFRComponents;

public class UpgradeItem
extends Item {
    protected final Component tooltip;
    public Type upgradeType;

    public UpgradeItem(Item.Properties properties, Type upgradeType, Component tooltip) {
        super(properties);
        this.upgradeType = upgradeType;
        this.tooltip = tooltip;
    }

    public UpgradeItem(Item.Properties properties, Type upgradeType, String tooltipName) {
        this(properties, upgradeType, (Component)Component.translatable((String)("tooltip.betterfurnacesreforged.upgrade." + tooltipName)).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
    }

    public UpgradeItem(Item.Properties properties, Type upgradeType) {
        this(properties, upgradeType, (Component)null);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSameType(UpgradeItem upg) {
        return this.upgradeType == upg.upgradeType;
    }

    public boolean isValid(SmeltingBlockEntity blockEntity) {
        return this.isEnabled() && blockEntity.getUpgrades().stream().allMatch(this::isUpgradeCompatibleWith);
    }

    public boolean isUpgradeCompatibleWith(UpgradeItem upg) {
        return true;
    }

    public Component getDisabledMessage() {
        return BFRComponents.UPGRADE_DISABLED_MESSAGE;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        this.appendHoverText(itemStack, tooltip::add, tooltipFlag);
    }

    public void appendHoverText(ItemStack itemStack, Consumer<Component> consumer, TooltipFlag flagIn) {
        if (this.isEnabled()) {
            consumer.accept(BFRComponents.UPGRADE_RIGHT_CLICK);
        } else {
            consumer.accept(this.getDisabledMessage());
        }
        if (this.tooltip != null) {
            consumer.accept(this.tooltip);
        }
    }

    public void inventoryTick(ItemStack stack, Level world, Entity player, int slot, boolean selected) {
        if (stack.isDamageableItem() && stack.getDamageValue() >= stack.getMaxDamage()) {
            stack.shrink(1);
        }
    }

    public static enum Type {
        FUEL,
        ORE,
        COLOR,
        ALTERNATIVE_FUEL,
        XP,
        MODE,
        FACTORY,
        STORAGE,
        TIER,
        MISC;

    }
}

