/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import wily.betterfurnaces.BetterFurnacesReforged;
import wily.betterfurnaces.blockentity.FactoryUpgradeSettings;
import wily.betterfurnaces.blockentity.SmeltingBlockEntity;
import wily.factoryapi.base.network.CommonNetwork;

public record SettingsSyncPayload(BlockPos pos, FactoryUpgradeSettings.Type settingType, int[] indexes, int set) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<SettingsSyncPayload> ID = CommonNetwork.Identifier.create((ResourceLocation)BetterFurnacesReforged.createModLocation("furnace_settings_sync"), SettingsSyncPayload::new);

    public SettingsSyncPayload(CommonNetwork.PlayBuf buf) {
        this(((RegistryFriendlyByteBuf)buf.get()).readBlockPos(), (FactoryUpgradeSettings.Type)((RegistryFriendlyByteBuf)buf.get()).readEnum(FactoryUpgradeSettings.Type.class), ((RegistryFriendlyByteBuf)buf.get()).readVarIntArray(), ((RegistryFriendlyByteBuf)buf.get()).readVarInt());
    }

    public SettingsSyncPayload(BlockPos pos, FactoryUpgradeSettings.Type settingType, int index, int set) {
        this(pos, settingType, new int[]{index}, set);
    }

    public void apply(CommonNetwork.Payload.Context context) {
        context.executor().execute(() -> {
            SmeltingBlockEntity be = (SmeltingBlockEntity)context.player().level().getBlockEntity(this.pos);
            if (context.player().level().isLoaded(this.pos)) {
                for (int index : this.indexes) {
                    be.furnaceSettings.set(this.settingType, index, this.set);
                }
                be.getLevel().setBlock(this.pos, be.getLevel().getBlockState(this.pos), 2, 3);
                be.setChanged();
            }
        });
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((RegistryFriendlyByteBuf)buf.get()).writeBlockPos(this.pos);
        ((RegistryFriendlyByteBuf)buf.get()).writeEnum((Enum)this.settingType);
        ((RegistryFriendlyByteBuf)buf.get()).writeVarIntArray(this.indexes);
        ((RegistryFriendlyByteBuf)buf.get()).writeVarInt(this.set);
    }
}

