/*
 * Decompiled with CFR 0.152.
 */
package net.dypiduo.easyfilling.compat.createsa;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.nio.file.Path;
import java.util.Locale;
import net.neoforged.fml.loading.FMLPaths;

public class CreateSAConfigCompat {
    private static volatile UnmodifiableConfig CFG;
    private static volatile UnmodifiableConfig CAP;
    private static final int DEF_SMALL = 800;
    private static final int DEF_MEDIUM = 1600;
    private static final int DEF_LARGE = 3200;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded() {
        if (CAP != null) {
            return;
        }
        Class<CreateSAConfigCompat> clazz = CreateSAConfigCompat.class;
        synchronized (CreateSAConfigCompat.class) {
            if (CAP != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Path p = FMLPaths.CONFIGDIR.get().resolve("create-stuff-additions.toml");
            try {
                CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((Path)p).autosave().build();
                file.load();
                CFG = file;
                Object sub = CFG.get("Fuel/Water Capacity");
                if (sub instanceof UnmodifiableConfig) {
                    UnmodifiableConfig uc;
                    CAP = uc = (UnmodifiableConfig)sub;
                }
            }
            catch (Throwable t) {
                CFG = null;
                CAP = null;
            }
            return;
        }
    }

    public static int capacityFor(boolean isWater, String size) {
        CreateSAConfigCompat.ensureLoaded();
        if (CAP == null) {
            return switch (size.toLowerCase(Locale.ROOT)) {
                case "small" -> 800;
                case "medium" -> 1600;
                default -> 3200;
            };
        }
        String key = switch (size.toLowerCase(Locale.ROOT)) {
            case "small" -> "smallTankCapacity";
            case "medium" -> "mediumTankCapacity";
            default -> "largeTankCapacity";
        };
        try {
            Object v = CAP.get(key);
            if (v instanceof Number) {
                Number n = (Number)v;
                return Math.max(0, n.intValue());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return switch (size.toLowerCase(Locale.ROOT)) {
            case "small" -> 800;
            case "medium" -> 1600;
            default -> 3200;
        };
    }
}

