/*
 * Decompiled with CFR 0.152.
 */
package net.dypiduo.easyfilling.compat.createsa;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.dypiduo.easyfilling.compat.createsa.CreateSAConfigCompat;
import net.dypiduo.easyfilling.compat.createsa.LargeTankStockHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

@EventBusSubscriber(modid="create_easyfilling", bus=EventBusSubscriber.Bus.MOD)
public final class RegisterItemCaps {
    @SubscribeEvent
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        ArrayList<Item> items = new ArrayList<Item>();
        RegisterItemCaps.add(items, "create_sa:small_filling_tank");
        RegisterItemCaps.add(items, "create_sa:medium_filling_tank");
        RegisterItemCaps.add(items, "create_sa:large_filling_tank");
        RegisterItemCaps.add(items, "create_sa:small_fueling_tank");
        RegisterItemCaps.add(items, "create_sa:medium_fueling_tank");
        RegisterItemCaps.add(items, "create_sa:large_fueling_tank");
        if (items.isEmpty()) {
            return;
        }
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, ctx) -> {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            if (id == null || !"create_sa".equals(id.getNamespace())) {
                return null;
            }
            String path = id.getPath().toLowerCase(Locale.ROOT);
            boolean isWater = path.contains("filling");
            String size = path.contains("small") ? "small" : (path.contains("medium") ? "medium" : "large");
            int capacity = CreateSAConfigCompat.capacityFor(isWater, size);
            return new LargeTankStockHandler((ItemStack)stack, isWater, capacity);
        }, (ItemLike[])items.toArray(Item[]::new));
    }

    private static void add(List<Item> list, String rl) {
        BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)rl)).ifPresent(list::add);
    }
}

