/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.device.skillet;

import com.vomiter.survivorsdelight.core.device.skillet.SDSkilletItem;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class SkilletDeflects {
    private static final double SPEED_BOOST = 1.15;
    private static final double HALF_W = 1.5;
    private static final double HALF_H = 1.0;
    private static final double HALF_D = 1.5;
    private static final double NEAR_Z = 1.5;
    private static final double FAR_Z = 4.5;
    private static final double COS_LIMIT = Math.cos(Math.toRadians(60.0));

    public static void performSweepDeflect(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (!(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SDSkilletItem)) {
            return;
        }
        if (player.m_36403_(0.0f) < 0.2f) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        Vec3 eye = player.m_146892_();
        Vec3 look = player.m_20154_().m_82541_();
        AABB boxNear = SkilletDeflects.aabbAt(eye.m_82549_(look.m_82490_(1.5)));
        AABB boxFar = SkilletDeflects.aabbAt(eye.m_82549_(look.m_82490_(4.5)));
        AABB sweep = new AABB(Math.min(boxNear.f_82288_, boxFar.f_82288_), Math.min(boxNear.f_82289_, boxFar.f_82289_), Math.min(boxNear.f_82290_, boxFar.f_82290_), Math.max(boxNear.f_82291_, boxFar.f_82291_), Math.max(boxNear.f_82292_, boxFar.f_82292_), Math.max(boxNear.f_82293_, boxFar.f_82293_));
        List list = level.m_6443_(Projectile.class, sweep, p -> p.m_6084_() && p.m_20280_((Entity)player) > 0.5);
        if (list.isEmpty()) {
            return;
        }
        for (Projectile proj : list) {
            Vec3 dirTo;
            Vec3 to = proj.m_20182_().m_82546_(eye);
            if (to.m_82556_() < 1.0E-6 || (dirTo = to.m_82541_()).m_82526_(look) < COS_LIMIT) continue;
            double speed = proj.m_20184_().m_82553_();
            if (speed < 0.1) {
                speed = 0.6;
            }
            Vec3 newVel = look.m_82490_(speed * 1.15);
            Vec3 newPos = eye.m_82549_(look.m_82490_(0.6));
            proj.m_5602_((Entity)player);
            proj.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            proj.m_20256_(newVel);
            if (player.m_21120_(InteractionHand.MAIN_HAND).getEnchantmentLevel(Enchantments.f_44981_) > 0) {
                proj.m_7311_(1200);
            }
            proj.f_19864_ = true;
            player.m_21205_().m_41622_(1, (LivingEntity)player, user -> user.m_21166_(EquipmentSlot.MAINHAND));
            if (proj instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)proj;
                arrow.m_36762_(true);
                arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                continue;
            }
            if (proj instanceof ThrownTrident) {
                ThrownTrident trident = (ThrownTrident)proj;
                trident.m_5602_((Entity)player);
                trident.m_36790_(false);
                continue;
            }
            if (!(proj instanceof LargeFireball)) continue;
            LargeFireball fireball = (LargeFireball)proj;
            fireball.f_36813_ = look.f_82479_;
            fireball.f_36814_ = look.f_82480_;
            fireball.f_36815_ = look.f_82481_;
        }
        float pitch = 0.9f + player.m_217043_().m_188501_() * 0.2f;
        player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_STRONG.get(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    private static AABB aabbAt(Vec3 center) {
        return new AABB(center, center).m_82377_(1.5, 1.0, 1.5);
    }
}

