/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.registry;

import com.vomiter.survivorsdelight.core.device.skillet.SkilletMaterial;
import com.vomiter.survivorsdelight.mixin.BlockEntityTypeAccessor;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;

@Mod.EventBusSubscriber(modid="survivorsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SDSkilletBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"survivorsdelight");
    public static final Map<SkilletMaterial, RegistryObject<Block>> SKILLETS = new EnumMap<SkilletMaterial, RegistryObject<Block>>(SkilletMaterial.class);
    public static final RegistryObject<Block> FARMER = BLOCKS.register("skillet/farmer", () -> new SkilletBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60955_().m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_56762_)));

    private SDSkilletBlocks() {
    }

    public static RegistryObject<Block> get(SkilletMaterial m) {
        return SKILLETS.get((Object)m);
    }

    public static ResourceKey<Block> getKey(SkilletMaterial m) {
        return SKILLETS.get((Object)m).getKey();
    }

    static {
        for (SkilletMaterial m : SkilletMaterial.values()) {
            RegistryObject ro = BLOCKS.register(m.path(), () -> new SkilletBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60955_().m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_56762_)));
            SKILLETS.put(m, (RegistryObject<Block>)ro);
        }
    }

    @Mod.EventBusSubscriber(modid="survivorsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static final class Compat {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                BlockEntityType type = (BlockEntityType)ModBlockEntityTypes.SKILLET.get();
                BlockEntityTypeAccessor acc = (BlockEntityTypeAccessor)type;
                HashSet<Block> validBlocks = new HashSet<Block>(acc.getValidBlocks());
                acc.setValidBlocks(validBlocks);
                SKILLETS.values().forEach(ro -> validBlocks.add((Block)ro.get()));
                validBlocks.add((Block)FARMER.get());
            });
        }
    }
}

