/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.util;

import com.vomiter.survivorsdelight.HeatSourceBlockEntity;
import com.vomiter.survivorsdelight.data.tags.SDBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vectorwing.farmersdelight.common.tag.ModTags;

public class HeatHelper {
    public static float getTemperature(BlockPos pos, LevelReader level, GetterType getterType) {
        boolean isInHand;
        BlockState blockState = level.m_8055_(pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        boolean isBlock = getterType == GetterType.BLOCK || getterType == GetterType.BOTH;
        boolean bl = isInHand = getterType == GetterType.IN_HAND || getterType == GetterType.BOTH;
        if (isBlock && blockState.m_204336_(SDBlockTags.HEAT_TO_BLOCK_BLACKLIST)) {
            return 0.0f;
        }
        if (isInHand && blockState.m_204336_(SDBlockTags.HEAT_TO_IN_HAND_BLACKLIST)) {
            return 0.0f;
        }
        if (blockEntity instanceof HeatSourceBlockEntity) {
            HeatSourceBlockEntity heatSourceBlockEntity = (HeatSourceBlockEntity)blockEntity;
            return heatSourceBlockEntity.sdtfc$getTemperature();
        }
        if (blockState.m_204336_(SDBlockTags.STATIC_HEAT_MODERATE)) {
            return 500.0f;
        }
        if (blockState.m_204336_(SDBlockTags.STATIC_HEAT_HIGH)) {
            return 1500.0f;
        }
        if (blockState.m_204336_(SDBlockTags.STATIC_HEAT_LOW)) {
            return 250.0f;
        }
        return 0.0f;
    }

    public static float getTargetTemperature(BlockPos pos, LevelReader level, boolean requiresDirectHeat, GetterType getterType) {
        if (level == null) {
            return 0.0f;
        }
        BlockPos below = pos.m_7495_();
        float heatBelow = HeatHelper.getTemperature(below, level, getterType);
        if (heatBelow > 0.0f) {
            return heatBelow;
        }
        if (!requiresDirectHeat && level.m_8055_(below).m_204336_(ModTags.HEAT_CONDUCTORS)) {
            return HeatHelper.getTemperature(below.m_7495_(), level, getterType);
        }
        return 0.0f;
    }

    public static enum GetterType {
        BLOCK,
        IN_HAND,
        BOTH,
        BOTH_NOT;

    }
}

