/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight;

import com.vomiter.survivorsdelight.SurvivorsDelight;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="survivorsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            SurvivorsDelight.LOGGER.info("SurvivorsDelight Config Loaded: {}", (Object)configEvent.getConfig().getFileName());
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            SurvivorsDelight.LOGGER.info("SurvivorsDelight Config Reloaded: {}", (Object)configEvent.getConfig().getFileName());
        }
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        COMMON = new Common(builder);
        COMMON_SPEC = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue skilletSlotNumber;
        public final ForgeConfigSpec.IntValue richSoilGrowthBoostTick;
        public final ForgeConfigSpec.IntValue richSoilFarmlandTemperatureExpansion;
        public final ForgeConfigSpec.IntValue richSoilFarmlandHydrationExpansion;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.skilletSlotNumber = builder.comment("How many items can be put into skillet block at once.").defineInRange("skilletSlotNumber", 8, 1, 32);
            this.richSoilGrowthBoostTick = builder.comment("How many ticks rich soil should boost the growth of the block above it.").defineInRange("richSoilGrowthBoostTick", 2400, 0, 240000);
            this.richSoilFarmlandTemperatureExpansion = builder.comment("How many degrees of temperature deviated from usual range is allowed for crops planted on rich soil farmlands to grow.").defineInRange("richSoilFarmlandTemperatureExpansion", 5, 0, 100);
            this.richSoilFarmlandHydrationExpansion = builder.comment("How many percentile of hydration deviated from usual range is allowed for crops planted on rich soil farmlands to grow.").defineInRange("richSoilFarmlandHydrationExpansion", 5, 0, 100);
            builder.pop();
        }
    }
}

