/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.device.skillet;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletMaterial;
import com.vomiter.survivorsdelight.core.registry.SDSkilletItems;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.item.SkilletItem;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class SDSkilletItem
extends SkilletItem {
    private final Multimap<Attribute, AttributeModifier> toolAttributes;

    public SDSkilletItem(Block block, Item.Properties properties) {
        super(block, properties);
        this.toolAttributes = null;
    }

    public SDSkilletItem(Block block, Item.Properties properties, Multimap<Attribute, AttributeModifier> toolAttributes) {
        super(block, properties);
        this.toolAttributes = toolAttributes;
    }

    public static UUID getKnockbackUUID() {
        return FD_ATTACK_KNOCKBACK_UUID;
    }

    public boolean m_7579_(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
        if (!this.canAttack()) {
            return false;
        }
        stack.m_41622_(1, attacker, user -> user.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean canCook(ItemStack stack) {
        return stack.m_41773_() < stack.m_41776_() - 1;
    }

    public boolean canAttack() {
        return this.toolAttributes != null;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        BlockHitResult blockhitresult;
        BlockPos pos;
        ItemStack skilletStack = player.m_21120_(hand);
        if ((skilletStack.m_150930_((Item)SDSkilletItems.SKILLETS.get((Object)SkilletMaterial.RED_STEEL).get()) || skilletStack.m_150930_((Item)SDSkilletItems.SKILLETS.get((Object)SkilletMaterial.BLUE_STEEL).get())) && level.m_8055_(pos = (blockhitresult = SDSkilletItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY)).m_82425_()).m_60713_(Blocks.f_49991_)) {
            skilletStack.m_41663_(Enchantments.f_44981_, 2);
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND && this.canAttack() ? this.toolAttributes : ImmutableMultimap.of();
    }

    @Mod.EventBusSubscriber(modid="survivorsdelight", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class SDSkilletEvents {
        @SubscribeEvent
        public static void playSkilletAttackSound(LivingDamageEvent event) {
            LivingEntity livingEntity;
            DamageSource damageSource = event.getSource();
            Entity attacker = damageSource.m_7640_();
            if (attacker instanceof LivingEntity && (livingEntity = (LivingEntity)attacker).m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof SDSkilletItem) {
                float pitch = 0.9f + livingEntity.m_217043_().m_188501_() * 0.2f;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    float attackPower = player.m_36403_(0.0f);
                    if (attackPower > 0.8f) {
                        player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_STRONG.get(), SoundSource.PLAYERS, 1.0f, pitch);
                    } else {
                        player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_WEAK.get(), SoundSource.PLAYERS, 0.8f, 0.9f);
                    }
                } else {
                    livingEntity.m_20193_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)ModSounds.ITEM_SKILLET_ATTACK_STRONG.get(), SoundSource.PLAYERS, 1.0f, pitch);
                }
            }
        }
    }
}

