/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.device.skillet.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletMaterial;
import com.vomiter.survivorsdelight.util.RLUtils;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class SDSkilletLootTableProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput output;

    public SDSkilletLootTableProvider(PackOutput output) {
        this.output = output;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        PackOutput.PathProvider pathProvider = this.output.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables/blocks");
        CompletableFuture[] tasks = (CompletableFuture[])Arrays.stream(SkilletMaterial.values()).map(metal -> {
            ResourceLocation id = RLUtils.build("survivorsdelight", "skillet/" + metal.material);
            Path path = pathProvider.m_245731_(id);
            JsonObject json = SDSkilletLootTableProvider.buildSkilletLootJson(metal.material);
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path);
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(tasks);
    }

    public String m_6055_() {
        return "SurvivorsDelight Skillet Block LootTables";
    }

    private static JsonObject buildSkilletLootJson(String material) {
        JsonObject root = new JsonObject();
        root.addProperty("type", "minecraft:block");
        JsonArray pools = new JsonArray();
        JsonObject pool = new JsonObject();
        pool.addProperty("name", "pool1");
        pool.addProperty("rolls", (Number)1);
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.addProperty("type", "minecraft:item");
        entry.addProperty("name", "survivorsdelight:skillet/" + material);
        JsonArray functions = new JsonArray();
        JsonObject func = new JsonObject();
        func.addProperty("function", "farmersdelight:copy_skillet");
        func.addProperty("source", "block_entity");
        functions.add((JsonElement)func);
        entry.add("functions", (JsonElement)functions);
        entries.add((JsonElement)entry);
        pool.add("entries", (JsonElement)entries);
        JsonArray conditions = new JsonArray();
        JsonObject cond = new JsonObject();
        cond.addProperty("condition", "minecraft:survives_explosion");
        conditions.add((JsonElement)cond);
        pool.add("conditions", (JsonElement)conditions);
        pools.add((JsonElement)pool);
        root.add("pools", (JsonElement)pools);
        return root;
    }
}

