/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.registry;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.vomiter.survivorsdelight.core.device.skillet.SDSkilletItem;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletMaterial;
import com.vomiter.survivorsdelight.core.registry.SDSkilletBlocks;
import com.vomiter.survivorsdelight.util.ItemUUIDs;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="survivorsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SDSkilletItems {
    static final UUID BASE_ATTACK_DAMAGE_UUID = ItemUUIDs.getBaseAttackDamageUUID();
    static final UUID BASE_ATTACK_SPEED_UUID = ItemUUIDs.getBaseAttackSpeedUUID();
    static final UUID KNOCKBACK_UUID = SDSkilletItem.getKnockbackUUID();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"survivorsdelight");
    public static final Map<SkilletMaterial, RegistryObject<Item>> SKILLETS = new EnumMap<SkilletMaterial, RegistryObject<Item>>(SkilletMaterial.class);
    public static RegistryObject<Item> FARMER;

    private SDSkilletItems() {
    }

    public static RegistryObject<Item> get(SkilletMaterial m) {
        return SKILLETS.get((Object)m);
    }

    public static ResourceKey<Item> getKey(SkilletMaterial m) {
        return SKILLETS.get((Object)m).getKey();
    }

    static {
        for (SkilletMaterial m : SkilletMaterial.values()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (m.isWeapon) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", (double)m.attackDamage, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", (double)-3.1f, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(KNOCKBACK_UUID, "Tool modifier", (double)m.attackKnockback, AttributeModifier.Operation.ADDITION));
            }
            Item.Properties properties = new Item.Properties();
            properties.m_41503_(m.durability);
            if (m.equals((Object)SkilletMaterial.RED_STEEL) || m.equals((Object)SkilletMaterial.BLUE_STEEL)) {
                properties = properties.m_41486_();
            }
            Item.Properties finalProperties = properties;
            RegistryObject ro = ITEMS.register(m.path(), () -> m.isWeapon ? new SDSkilletItem((Block)SDSkilletBlocks.SKILLETS.get((Object)m).get(), finalProperties, (Multimap<Attribute, AttributeModifier>)builder.build()) : new SDSkilletItem((Block)SDSkilletBlocks.SKILLETS.get((Object)m).get(), finalProperties));
            SKILLETS.put(m, (RegistryObject<Item>)ro);
            if (!m.equals((Object)SkilletMaterial.STEEL)) continue;
            FARMER = ITEMS.register("skillet/farmer", () -> new SDSkilletItem((Block)SDSkilletBlocks.FARMER.get(), finalProperties, (Multimap<Attribute, AttributeModifier>)builder.build()));
        }
    }
}

