/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.data;

import com.vomiter.survivorsdelight.core.device.skillet.data.SDSkilletBlockModelProvider;
import com.vomiter.survivorsdelight.core.device.skillet.data.SDSkilletBlockStateProvider;
import com.vomiter.survivorsdelight.core.device.skillet.data.SDSkilletItemModelProvider;
import com.vomiter.survivorsdelight.core.device.skillet.data.SDSkilletLootTableProvider;
import com.vomiter.survivorsdelight.data.ModBlockTagsProvider;
import com.vomiter.survivorsdelight.data.ModEntityTypeTagsProvider;
import com.vomiter.survivorsdelight.data.ModItemTagsProvider;
import com.vomiter.survivorsdelight.data.recipe.WoodCuttingRecipes;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivorsdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        ModBlockTagsProvider blockTags = new ModBlockTagsProvider(output, lookupProvider, helper);
        ModItemTagsProvider itemTags = new ModItemTagsProvider(output, lookupProvider, blockTags, helper);
        ModEntityTypeTagsProvider entityTags = new ModEntityTypeTagsProvider(output, lookupProvider, "survivorsdelight", helper);
        WoodCuttingRecipes woodCuttingRecipes = new WoodCuttingRecipes(output);
        SDSkilletBlockModelProvider skilletModelProvider = new SDSkilletBlockModelProvider(output, helper);
        SDSkilletBlockStateProvider skilletBlockStateProvider = new SDSkilletBlockStateProvider(output, helper);
        SDSkilletItemModelProvider skilletItemModelProvider = new SDSkilletItemModelProvider(output, helper);
        SDSkilletLootTableProvider skilletLootTableProvider = new SDSkilletLootTableProvider(output);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)itemTags);
        generator.addProvider(event.includeServer(), (DataProvider)entityTags);
        generator.addProvider(event.includeServer(), (DataProvider)woodCuttingRecipes);
        generator.addProvider(true, (DataProvider)skilletModelProvider);
        generator.addProvider(true, (DataProvider)skilletBlockStateProvider);
        generator.addProvider(true, (DataProvider)skilletItemModelProvider);
        generator.addProvider(event.includeServer(), (DataProvider)skilletLootTableProvider);
    }
}

