/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.data.recipe;

import com.vomiter.survivorsdelight.util.RLUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Metal;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.crafting.ingredient.ToolActionIngredient;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.data.builder.CuttingBoardRecipeBuilder;

public class WoodCuttingRecipes
extends RecipeProvider {
    public WoodCuttingRecipes(PackOutput output) {
        super(output);
    }

    private void stripForBark(Wood wood, Consumer<FinishedRecipe> out) {
        Block log = (Block)wood.getBlock(Wood.BlockType.LOG).get();
        Block strippedLog = (Block)wood.getBlock(Wood.BlockType.STRIPPED_LOG).get();
        Block woodBlock = (Block)wood.getBlock(Wood.BlockType.WOOD).get();
        Block strippedWood = (Block)wood.getBlock(Wood.BlockType.STRIPPED_WOOD).get();
        ItemLike bark = (ItemLike)ModItems.TREE_BARK.get();
        String woodName = wood.m_7912_();
        ResourceLocation logRecipeId = RLUtils.build("survivorsdelight", "cutting/tfc/strip_wood/" + woodName + "_log");
        ResourceLocation woodRecipeId = RLUtils.build("survivorsdelight", "cutting/tfc/strip_wood/" + woodName + "_wood");
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{log}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_STRIP), (ItemLike)strippedLog, (int)1).addResult(bark, 1).addSound("minecraft:item.axe.strip").build(out, logRecipeId);
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{woodBlock}), (Ingredient)new ToolActionIngredient(ToolActions.AXE_STRIP), (ItemLike)strippedWood, (int)1).addResult(bark, 1).addResultWithChance(bark, 0.5f, 1).addSound("minecraft:item.axe.strip").build(out, woodRecipeId);
    }

    private void salvageWoodFurnitureType(Wood wood, Wood.BlockType type, int count, Consumer<FinishedRecipe> out) {
        Item lumber = (Item)((RegistryObject)TFCItems.LUMBER.get(wood)).get();
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)wood.getBlock(type).get()}), (Ingredient)Ingredient.m_204132_((TagKey)new TagKey(ResourceKey.m_135788_((ResourceLocation)RLUtils.build("minecraft", "item")), RLUtils.build("tfc", "saws"))), (ItemLike)lumber, (int)count).build(out, RLUtils.build("survivorsdelight", "cutting/tfc/salvage/wood_furniture/" + wood.m_7912_() + "_" + type.name().toLowerCase(Locale.ROOT)));
    }

    private void salvageHangingSign(Wood wood, Metal.Default metal, Consumer<FinishedRecipe> out) {
        Item lumber = (Item)((RegistryObject)TFCItems.LUMBER.get(wood)).get();
        Block chain = (Block)((RegistryObject)((Map)TFCBlocks.METALS.get(metal)).get(Metal.BlockType.CHAIN)).get();
        CuttingBoardRecipeBuilder.cuttingRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)((RegistryObject)((Map)TFCItems.HANGING_SIGNS.get(wood)).get(metal)).get()}), (Ingredient)Ingredient.m_204132_((TagKey)new TagKey(ResourceKey.m_135788_((ResourceLocation)RLUtils.build("minecraft", "item")), RLUtils.build("tfc", "saws"))), (ItemLike)lumber, (int)2).addResultWithChance((ItemLike)chain, 0.5f, 1).build(out, RLUtils.build("survivorsdelight", "cutting/tfc/salvage/hanging_sign/" + wood.m_7912_() + "_" + metal.m_7912_()));
    }

    private void salvageWoodFurniture(Wood wood, Consumer<FinishedRecipe> out) {
        this.salvageWoodFurnitureType(wood, Wood.BlockType.DOOR, 3, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.TRAPDOOR, 2, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.FENCE, 2, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.LOG_FENCE, 2, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.FENCE_GATE, 2, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.BUTTON, 4, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.PRESSURE_PLATE, 2, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.TOOL_RACK, 6, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.WORKBENCH, 16, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.CHEST, 8, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.TRAPPED_CHEST, 8, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.LOOM, 7, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.SLUICE, 3, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.BARREL, 7, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.BOOKSHELF, 6, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.LECTERN, 10, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.SCRIBING_TABLE, 14, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.SEWING_TABLE, 24, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.AXLE, 4, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.ENCASED_AXLE, 4, out);
        this.salvageWoodFurnitureType(wood, Wood.BlockType.SIGN, 2, out);
    }

    protected void m_245200_(Consumer<FinishedRecipe> out) {
        TFCBlocks.WOODS.forEach((wood, blockTypes) -> {
            this.stripForBark((Wood)wood, out);
            this.salvageWoodFurniture((Wood)wood, out);
            Arrays.stream(Metal.Default.values()).filter(Metal.Default::hasUtilities).forEach(m -> this.salvageHangingSign((Wood)wood, (Metal.Default)m, out));
        });
    }
}

