/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.device.skillet;

import com.vomiter.survivorsdelight.core.device.skillet.ISkilletItemCookingData;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletItemCookingData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="survivorsdelight")
public class SkilletCookingCap {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"survivorsdelight", (String)"skillet_cooking");
    public static final Capability<ISkilletItemCookingData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISkilletItemCookingData>(){});

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(ID, (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        event.getOriginal().getCapability(CAPABILITY).ifPresent(oldCap -> event.getEntity().getCapability(CAPABILITY).ifPresent(newCap -> ((SkilletItemCookingData)newCap).load(((SkilletItemCookingData)oldCap).save())));
    }

    public static ISkilletItemCookingData get(Player player) {
        return (ISkilletItemCookingData)player.getCapability(CAPABILITY).orElseThrow(() -> new IllegalStateException("SkilletCooking capability missing"));
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final SkilletItemCookingData backend = new SkilletItemCookingData();
        private final LazyOptional<ISkilletItemCookingData> optional = LazyOptional.of(() -> this.backend);

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == CAPABILITY ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.backend.save();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.load(nbt);
        }
    }
}

