/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.mixin.device.skillet;

import com.vomiter.survivorsdelight.core.device.skillet.ISkilletItemCookingData;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletCookingCap;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletUtil;
import com.vomiter.survivorsdelight.util.HeatHelper;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.item.SkilletItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

@Mixin(value={SkilletItem.class})
public abstract class SkilletItem_TFCHeatMixin {
    @Unique
    private static final String KEY_COOKING = "Cooking";

    @Unique
    private float sdtfc$getTemperatureNearby(Player player, LevelReader level) {
        BlockPos pos = player.m_20183_();
        float temperature = 0.0f;
        for (BlockPos posNearby : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
            temperature = Math.max(temperature, HeatHelper.getTemperature(posNearby, level, HeatHelper.GetterType.IN_HAND));
        }
        return temperature;
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void sdtfc$use(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack skilletStack = player.m_21120_(hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack heatingStack = player.m_21120_(otherHand);
        if (heatingStack.m_41619_()) {
            return;
        }
        float temperatureNearby = this.sdtfc$getTemperatureNearby(player, (LevelReader)level);
        if (temperatureNearby <= 0.0f) {
            return;
        }
        if (player.m_5842_()) {
            player.m_5661_((Component)TextUtils.getTranslation((String)"item.skilletStack.underwater", (Object[])new Object[0]), true);
            return;
        }
        HeatingRecipe recipe = HeatingRecipe.getRecipe((ItemStackInventory)new ItemStackInventory(heatingStack));
        if (recipe == null) {
            return;
        }
        if (!level.f_46443_) {
            ItemStack unit = heatingStack.m_41620_(1);
            if (unit.m_41619_()) {
                return;
            }
            IHeat heat = HeatCapability.get((ItemStack)unit);
            if (heat == null) {
                heatingStack.m_41769_(1);
                return;
            }
            HeatCapability.addTemp((IHeat)heat, (float)temperatureNearby);
            CompoundTag tag = skilletStack.m_41784_();
            tag.m_128365_(KEY_COOKING, (Tag)unit.serializeNBT());
            ISkilletItemCookingData data = SkilletCookingCap.get(player);
            data.setCooking(unit);
            data.setTargetTemperature(recipe.getTemperature());
            data.setHand(hand);
        }
        player.m_6672_(hand);
        cir.setReturnValue((Object)InteractionResultHolder.m_19098_((Object)skilletStack));
    }

    @Inject(method={"onUseTick"}, at={@At(value="HEAD")})
    private void sdtfc$onUseTick(Level level, LivingEntity living, ItemStack skilletStack, int remainingUseTicks, CallbackInfo ci) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        ISkilletItemCookingData data = SkilletCookingCap.get(player);
        ItemStack cooking = data.getCooking();
        if (cooking.m_41619_()) {
            return;
        }
        float temperatureNearby = this.sdtfc$getTemperatureNearby(player, (LevelReader)level);
        if (temperatureNearby <= 0.0f) {
            return;
        }
        IHeat heat = HeatCapability.get((ItemStack)cooking);
        if (!level.f_46443_) {
            if (heat == null) {
                if (!player.m_36356_(cooking)) {
                    player.m_36176_(cooking, false);
                }
                data.clear();
                if (player.m_6117_()) {
                    player.m_5810_();
                }
                return;
            }
            HeatCapability.addTemp((IHeat)heat, (float)temperatureNearby);
            if (heat.getTemperature() < data.getTargetTemperature()) {
                return;
            }
            HeatingRecipe recipe = HeatingRecipe.getRecipe((ItemStackInventory)new ItemStackInventory(cooking));
            if (recipe != null && recipe.isValidTemperature(heat.getTemperature())) {
                ItemStack result = recipe.assemble(new ItemStackInventory(cooking), level.m_9598_());
                if (!result.m_41619_()) {
                    FoodCapability.applyTrait((ItemStack)result, (FoodTrait)SkilletUtil.skilletCooked);
                    FoodCapability.updateFoodDecayOnCreate((ItemStack)result);
                    if (!player.m_36356_(result)) {
                        player.m_36176_(result, false);
                    }
                }
                data.clear();
                CompoundTag tag = skilletStack.m_41784_();
                if (tag.m_128441_(KEY_COOKING)) {
                    tag.m_128473_(KEY_COOKING);
                }
                if (player.m_6117_()) {
                    player.m_5810_();
                }
            }
        }
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")}, cancellable=true)
    private void sdtfc$releaseUsing(ItemStack skilletStack, Level level, LivingEntity living, int timeLeft, CallbackInfo ci) {
        if (!(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        if (level.f_46443_) {
            return;
        }
        ISkilletItemCookingData data = SkilletCookingCap.get(player);
        if (!data.isCooking()) {
            return;
        }
        ItemStack cooking = data.getCooking();
        CompoundTag tag = skilletStack.m_41784_();
        if (tag.m_128441_(KEY_COOKING)) {
            tag.m_128473_(KEY_COOKING);
        }
        if (!cooking.m_41619_()) {
            data.clear();
            if (!player.m_36356_(cooking)) {
                player.m_36176_(cooking, false);
            }
            ci.cancel();
        }
    }

    @Inject(method={"getUseDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void sdtfc$getUseDuration(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)216000);
    }
}

