/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.device.skillet;

import com.vomiter.survivorsdelight.core.device.skillet.SkilletMaterial;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vectorwing.farmersdelight.client.model.SkilletModel;

@Mod.EventBusSubscriber(modid="survivorsdelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SkilletModels {
    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional event) {
        for (SkilletMaterial m : SkilletMaterial.values()) {
            event.register((ResourceLocation)new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"survivorsdelight", (String)("skillet/" + m.material + "_cooking")), "inventory"));
        }
        event.register((ResourceLocation)new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"survivorsdelight", (String)"skillet/farmer_cooking"), "inventory"));
    }

    public static void makeModel(String name, ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ModelResourceLocation skilletLocation = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"survivorsdelight", (String)("skillet/" + name)), "inventory");
        BakedModel skilletModel = (BakedModel)modelRegistry.get(skilletLocation);
        ModelResourceLocation skilletCookingLocation = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"survivorsdelight", (String)("skillet/" + name + "_cooking")), "inventory");
        BakedModel skilletCookingModel = (BakedModel)modelRegistry.get(skilletCookingLocation);
        modelRegistry.put(skilletLocation, new SkilletModel(event.getModelBakery(), skilletModel, skilletCookingModel));
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        for (SkilletMaterial m : SkilletMaterial.values()) {
            SkilletModels.makeModel(m.material, event);
        }
        SkilletModels.makeModel("farmer", event);
    }
}

