/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.core.device.skillet.data;

import com.vomiter.survivorsdelight.core.device.skillet.SkilletMaterial;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class SDSkilletItemModelProvider
extends ItemModelProvider {
    public SDSkilletItemModelProvider(PackOutput output, ExistingFileHelper efh) {
        super(output, "survivorsdelight", efh);
    }

    protected void registerModels() {
        for (SkilletMaterial m : SkilletMaterial.values()) {
            this.genSkilletModel(m);
        }
    }

    private void genSkilletModel(SkilletMaterial m) {
        String name = m.material;
        ItemModelBuilder skillet = (ItemModelBuilder)this.withExistingParent("item/skillet/" + name, this.modLoc("item/skillet/skillet"));
        ItemModelBuilder cooking = (ItemModelBuilder)this.withExistingParent("item/skillet/" + name + "_cooking", this.modLoc("item/skillet/cooking"));
        ItemModelBuilder head = (ItemModelBuilder)this.withExistingParent("item/skillet_head/" + name, this.modLoc("item/skillet/skillet_head"));
        this.addTextures(m, (ModelBuilder<ItemModelBuilder>)skillet);
        this.addTextures(m, (ModelBuilder<ItemModelBuilder>)cooking);
        this.addTextures(m, (ModelBuilder<ItemModelBuilder>)head);
        ItemModelBuilder uf = (ItemModelBuilder)this.withExistingParent("item/unfinished_skillet/" + name, this.modLoc("item/skillet/" + name));
        this.addTextures(m, (ModelBuilder<ItemModelBuilder>)uf);
        this.existingFileHelper.trackGenerated(ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"block/empty"), PackType.CLIENT_RESOURCES, ".png", "textures");
        uf.texture("2", m.textures.get("0"));
    }

    private void addTextures(SkilletMaterial m, ModelBuilder<ItemModelBuilder> builder) {
        m.textures.forEach((key, rl) -> {
            this.existingFileHelper.trackGenerated(rl, PackType.CLIENT_RESOURCES, ".png", "textures");
            builder.texture(key, rl);
            if (Objects.equals(key, "0")) {
                builder.texture("particle", rl);
            }
        });
    }
}

