/*
 * Decompiled with CFR 0.152.
 */
package com.vomiter.survivorsdelight.mixin.device.skillet;

import com.vomiter.survivorsdelight.core.device.skillet.SDSkilletItem;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletMaterial;
import com.vomiter.survivorsdelight.core.device.skillet.SkilletUtil;
import com.vomiter.survivorsdelight.data.tags.SDItemTags;
import com.vomiter.survivorsdelight.util.HeatHelper;
import java.util.Optional;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vectorwing.farmersdelight.common.block.SkilletBlock;
import vectorwing.farmersdelight.common.block.entity.HeatableBlockEntity;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

@Mixin(value={SkilletBlockEntity.class}, remap=false)
public abstract class SkilletBlockEntity_TFCHeatMixin
implements HeatableBlockEntity {
    @Unique
    private static final Logger survivorsDelight$LOG = LogManager.getLogger((String)"SurvivorsDelight/SkilletMixin");
    @Final
    @Shadow
    private ItemStackHandler inventory;
    @Shadow
    private int cookingTime;
    @Shadow
    private ResourceLocation lastRecipeID;
    @Shadow
    private ItemStack skilletStack;
    @Unique
    private HeatingRecipe sdtfc$cachedHeatingRecipe = null;

    @Shadow
    public abstract void setSkilletItem(ItemStack var1);

    @Inject(method={"addItemToCook"}, at={@At(value="HEAD")}, cancellable=true)
    private void sdtfc$acceptHeatingRecipeOnAdd(ItemStack addedStack, Player player, CallbackInfoReturnable<ItemStack> cir) {
        survivorsDelight$LOG.info("entered addItemToCook inject");
        BlockEntity self = (BlockEntity)this;
        Level lvl = self.m_58904_();
        if (lvl == null || addedStack.m_41619_()) {
            return;
        }
        HeatingRecipe heating = HeatingRecipe.getRecipe((ItemStackInventory)new ItemStackInventory(addedStack));
        if (heating == null) {
            return;
        }
        BlockState state = self.m_58900_();
        if (state.m_61138_((Property)SkilletBlock.WATERLOGGED) && ((Boolean)state.m_61143_((Property)SkilletBlock.WATERLOGGED)).booleanValue()) {
            player.m_5661_((Component)TextUtils.getTranslation((String)"block.skillet.underwater", (Object[])new Object[0]), true);
            cir.setReturnValue((Object)addedStack);
            return;
        }
        this.sdtfc$cachedHeatingRecipe = heating;
        boolean wasEmpty = this.inventory.getStackInSlot(0).m_41619_();
        ItemStack remainder = this.inventory.insertItem(0, addedStack.m_41777_(), false);
        if (!ItemStack.m_41728_((ItemStack)remainder, (ItemStack)addedStack)) {
            this.lastRecipeID = null;
            this.cookingTime = 0;
            BlockPos pos = self.m_58899_();
            if (!ItemUtils.isInventoryEmpty((IItemHandler)this.inventory) && wasEmpty) {
                lvl.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            }
            cir.setReturnValue((Object)remainder);
            return;
        }
        cir.setReturnValue((Object)addedStack);
    }

    @Inject(method={"cookAndOutputItems"}, at={@At(value="HEAD")}, cancellable=true)
    private void sdtfc$cookWithBelowTemperature(ItemStack cookingStack, Level level, CallbackInfo ci) {
        SDSkilletItem sdSkilletItem;
        survivorsDelight$LOG.info("cooking");
        BlockEntity self = (BlockEntity)this;
        BlockPos pos = self.m_58899_();
        if (level == null || cookingStack.m_41619_()) {
            return;
        }
        if (this.sdtfc$hasCampfireRecipe(level, cookingStack)) {
            return;
        }
        Item item = this.skilletStack.m_41720_();
        if (item instanceof SDSkilletItem && !(sdSkilletItem = (SDSkilletItem)item).canCook(this.skilletStack) && this.skilletStack.m_204117_(SDItemTags.RETURN_COPPER_SKILLET)) {
            CompoundTag tag = this.skilletStack.serializeNBT();
            tag.m_128359_("id", SkilletMaterial.COPPER.location().toString());
            ItemStack newSkilletStack = ItemStack.m_41712_((CompoundTag)tag);
            newSkilletStack.m_41721_(0);
            this.setSkilletItem(newSkilletStack);
            level.m_46961_(pos, true);
        }
        if (this.sdtfc$cachedHeatingRecipe == null) {
            this.sdtfc$cachedHeatingRecipe = HeatingRecipe.getRecipe((ItemStackInventory)new ItemStackInventory(cookingStack));
            if (this.sdtfc$cachedHeatingRecipe == null) {
                return;
            }
        }
        float belowTemp = this.sdtfc$getBelowDeviceTemperatureSafe();
        IHeat heat = HeatCapability.get((ItemStack)cookingStack);
        if (heat == null || belowTemp <= 0.0f) {
            ci.cancel();
            return;
        }
        HeatCapability.addTemp((IHeat)heat, (float)belowTemp);
        if (this.sdtfc$cachedHeatingRecipe.isValidTemperature(heat.getTemperature())) {
            ItemStack result = this.sdtfc$cachedHeatingRecipe.assemble(new ItemStackInventory(cookingStack), level.m_9598_());
            FoodCapability.applyTrait((ItemStack)result, (FoodTrait)SkilletUtil.skilletCooked);
            FoodCapability.updateFoodDecayOnCreate((ItemStack)result);
            BlockState state = self.m_58900_();
            Direction direction = ((Direction)state.m_61143_((Property)SkilletBlock.FACING)).m_122427_();
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)result.m_41777_(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((float)direction.m_122429_() * 0.08f), (double)0.25, (double)((float)direction.m_122431_() * 0.08f));
            this.cookingTime = 0;
            this.inventory.extractItem(0, 1, false);
            level.m_6263_(null, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get(), SoundSource.BLOCKS, 0.8f, 1.0f);
            this.sdtfc$cachedHeatingRecipe = null;
            if (!level.f_46443_ && this.skilletStack.m_41720_() instanceof SDSkilletItem) {
                FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)level.m_7654_().m_129880_(level.m_46472_()));
                fakePlayer.m_143403_(GameType.SURVIVAL);
                this.skilletStack.m_41622_(1 + SkilletUtil.extraHurtForTemperature(this.skilletStack, belowTemp), (LivingEntity)fakePlayer, user -> {});
            }
        }
        ci.cancel();
    }

    @Inject(method={"removeItem"}, at={@At(value="TAIL")})
    private void sdtfc$clearCacheOnRemove(CallbackInfoReturnable<ItemStack> cir) {
        this.sdtfc$cachedHeatingRecipe = null;
    }

    @Unique
    private float sdtfc$getBelowDeviceTemperatureSafe() {
        BlockEntity self = (BlockEntity)this;
        Level level = self.m_58904_();
        if (level == null) {
            return 0.0f;
        }
        BlockPos pos = self.m_58899_();
        return HeatHelper.getTargetTemperature(pos, (LevelReader)level, this.requiresDirectHeat(), HeatHelper.GetterType.BLOCK);
    }

    @Unique
    private boolean sdtfc$hasCampfireRecipe(Level level, ItemStack stack) {
        Optional recipe;
        SimpleContainer recipeWrapper = new SimpleContainer(new ItemStack[]{stack});
        if (this.lastRecipeID != null && (recipe = (Recipe)((RecipeManagerAccessor)level.m_7465_()).getRecipeMap(RecipeType.f_44111_).get(this.lastRecipeID)) instanceof CampfireCookingRecipe && recipe.m_5818_((Container)recipeWrapper, level)) {
            return true;
        }
        recipe = level.m_7465_().m_44015_(RecipeType.f_44111_, (Container)recipeWrapper, level);
        return recipe.isPresent();
    }

    @Unique
    private ItemStack sdtfc$getStoredStack() {
        return this.inventory.getStackInSlot(0);
    }
}

