package net.quantumaidan.itemLore.util;

import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.quantumaidan.itemLore.ItemLore;
import net.quantumaidan.itemLore.config.itemLoreConfig;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class setLore {

    public static boolean applyNewLore(class_1657 player, class_1799 itemStack) {
        if (!itemLoreConfig.enabled) return false;

        // Safe time zone handling
        TimeZone tz = TimeZone.getTimeZone(itemLoreConfig.timeZone);
        if (tz.getID().equals("GMT") && !itemLoreConfig.timeZone.equalsIgnoreCase("GMT")) {
            tz = TimeZone.getTimeZone("UTC");
            ItemLore.LOGGER.warn("[ItemLore] Invalid time zone '{}', defaulting to UTC", itemLoreConfig.timeZone);
        }

        // Safe date format handling
        String reportDate = "";
        try {
            DateFormat df = new SimpleDateFormat(itemLoreConfig.dateTimeFormatConfig);
            df.setTimeZone(tz);
            reportDate = df.format(new Date());

            if (reportDate.equals(itemLoreConfig.dateTimeFormatConfig)
                    || reportDate.matches("[AP]M?[0-9APM]*")) {
                throw new IllegalArgumentException("Formatted date is likely nonsense");
            }
        } catch (IllegalArgumentException e) {
            reportDate = "Invalid Date Format";
            ItemLore.LOGGER.warn("[ItemLore] Invalid date format '{}', using fallback text", itemLoreConfig.dateTimeFormatConfig);
        }

        class_9290 inputLore = itemStack.method_58694(class_9334.field_49632);
        if (inputLore == null || inputLore.comp_2400() == null || inputLore.comp_2400().isEmpty()) {
            class_9290 newLoreComponent = new class_9290(List.of(
                    class_2561.method_43470(reportDate).method_10862(class_2583.field_24360.method_10977(class_124.field_1064)),
                    class_2561.method_43470("UID: ").method_10852(player.method_5476()).method_10862(class_2583.field_24360.method_10977(class_124.field_1064))
            ));

            itemStack.method_57379(class_9334.field_49632, newLoreComponent);
            return true;
        }


        return false;
    }
}
