package net.quantumaidan.itemLore;

import eu.midnightdust.lib.config.MidnightConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.quantumaidan.itemLore.config.itemLoreConfig;
import net.quantumaidan.itemLore.util.setLore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Objects;

import static java.lang.String.valueOf;

public class ItemLore implements ModInitializer {
	public static final String MOD_ID = "itemLore";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	@Override
	public void onInitialize() {
		MidnightConfig.init("itemLore", itemLoreConfig.class);


		LOGGER.info(MOD_ID + " Initialized");

		//ApplyLore Command
		CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
			dispatcher.register(class_2170.method_9247("applylore")
					.executes(context -> {
						if (context.getSource().method_44023() == null){ //not a player
							context.getSource().method_9213(class_2561.method_43470("Something attempted to run ApplyLore"));
							return 1;
						}
						else if (!itemLoreConfig.enabled){ //feature is disabled
							context.getSource().method_44023().method_7353(class_2561.method_43470("ItemLore is currently disabled."), false);
							return 1;
						}
						else if (context.getSource().method_44023().method_6047() == null){ //player is not holding an item
							context.getSource().method_44023().method_7353(class_2561.method_43470("You are not holding anything!"), false);
							return 1;
						}
						else if (context.getSource().method_44023().method_6047() != null){ //player is holding item
							if (setLore.applyNewLore(context.getSource().method_44023(), Objects.requireNonNull(context.getSource().method_44023()).method_6047())){
								context.getSource().method_45068(class_2561.method_43470("Lore applied!"));
								return 1;
							}
							else {
								context.getSource().method_45068(class_2561.method_43470("Lore already exists."));
								return 1;
							}
						}
						context.getSource().method_9213(class_2561.method_43470("Error: fell off the end of the function."));
						context.getSource().method_44023().method_7353(class_2561.method_43470("lore application attempted"), false);
						context.getSource().method_44023().method_7353(class_2561.method_43470(context.getSource().method_44023().toString()), false);
						context.getSource().method_44023().method_7353(class_2561.method_43470(context.getSource().method_44023().method_6047().toString()), false);
						return 1;
					}));
		});

		//getComponents
		CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
			dispatcher.register(class_2170.method_9247("getComponents")
					.requires(source -> source.method_9259(2))
					.executes(context -> {
						class_1799 stack = Objects.requireNonNull(context.getSource().method_44023()).method_6047();
						class_9290 loreComponent = new class_9290(List.of());
						context.getSource().method_44023().method_64398(class_2561.method_43470(stack.method_58694(class_9334.field_49632).toString()));
						context.getSource().method_44023().method_64398(class_2561.method_43470(loreComponent.toString()));
						return 0;
					}));
		});

		CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
			dispatcher.register(class_2170.method_9247("toggleItemLore")
					.requires(source -> source.method_9259(2))
					.executes(context -> {
						itemLoreConfig.enabled = !itemLoreConfig.enabled;
						context.getSource().method_9226(() -> class_2561.method_43470("ItemLore Toggle set to: " + itemLoreConfig.enabled), false);
						return 1;
					}));
		});
	}
}

//to move the custom commands to a util folder, you would need to define everything the function does there, and initialize it into the commandregistration register here.
//or, in other words split it up a lot. might be nice if a lot of these are added.
