/*
 * Decompiled with CFR 0.152.
 */
package be.andy.shulkerbundle;

import be.andy.shulkerbundle.ShulkerPickup;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5537;
import net.minecraft.class_747;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class BundleItemScreenHandler
extends class_1703 {
    private final class_1792 originalBundleItemType;
    private final class_2561 originalCustomName;
    private final int bundleGuiInventorySize;
    private final class_1263 bundleSlotsInventory;
    private final class_1268 handContext;
    private final int originalSlot;
    public static final int MAX_MANUAL_UNIQUE_ITEMS_IN_BUNDLE_GUI = 27;
    public static final int MAX_BUNDLE_GUI_SLOTS = 27;
    public static final int SLOTS_PER_ROW = 9;

    public BundleItemScreenHandler(int syncId, class_1661 playerInventory, class_1263 displayInventory, class_1792 originalBundleItemType, class_2561 originalCustomName, class_1268 handContext, int rows, int originalSlot) {
        super(BundleItemScreenHandler.getScreenHandlerTypeForRows(rows), syncId);
        int c;
        this.originalBundleItemType = originalBundleItemType != null ? originalBundleItemType : class_1802.field_27023;
        this.originalCustomName = originalCustomName;
        this.bundleSlotsInventory = displayInventory;
        this.bundleGuiInventorySize = rows * 9;
        this.handContext = handContext;
        this.originalSlot = originalSlot;
        this.bundleSlotsInventory.method_5435(playerInventory.field_7546);
        int yOffsetBundle = 18;
        for (int r = 0; r < rows; ++r) {
            for (c = 0; c < 9; ++c) {
                this.method_7621(new BundleGuiSlot(this.bundleSlotsInventory, c + r * 9, 8 + c * 18, yOffsetBundle + r * 18));
            }
        }
        int yOffsetPlayer = yOffsetBundle + rows * 18 + 14;
        for (int r = 0; r < 3; ++r) {
            for (int c2 = 0; c2 < 9; ++c2) {
                this.method_7621(new class_1735((class_1263)playerInventory, c2 + r * 9 + 9, 8 + c2 * 18, yOffsetPlayer + r * 18));
            }
        }
        for (c = 0; c < 9; ++c) {
            this.method_7621(new class_1735((class_1263)playerInventory, c, 8 + c * 18, yOffsetPlayer + 58));
        }
    }

    public class_1268 getHandContext() {
        return this.handContext;
    }

    public class_1792 getOriginalBundleItemType() {
        return this.originalBundleItemType;
    }

    public class_2561 getOriginalCustomName() {
        return this.originalCustomName;
    }

    public class_1263 getBundleSlotsInventory() {
        return this.bundleSlotsInventory;
    }

    public int getBundleGuiInventorySize() {
        return this.bundleGuiInventorySize;
    }

    public int getOriginalSlot() {
        return this.originalSlot;
    }

    private static class_3917<?> getScreenHandlerTypeForRows(int rows) {
        return switch (Math.max(1, Math.min(rows, 3))) {
            case 1 -> class_3917.field_18664;
            case 2 -> class_3917.field_18665;
            default -> class_3917.field_17326;
        };
    }

    public void method_7595(class_1657 player) {
        if (ShulkerPickup.HANDLERS_CLOSED_BY_MOD.contains((Object)this)) {
            return;
        }
        ShulkerPickup.HANDLERS_CLOSED_BY_MOD.add(this);
        super.method_7595(player);
        ShulkerPickup.playerLastClickTime.remove(player.method_5667());
        if (!player.method_37908().method_8608() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_5250 expectedPlaceholderNameText = class_2561.method_43470((String)"Editing: ");
            if (this.originalCustomName != null) {
                expectedPlaceholderNameText.method_10852(this.originalCustomName);
            } else {
                expectedPlaceholderNameText.method_10852((class_2561)class_2561.method_43471((String)this.originalBundleItemType.method_7876()));
            }
            class_5250 finalExpectedPlaceholderName = expectedPlaceholderNameText.method_27692(ShulkerPickup.PLACEHOLDER_BUNDLE_NAME_FORMATTING);
            class_1661 pInv = serverPlayer.method_31548();
            for (int i = 0; i < pInv.method_5439(); ++i) {
                class_2561 currentCustomName;
                class_1799 currentSlotStack = pInv.method_5438(i);
                if (!ShulkerPickup.isPlaceholderBundle(currentSlotStack) || currentSlotStack.method_7909() != this.originalBundleItemType || (currentCustomName = (class_2561)currentSlotStack.method_58694(class_9334.field_49631)) == null || !currentCustomName.equals((Object)finalExpectedPlaceholderName)) continue;
                pInv.method_5447(i, class_1799.field_8037);
                break;
            }
            ArrayList<class_1799> itemsFromGui = new ArrayList<class_1799>();
            for (int i = 0; i < this.bundleGuiInventorySize; ++i) {
                class_1799 stackInSlot = this.bundleSlotsInventory.method_5438(i);
                if (stackInSlot.method_7960()) continue;
                itemsFromGui.add(stackInSlot.method_7972());
            }
            ArrayList<class_1799> itemsToSaveToBundle = new ArrayList<class_1799>();
            HashSet<class_1792> uniqueTypesForFinalSave = new HashSet<class_1792>();
            for (class_1799 stackFromGui : itemsFromGui) {
                if (uniqueTypesForFinalSave.contains(stackFromGui.method_7909()) || uniqueTypesForFinalSave.size() < 27) {
                    uniqueTypesForFinalSave.add(stackFromGui.method_7909());
                    itemsToSaveToBundle.add(stackFromGui);
                    continue;
                }
                player.method_31548().method_7398(stackFromGui);
            }
            class_1799 finalBundleStack = new class_1799((class_1935)this.originalBundleItemType);
            if (!itemsToSaveToBundle.isEmpty()) {
                finalBundleStack.method_57379(class_9334.field_49650, (Object)new class_9276(itemsToSaveToBundle));
            }
            if (this.originalCustomName != null) {
                finalBundleStack.method_57379(class_9334.field_49631, (Object)this.originalCustomName);
            }
            if (serverPlayer.method_31548().method_5438(this.originalSlot).method_7960()) {
                serverPlayer.method_31548().method_5447(this.originalSlot, finalBundleStack);
            } else {
                class_2487 nbt = ((class_9279)finalBundleStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
                nbt.method_10556("shulkerbundle_ignore_pickup", true);
                finalBundleStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
                if (!serverPlayer.method_31548().method_7394(finalBundleStack)) {
                    serverPlayer.method_7328(finalBundleStack, false);
                }
            }
        }
        this.bundleSlotsInventory.method_5448();
    }

    public static void open(class_3222 player, class_9276 initialContents, class_2561 originalCustomName, class_1792 originalBundleItemType, class_1268 handContext, int originalSlot) {
        ArrayList itemsToDisplayInGui = new ArrayList();
        HashSet uniqueItemTypesInNbt = new HashSet();
        if (initialContents != null) {
            initialContents.method_57421().forEach(itemStack -> {
                if (!itemStack.method_7960()) {
                    itemsToDisplayInGui.add(itemStack.method_7972());
                    uniqueItemTypesInNbt.add(itemStack.method_7909());
                }
            });
        }
        if (uniqueItemTypesInNbt.size() > 27) {
            class_1799 currentHandStack;
            player.method_7353((class_2561)class_2561.method_43470((String)"Cannot open Bundle: exceeds unique item limit of 27").method_27692(class_124.field_1061), false);
            class_1799 originalBundleStack = new class_1799((class_1935)originalBundleItemType);
            if (initialContents != null && !initialContents.method_57429()) {
                originalBundleStack.method_57379(class_9334.field_49650, (Object)initialContents);
            }
            if (originalCustomName != null) {
                originalBundleStack.method_57379(class_9334.field_49631, (Object)originalCustomName);
            }
            if (ShulkerPickup.isPlaceholderBundle(currentHandStack = player.method_5998(handContext))) {
                player.method_6122(handContext, originalBundleStack);
                player.field_7498.method_34252();
            }
            return;
        }
        int numberOfUniqueTypes = uniqueItemTypesInNbt.size();
        int rows = numberOfUniqueTypes <= 9 ? 1 : (numberOfUniqueTypes <= 18 ? 2 : 3);
        int guiInventorySize = rows * 9;
        class_1277 displayInventoryForGui = new class_1277(guiInventorySize);
        for (int i = 0; i < itemsToDisplayInGui.size() && i < guiInventorySize; ++i) {
            displayInventoryForGui.method_5447(i, (class_1799)itemsToDisplayInGui.get(i));
        }
        class_2561 screenTitle = originalCustomName != null ? originalCustomName : class_2561.method_43471((String)originalBundleItemType.method_7876());
        int finalRows = rows;
        player.method_17355((class_3908)new class_747((syncId, playerInv, p) -> new BundleItemScreenHandler(syncId, playerInv, (class_1263)displayInventoryForGui, originalBundleItemType, originalCustomName, handContext, finalRows, originalSlot), screenTitle));
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            class_1799 newStack = originalStack.method_7972();
            if (slotIndex < this.bundleGuiInventorySize ? !this.method_7616(newStack, this.bundleGuiInventorySize, this.field_7761.size(), true) : !this.method_7616(newStack, 0, this.bundleGuiInventorySize, false)) {
                return class_1799.field_8037;
            }
            if (newStack.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (newStack.method_7947() == originalStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, newStack);
            return originalStack;
        }
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        class_1799 stackInHand = player.method_5998(this.handContext);
        return ShulkerPickup.isPlaceholderBundle(stackInHand) && stackInHand.method_7909() == this.originalBundleItemType;
    }

    private static class BundleGuiSlot
    extends class_1735 {
        private final class_1263 bundleSlotsInventoryRef;

        public BundleGuiSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            this.bundleSlotsInventoryRef = inventory;
        }

        public boolean method_7680(class_1799 stackToInsert) {
            if (stackToInsert.method_7960() || !super.method_7680(stackToInsert)) {
                return false;
            }
            class_9279 itemCustomDataNbt = (class_9279)stackToInsert.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 itemNbt = itemCustomDataNbt.method_57461();
            if (itemNbt.method_10577("CrateBundleNoAutoPickup").orElse(false).booleanValue()) {
                return false;
            }
            if (ShulkerPickup.isPlaceholderBundle(stackToInsert)) {
                return false;
            }
            if (ShulkerPickup.isPlaceholderShulkerBox(stackToInsert)) {
                return false;
            }
            if (stackToInsert.method_7909() instanceof class_5537 ? !ShulkerPickup.isBundleEmpty(stackToInsert) : ShulkerPickup.isGuiBlacklisted(stackToInsert.method_7909())) {
                return false;
            }
            HashSet<class_1792> uniqueItemsIfInserted = new HashSet<class_1792>();
            for (int i = 0; i < this.bundleSlotsInventoryRef.method_5439(); ++i) {
                class_1799 existingStackInSlot = this.bundleSlotsInventoryRef.method_5438(i);
                if (i == this.method_34266()) {
                    if (stackToInsert.method_7960()) continue;
                    uniqueItemsIfInserted.add(stackToInsert.method_7909());
                    continue;
                }
                if (existingStackInSlot.method_7960()) continue;
                uniqueItemsIfInserted.add(existingStackInSlot.method_7909());
            }
            if (uniqueItemsIfInserted.size() <= 27) {
                return true;
            }
            class_1799 stackCurrentlyInSlot = this.bundleSlotsInventoryRef.method_5438(this.method_34266());
            boolean isReplacing = !stackCurrentlyInSlot.method_7960();
            boolean typeAlreadyPresent = false;
            for (int i = 0; i < this.bundleSlotsInventoryRef.method_5439(); ++i) {
                if (i == this.method_34266() && isReplacing || this.bundleSlotsInventoryRef.method_5438(i).method_7960() || this.bundleSlotsInventoryRef.method_5438(i).method_7909() != stackToInsert.method_7909()) continue;
                typeAlreadyPresent = true;
                break;
            }
            return typeAlreadyPresent || isReplacing && stackCurrentlyInSlot.method_7909() == stackToInsert.method_7909();
        }
    }
}

