/*
 * Decompiled with CFR 0.152.
 */
package be.andy.shulkerbundle;

import be.andy.shulkerbundle.BundleItemScreenHandler;
import be.andy.shulkerbundle.ClientSettingsPayload;
import be.andy.shulkerbundle.ModMenuHandshakePayload;
import be.andy.shulkerbundle.PermissionChecker;
import be.andy.shulkerbundle.ShulkerItemScreenHandler;
import be.andy.shulkerbundle.command.ShulkerBundleCommand;
import be.andy.shulkerbundle.config.ModConfig;
import be.andy.shulkerbundle.config.PlayerConfig;
import be.andy.shulkerbundle.config.PlayerConfigManager;
import be.andy.shulkerbundle.mixin.PlayerInventoryAccess;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2649;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5537;
import net.minecraft.class_5894;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ShulkerPickup
implements ModInitializer {
    public static final String MOD_ID = "shulkerbundle";
    private static final Set<UUID> playersWithMod = new HashSet<UUID>();
    public static final String PLACEHOLDER_BUNDLE_NAME_PREFIX = "Editing: ";
    public static final class_124 PLACEHOLDER_BUNDLE_NAME_FORMATTING = class_124.field_1054;
    public static final String PLACEHOLDER_SHULKER_NAME_PREFIX = "Editing Shulker: ";
    public static final class_124 PLACEHOLDER_SHULKER_NAME_FORMATTING = class_124.field_1075;
    public static final String IS_PLACEHOLDER_SHULKER_NBT_KEY = "shulkerbundle_is_placeholder_shulker";
    public static final String IGNORE_PICKUP_NBT_KEY = "shulkerbundle_ignore_pickup";
    public static final String CRATE_BUNDLE_NBT_KEY = "CrateBundleNoAutoPickup";
    public static final String PERMISSION_OPEN_SHULKER_GUI = "shulkerbundle.open";
    public static final String PERMISSION_OPEN_BUNDLE_GUI = "shulkerbundle.open_bundle_gui";
    public static final String PERMISSION_HOLD_SHULKER = "shulkerbundle.hold.shulker";
    public static final String PERMISSION_HOLD_BUNDLE = "shulkerbundle.hold.bundle";
    public static final String PERMISSION_NOTIFY_SHULKER = "shulkerbundle.notify.shulker";
    public static final String PERMISSION_NOTIFY_BUNDLE = "shulkerbundle.notify.bundle";
    public static final String PERMISSION_ADMIN = "shulkerbundle.admin";
    public static final Set<class_1792> AUTO_PICKUP_BUNDLE_BLACKLIST = new HashSet<class_1792>();
    public static final Set<class_1792> GUI_BUNDLE_BLACKLIST = new HashSet<class_1792>();
    public static final Set<class_1792> GUI_SHULKER_BLACKLIST = new HashSet<class_1792>();
    public static final ConcurrentHashMap<UUID, Long> playerLastClickTime = new ConcurrentHashMap();
    public static final long CLICK_COOLDOWN_MS = 100L;
    public static final Set<class_1703> HANDLERS_CLOSED_BY_MOD = Collections.newSetFromMap(new WeakHashMap());
    private static final ConcurrentHashMap<UUID, Integer> playerLastShulkerThirdRowFill = new ConcurrentHashMap();
    private static final ThreadLocal<class_1799> LAST_MODIFIED_BUNDLE = ThreadLocal.withInitial(() -> class_1799.field_8037);

    public static void setLastModifiedBundle(class_1799 bundle) {
        LAST_MODIFIED_BUNDLE.set(bundle);
    }

    public static void clearLastModifiedBundle() {
        LAST_MODIFIED_BUNDLE.remove();
    }

    public static boolean isAutoPickupBlacklisted(class_1792 item) {
        if (item.method_7882() == 1) {
            return true;
        }
        return AUTO_PICKUP_BUNDLE_BLACKLIST.contains(item);
    }

    public static boolean isGuiBlacklisted(class_1792 item) {
        return GUI_BUNDLE_BLACKLIST.contains(item);
    }

    public static boolean hasMod(class_1657 player) {
        return playersWithMod.contains(player.method_5667());
    }

    public static boolean isPlaceholderBundle(class_1799 stack) {
        if (stack.method_7909() instanceof class_5537) {
            class_2561 customName = (class_2561)stack.method_58694(class_9334.field_49631);
            return customName != null && customName.getString().startsWith(PLACEHOLDER_BUNDLE_NAME_PREFIX);
        }
        return false;
    }

    public static boolean isPlaceholderShulkerBox(class_1799 stack) {
        boolean isReinforcedShulker;
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        boolean isVanillaShulker = block instanceof class_2480;
        boolean bl = isReinforcedShulker = class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().equals("reinfshulker") && class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().contains("shulker_box");
        if (isVanillaShulker || isReinforcedShulker) {
            class_2487 nbt;
            class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
            if (customData != null && (nbt = customData.method_57461()) != null && nbt.method_10545(IS_PLACEHOLDER_SHULKER_NBT_KEY) && nbt.method_10577(IS_PLACEHOLDER_SHULKER_NBT_KEY).orElse(false).booleanValue()) {
                return true;
            }
            class_2561 customName = (class_2561)stack.method_58694(class_9334.field_49631);
            return customName != null && customName.getString().startsWith(PLACEHOLDER_SHULKER_NAME_PREFIX);
        }
        return false;
    }

    public static boolean isBundleEmpty(class_1799 bundleStack) {
        if (!(bundleStack.method_7909() instanceof class_5537)) {
            return true;
        }
        class_9276 contents = (class_9276)bundleStack.method_58694(class_9334.field_49650);
        return contents == null || contents.method_57429();
    }

    public static boolean checkPermission(class_2168 source, String permissionNode, int defaultOpLevel) {
        return PermissionChecker.check(source, permissionNode, defaultOpLevel);
    }

    private ShulkerTypeInfo getShulkerTypeInfo(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (itemId.method_12836().equals("reinfshulker")) {
            String path = itemId.method_12832();
            if (path.contains("copper")) {
                return this.findAndCreateInfo("copper", 5);
            }
            if (path.contains("iron")) {
                return this.findAndCreateInfo("iron", 6);
            }
            if (path.contains("gold")) {
                return this.findAndCreateInfo("gold", 9);
            }
            if (path.contains("diamond")) {
                return this.findAndCreateInfo("diamond", 12);
            }
            if (path.contains("netherite")) {
                return this.findAndCreateInfo("netherite", 12);
            }
        }
        return new ShulkerTypeInfo(class_3917.field_17326, 3);
    }

    private ShulkerTypeInfo findAndCreateInfo(String keyword, int rows) {
        class_3917<?> type = this.findScreenHandler(keyword);
        if (type == null) {
            return null;
        }
        return new ShulkerTypeInfo(type, rows);
    }

    private class_3917<?> findScreenHandler(String keyword) {
        for (class_2960 id : class_7923.field_41187.method_10235()) {
            if (!id.method_12836().equals("reinfshulker") || !id.method_12832().contains(keyword)) continue;
            return (class_3917)class_7923.field_41187.method_63535(id);
        }
        for (class_2960 id : class_7923.field_41187.method_10235()) {
            if (!id.method_12836().equals("reinfcore") || !id.method_12832().contains(keyword)) continue;
            return (class_3917)class_7923.field_41187.method_63535(id);
        }
        return null;
    }

    public void onInitialize() {
        ModConfig.loadConfig();
        PayloadTypeRegistry.playC2S().register(ModMenuHandshakePayload.ID, ModMenuHandshakePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ClientSettingsPayload.ID, ClientSettingsPayload.CODEC);
        AUTO_PICKUP_BUNDLE_BLACKLIST.add(class_1802.field_17534);
        AUTO_PICKUP_BUNDLE_BLACKLIST.add(class_1802.field_8741);
        AUTO_PICKUP_BUNDLE_BLACKLIST.add(class_1802.field_27023);
        GUI_BUNDLE_BLACKLIST.add(class_1802.field_17534);
        GUI_BUNDLE_BLACKLIST.add(class_1802.field_8741);
        for (class_1792 item : class_7923.field_41178) {
            class_2248 block = class_2248.method_9503((class_1792)item);
            if (!(block instanceof class_2480)) continue;
            GUI_BUNDLE_BLACKLIST.add(item);
            GUI_SHULKER_BLACKLIST.add(item);
        }
        for (class_1792 item : class_7923.field_41178) {
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            if (!id.method_12836().equals("reinfshulker") || !id.method_12832().contains("shulker_box")) continue;
            GUI_BUNDLE_BLACKLIST.add(item);
            GUI_SHULKER_BLACKLIST.add(item);
        }
        ServerPlayNetworking.registerGlobalReceiver(ModMenuHandshakePayload.ID, (payload, context) -> playersWithMod.add(context.player().method_5667()));
        ServerPlayNetworking.registerGlobalReceiver(ClientSettingsPayload.ID, (payload, context) -> {
            class_3222 player = context.player();
            PlayerConfig playerConfig = PlayerConfigManager.getOrCreatePlayerConfig(player);
            playerConfig.setPickupShulkerEnabled(payload.pickupShulker());
            playerConfig.setPickupBundleEnabled(payload.pickupBundle());
            playerConfig.setGuiShulkerEnabled(payload.guiShulker());
            playerConfig.setGuiBundleEnabled(payload.guiBundle());
            playerConfig.setNotifyShulkerEnabled(payload.notifyShulker());
            playerConfig.setNotifyBundleEnabled(payload.notifyBundle());
            playerConfig.setDenyMultiplayerPermissions(payload.denyPermissions());
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            PlayerConfigManager.getOrCreatePlayerConfig(handler.field_14140);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(this){

                @Override
                public void run() {
                    MinecraftServer playerServer = handler.field_14140.method_37908().method_8503();
                    if (playerServer != null) {
                        playerServer.execute(() -> {
                            PlayerConfig playerConfig;
                            if (handler2.field_14140 != null && !playersWithMod.contains(handler2.field_14140.method_5667()) && ModConfig.getInstance().isNotifyPlayerEnabled() && (playerConfig = PlayerConfigManager.getOrCreatePlayerConfig(handler2.field_14140)).getNotificationCount() < 2) {
                                class_2558.class_10608 clickEvent = null;
                                try {
                                    clickEvent = new class_2558.class_10608(new URI("https://modrinth.com/mod/shulker-bundle"));
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    // empty catch block
                                }
                                class_2558.class_10608 finalClickEvent = clickEvent;
                                class_5250 shulkerBundleText = class_2561.method_43470((String)"'Shulker Bundle'").method_27695(new class_124[]{class_124.field_1054, class_124.field_1073}).method_27694(arg_0 -> 1.lambda$run$0((class_2558)finalClickEvent, arg_0));
                                class_5250 message = class_2561.method_43470((String)"Get the ").method_27692(class_124.field_1054).method_10852((class_2561)shulkerBundleText).method_10852((class_2561)class_2561.method_43470((String)" mod to control shulker and bundle settings!").method_27692(class_124.field_1054));
                                ShulkerPickup.sendActionBarMessage(handler2.field_14140, (class_2561)message);
                                playerConfig.setNotificationCount(playerConfig.getNotificationCount() + 1);
                                PlayerConfigManager.savePlayerConfig(handler2.field_14140);
                            }
                        });
                    }
                }

                private static /* synthetic */ class_2583 lambda$run$0(class_2558 finalClickEvent, class_2583 style) {
                    return finalClickEvent != null ? style.method_10958(finalClickEvent) : style;
                }
            }, 3000L);
        });
        ServerPlayConnectionEvents.DISCONNECT.register(this::handlePlayerDisconnect);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            PlayerConfigManager.init(server);
            System.out.println("[ShulkerBundle] Scanning for Reinforced Shulker Screen Handlers...");
            boolean foundAny = false;
            for (class_2960 id : class_7923.field_41187.method_10235()) {
                if (!id.method_12836().equals("reinfshulker") && !id.method_12836().equals("reinfcore")) continue;
                System.out.println("[ShulkerBundle] Found Mod ScreenHandler: " + id.toString());
                foundAny = true;
            }
            if (!foundAny) {
                System.out.println("[ShulkerBundle] WARNING: No Reinforced Shulker Screen Handlers found in registry! Compatibility will be disabled.");
            }
        });
        UseItemCallback.EVENT.register((player, world, eventHand) -> {
            if (world.method_8608() || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 sPlayer = (class_3222)player;
            MinecraftServer playerServer = sPlayer.method_37908().method_8503();
            boolean isSinglePlayer = playerServer != null ? playerServer.method_3724() : false;
            PlayerConfig playerConfig = PlayerConfigManager.getOrCreatePlayerConfig(sPlayer);
            if (sPlayer.method_5715()) {
                int slotIndex;
                class_1799 stackInHand = sPlayer.method_5998(eventHand);
                class_1792 itemInHand = stackInHand.method_7909();
                class_2960 itemId = class_7923.field_41178.method_10221((Object)itemInHand);
                int n = slotIndex = eventHand == class_1268.field_5808 ? ((PlayerInventoryAccess)sPlayer.method_31548()).getSelectedSlot() : 40;
                if (itemInHand instanceof class_5537) {
                    boolean canOpen;
                    if (ShulkerPickup.isPlaceholderBundle(stackInHand)) {
                        return class_1269.field_5814;
                    }
                    boolean bl = canOpen = isSinglePlayer && playerConfig.isGuiBundleEnabled() || ModConfig.getInstance().isGlobalGuiEnabledBundle() && playerConfig.isGuiBundleEnabled() && !playerConfig.isDenyMultiplayerPermissions() || ShulkerPickup.checkPermission(sPlayer.method_64396(), PERMISSION_OPEN_BUNDLE_GUI, 2) && playerConfig.isGuiBundleEnabled() && !playerConfig.isDenyMultiplayerPermissions();
                    if (!canOpen) {
                        return class_1269.field_5814;
                    }
                    class_1792 originalBundleItemType = stackInHand.method_7909();
                    class_9276 initialContents = (class_9276)stackInHand.method_58694(class_9334.field_49650);
                    class_2561 originalCustomName = (class_2561)stackInHand.method_58694(class_9334.field_49631);
                    class_1799 placeholderBundle = new class_1799((class_1935)originalBundleItemType);
                    class_5250 placeholderNameText = class_2561.method_43470((String)PLACEHOLDER_BUNDLE_NAME_PREFIX);
                    if (originalCustomName != null) {
                        placeholderNameText.method_10852(originalCustomName);
                    } else {
                        placeholderNameText.method_10852((class_2561)class_2561.method_43471((String)originalBundleItemType.method_7876()));
                    }
                    placeholderBundle.method_57379(class_9334.field_49631, (Object)placeholderNameText.method_27692(PLACEHOLDER_BUNDLE_NAME_FORMATTING));
                    sPlayer.method_6122(eventHand, placeholderBundle);
                    sPlayer.field_7498.method_34252();
                    BundleItemScreenHandler.open(sPlayer, initialContents, originalCustomName, originalBundleItemType, eventHand, slotIndex);
                    return class_1269.field_21466;
                }
                boolean isReinforcedShulker = itemId.method_12836().equals("reinfshulker") && itemId.method_12832().contains("shulker_box");
                class_2248 blockInHand = class_2248.method_9503((class_1792)itemInHand);
                if (ShulkerPickup.isPlaceholderShulkerBox(stackInHand)) {
                    return class_1269.field_5814;
                }
                if (blockInHand instanceof class_2480 || isReinforcedShulker) {
                    boolean canOpen;
                    boolean bl = canOpen = isSinglePlayer && playerConfig.isGuiShulkerEnabled() || ModConfig.getInstance().isGlobalGuiEnabledShulker() && playerConfig.isGuiShulkerEnabled() && !playerConfig.isDenyMultiplayerPermissions() || ShulkerPickup.checkPermission(sPlayer.method_64396(), PERMISSION_OPEN_SHULKER_GUI, 2) && playerConfig.isGuiShulkerEnabled() && !playerConfig.isDenyMultiplayerPermissions();
                    if (!canOpen) {
                        return class_1269.field_5814;
                    }
                    if (stackInHand.method_7947() > 1) {
                        sPlayer.method_7353((class_2561)class_2561.method_43471((String)"text.shulkerbundle.stacked_shulker_error").method_27692(class_124.field_1061), true);
                        return class_1269.field_5814;
                    }
                    ShulkerTypeInfo typeInfo = this.getShulkerTypeInfo(itemInHand);
                    if (typeInfo == null) {
                        sPlayer.method_7353((class_2561)class_2561.method_43470((String)"ShulkerBundle Error: Could not detect GUI type for this Reinforced Shulker! Check server logs.").method_27692(class_124.field_1061), false);
                        return class_1269.field_5814;
                    }
                    class_1792 originalShulkerItemType = itemInHand;
                    class_2561 originalCustomName = (class_2561)stackInHand.method_58694(class_9334.field_49631);
                    class_9288 originalContents = (class_9288)stackInHand.method_58694(class_9334.field_49622);
                    class_1799 placeholderShulker = new class_1799((class_1935)originalShulkerItemType);
                    class_5250 placeholderName = class_2561.method_43470((String)PLACEHOLDER_SHULKER_NAME_PREFIX);
                    if (originalCustomName != null) {
                        placeholderName.method_10852(originalCustomName);
                    } else {
                        placeholderName.method_10852((class_2561)class_2561.method_43471((String)originalShulkerItemType.method_7876()));
                    }
                    placeholderShulker.method_57379(class_9334.field_49631, (Object)placeholderName.method_27692(PLACEHOLDER_SHULKER_NAME_FORMATTING));
                    class_2487 placeholderNbtData = new class_2487();
                    placeholderNbtData.method_10556(IS_PLACEHOLDER_SHULKER_NBT_KEY, true);
                    placeholderShulker.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)placeholderNbtData));
                    sPlayer.method_6122(eventHand, placeholderShulker);
                    sPlayer.field_7498.method_34252();
                    ShulkerItemScreenHandler.open(sPlayer, placeholderShulker, originalContents, originalCustomName, originalShulkerItemType, eventHand, true, slotIndex, typeInfo.handlerType(), typeInfo.rows());
                    sPlayer.method_23667(eventHand, true);
                    return class_1269.field_21466;
                }
            }
            return class_1269.field_5811;
        });
        ShulkerBundleCommand.init();
    }

    private void handlePlayerDisconnect(class_3244 networkHandler, MinecraftServer server) {
        class_3222 player = networkHandler.method_32311();
        playerLastClickTime.remove(player.method_5667());
        playerLastShulkerThirdRowFill.remove(player.method_5667());
        playersWithMod.remove(player.method_5667());
        if (player.field_7512 instanceof ShulkerItemScreenHandler || player.field_7512 instanceof BundleItemScreenHandler) {
            player.field_7512.method_7595((class_1657)player);
        }
        PlayerConfigManager.savePlayerConfig(player);
        PlayerConfigManager.removePlayerConfig(player.method_5667());
    }

    public static boolean isClickTooFast(class_3222 player, boolean isCustomGuiActive) {
        long lastClick;
        if (!isCustomGuiActive) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastClick = playerLastClickTime.getOrDefault(player.method_5667(), 0L).longValue()) < 100L) {
            player.field_13987.method_14364((class_2596)new class_2649(player.field_7512.field_7763, player.field_7512.method_37422(), (List)player.field_7512.method_7602(), player.field_7498.method_34255()));
            return true;
        }
        playerLastClickTime.put(player.method_5667(), currentTime);
        return false;
    }

    public static int getShulkerBoxColor(class_1799 shulkerStack) {
        class_2480 shulkerBlock;
        class_1767 color;
        class_9282 colorComponent = (class_9282)shulkerStack.method_58694(class_9334.field_49644);
        if (colorComponent != null) {
            return colorComponent.comp_2384();
        }
        class_2248 block = class_2248.method_9503((class_1792)shulkerStack.method_7909());
        if (block instanceof class_2480 && (color = (shulkerBlock = (class_2480)block).method_10528()) != null) {
            return color.method_7794().field_16011;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)shulkerStack.method_7909());
        if (id.method_12836().equals("reinfshulker")) {
            for (class_1767 color2 : class_1767.values()) {
                if (!id.method_12832().startsWith(color2.method_15434() + "_")) continue;
                return color2.method_7794().field_16011;
            }
        }
        return Objects.requireNonNullElse(class_124.field_1068.method_532(), -1);
    }

    public static int getBundleItemCount(class_1799 bundleStack) {
        class_9276 contents;
        if (bundleStack.method_7909() instanceof class_5537 && (contents = (class_9276)bundleStack.method_58694(class_9334.field_49650)) != null) {
            return contents.method_59707().mapToInt(class_1799::method_7947).sum();
        }
        return 0;
    }

    public static int getBundleDisplayColor(class_1799 bundleStack) {
        if (!(bundleStack.method_7909() instanceof class_5537)) {
            return Objects.requireNonNullElse(class_124.field_1080.method_532(), -8355712);
        }
        class_9282 dyedColorComponent = (class_9282)bundleStack.method_58694(class_9334.field_49644);
        if (dyedColorComponent != null) {
            return dyedColorComponent.comp_2384();
        }
        String itemId = class_7923.field_41178.method_10221((Object)bundleStack.method_7909()).toString();
        for (class_1767 dyeColor : class_1767.values()) {
            if (!itemId.contains(dyeColor.method_15434() + "_bundle")) continue;
            return dyeColor.method_7794().field_16011;
        }
        return class_5537.method_31561((class_1799)bundleStack) > 0.0f ? -1 : -8355712;
    }

    public static void sendActionBarMessage(class_3222 player, class_2561 message) {
        player.field_13987.method_14364((class_2596)new class_5894(message));
    }

    public static void handleShulkerAndBundleNotifications(class_3222 sPlayer, PickupResult pickupType) {
        if (pickupType == PickupResult.NONE) {
            return;
        }
        MinecraftServer playerServer = sPlayer.method_37908().method_8503();
        boolean isSinglePlayer = playerServer != null ? playerServer.method_3724() : false;
        PlayerConfig playerConfig = PlayerConfigManager.getOrCreatePlayerConfig(sPlayer);
        if (pickupType == PickupResult.SHULKER) {
            boolean isReinforced;
            boolean canNotify;
            boolean bl = canNotify = isSinglePlayer && playerConfig.isNotifyShulkerEnabled() || ModConfig.getInstance().isGlobalNotifyEnabledShulker() && playerConfig.isNotifyShulkerEnabled() && !playerConfig.isDenyMultiplayerPermissions() || ShulkerPickup.checkPermission(sPlayer.method_64396(), PERMISSION_NOTIFY_SHULKER, 2) && playerConfig.isNotifyShulkerEnabled() && !playerConfig.isDenyMultiplayerPermissions();
            if (!canNotify) {
                return;
            }
            class_1799 offhandStack = sPlayer.method_31548().method_5438(40);
            boolean isVanilla = offhandStack.method_7909() instanceof class_1747 && ((class_1747)offhandStack.method_7909()).method_7711() instanceof class_2480;
            boolean bl2 = isReinforced = class_7923.field_41178.method_10221((Object)offhandStack.method_7909()).method_12836().equals("reinfshulker") && class_7923.field_41178.method_10221((Object)offhandStack.method_7909()).method_12832().contains("shulker_box");
            if (isVanilla || isReinforced) {
                class_9288 container;
                int maxSlots = 27;
                if (isReinforced) {
                    String path = class_7923.field_41178.method_10221((Object)offhandStack.method_7909()).method_12832();
                    if (path.contains("copper")) {
                        maxSlots = 45;
                    } else if (path.contains("iron")) {
                        maxSlots = 54;
                    } else if (path.contains("gold")) {
                        maxSlots = 81;
                    } else if (path.contains("diamond") || path.contains("netherite")) {
                        maxSlots = 108;
                    }
                }
                int filledSlots = (container = (class_9288)offhandStack.method_58694(class_9334.field_49622)) != null ? (int)container.method_57489().filter(s -> !s.method_7960()).count() : 0;
                int itemsInLastRow = 0;
                if (container != null) {
                    int thresholdIndex;
                    class_2371 items = class_2371.method_10213((int)maxSlots, (Object)class_1799.field_8037);
                    container.method_57492(items);
                    for (int i = thresholdIndex = Math.max(0, maxSlots - 9); i < maxSlots && i < items.size(); ++i) {
                        if (((class_1799)items.get(i)).method_7960()) continue;
                        ++itemsInLastRow;
                    }
                }
                int previousLastRowFill = playerLastShulkerThirdRowFill.getOrDefault(sPlayer.method_5667(), 0);
                if (itemsInLastRow > 0 && itemsInLastRow != previousLastRowFill) {
                    int emptySlots = Math.max(0, maxSlots - filledSlots);
                    class_5250 message = class_2561.method_43470((String)("Shulker has " + emptySlots + " empty slots left")).method_27694(style -> style.method_36139(ShulkerPickup.getShulkerBoxColor(offhandStack)));
                    ShulkerPickup.sendActionBarMessage(sPlayer, (class_2561)message);
                    playerLastShulkerThirdRowFill.put(sPlayer.method_5667(), itemsInLastRow);
                } else if (itemsInLastRow == 0 && previousLastRowFill > 0) {
                    playerLastShulkerThirdRowFill.put(sPlayer.method_5667(), 0);
                }
            }
        } else if (pickupType == PickupResult.BUNDLE) {
            boolean canNotify;
            boolean bl = canNotify = isSinglePlayer && playerConfig.isNotifyBundleEnabled() || ModConfig.getInstance().isGlobalNotifyEnabledBundle() && playerConfig.isNotifyBundleEnabled() && !playerConfig.isDenyMultiplayerPermissions() || ShulkerPickup.checkPermission(sPlayer.method_64396(), PERMISSION_NOTIFY_BUNDLE, 2) && playerConfig.isNotifyBundleEnabled() && !playerConfig.isDenyMultiplayerPermissions();
            if (!canNotify) {
                return;
            }
            ArrayList<class_1799> playerBundles = new ArrayList<class_1799>();
            for (int i = 0; i < sPlayer.method_31548().method_5439(); ++i) {
                class_1799 stack = sPlayer.method_31548().method_5438(i);
                if (!(stack.method_7909() instanceof class_5537) || ShulkerPickup.isPlaceholderBundle(stack)) continue;
                playerBundles.add(stack);
            }
            class_1799 activeBundle = LAST_MODIFIED_BUNDLE.get();
            if (!activeBundle.method_7960() && ShulkerPickup.getBundleItemCount(activeBundle) >= 32 && class_5537.method_31561((class_1799)activeBundle) < 1.0f) {
                int totalItemsInBundle = ShulkerPickup.getBundleItemCount(activeBundle);
                class_5250 message = class_2561.method_43470((String)("Bundle has (" + totalItemsInBundle + "/64) items")).method_27694(style -> style.method_36139(ShulkerPickup.getBundleDisplayColor(activeBundle)));
                ShulkerPickup.sendActionBarMessage(sPlayer, (class_2561)message);
            } else {
                long bundlesWithSpaceCount = playerBundles.stream().filter(bundle -> class_5537.method_31561((class_1799)bundle) < 1.0f).count();
                int messageColor = -6250336;
                class_5250 message = class_2561.method_43470((String)("Bundles with space " + bundlesWithSpaceCount)).method_27694(style -> style.method_36139(messageColor));
                ShulkerPickup.sendActionBarMessage(sPlayer, (class_2561)message);
            }
        }
    }

    public record ShulkerTypeInfo(class_3917<?> handlerType, int rows) {
    }

    public static enum PickupResult {
        NONE,
        SHULKER,
        BUNDLE;

    }
}

