/*
 * Decompiled with CFR 0.152.
 */
package be.andy.shulkerbundle.command;

import be.andy.shulkerbundle.ShulkerPickup;
import be.andy.shulkerbundle.config.ModConfig;
import be.andy.shulkerbundle.config.PlayerConfig;
import be.andy.shulkerbundle.config.PlayerConfigManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ShulkerBundleCommand {
    public static final String PERM_COMMAND_USE = "shulkerbundle.command.use";
    public static final String PERM_ADMIN = "shulkerbundle.admin";
    private static List<String> HELP_LINES = Collections.emptyList();
    private static final List<String> PAGE1_HELP_LINES = List.of("", "&6&m                    &r  &6ShulkerBundle Commands:  &6&m                    ", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&e/sb global notify 'shulker|bundle'{Turn off notifications.}<action:suggest_command,/sb global notify >", "&e/sb global pickup 'shulker|bundle'{Turn off pickup.}<action:suggest_command,/sb global pickup >", "&e/sb global gui 'shulker|bundle'{Turn off gui.}<action:suggest_command,/sb global gui >", "&e/sb personal notify 'shulker|bundle'{Turn off notifications.}<action:suggest_command,/sb personal notify >", "&e/sb personal pickup 'shulker|bundle'{Turn off pickup.}<action:suggest_command,/sb personal pickup >", "&e/sb personal gui 'shulker|bundle'{Turn off gui.}<action:suggest_command,/sb personal gui >", "&bMultiplayer has features off globally by default {using permission nodes instead.}", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&ashulkerbundle.open {Allows opening the Shulker box GUI with shift-right-click.}", "&ashulkerbundle.open_bundle_gui {Allows opening the custom Bundle GUI with shift-right-click.}", "&ashulkerbundle.hold.shulker {Allows items to be automatically inserted into the off-hand shulker.}", "&ashulkerbundle.hold.bundle {Allows items to be automatically inserted into Bundles in the player's inventory.}", "&ashulkerbundle.notify.shulker {Allows players to receive action bar notifications for Shulker Box fill status.}", "&ashulkerbundle.notify.bundle {Allows players to receive action bar notifications for Bundle fill status.}", "&ashulkerbundle.admin {Grants all ShulkerBundle administrative permissions, including command usage.}", "&7\u27a1                                                                         {click the commands to auto fill your chat}<action:suggest_command,:)>", "&e/sb is an Alias :)                       &6[ShulkerBundle Help Link]{This is my discord i dont have a github etc yet will look into it :)}<action:open_url,https://discord.gg/48sZCbdHzJ>");
    private static final Pattern HELP_LINE_PATTERN = Pattern.compile("^(.*?)(?:\\{(.*?)\\})?(?:<action:(.+?),(.+?)>)?$");

    private static void initializeHelp() {
        if (!HELP_LINES.isEmpty()) {
            return;
        }
        HELP_LINES = List.copyOf(PAGE1_HELP_LINES);
    }

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ShulkerBundleCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        ShulkerBundleCommand.initializeHelp();
        LiteralArgumentBuilder shulkerbundleCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"shulkerbundle").requires(source -> ShulkerPickup.checkPermission(source, PERM_COMMAND_USE, 0))).executes(ShulkerBundleCommand::showHelp);
        LiteralArgumentBuilder sbCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sb").requires(source -> ShulkerPickup.checkPermission(source, PERM_COMMAND_USE, 0))).executes(ShulkerBundleCommand::showHelp);
        ShulkerBundleCommand.buildCommandStructure((LiteralArgumentBuilder<class_2168>)shulkerbundleCommand);
        ShulkerBundleCommand.buildCommandStructure((LiteralArgumentBuilder<class_2168>)sbCommand);
        dispatcher.register(shulkerbundleCommand);
        dispatcher.register(sbCommand);
    }

    private static void buildCommandStructure(LiteralArgumentBuilder<class_2168> baseCommand) {
        LiteralArgumentBuilder globalCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"global").requires(source -> ShulkerPickup.checkPermission(source, PERM_ADMIN, 2));
        ShulkerBundleCommand.registerGlobalSubCommand((LiteralArgumentBuilder<class_2168>)globalCommand, "notify", ModConfig::isGlobalNotifyEnabledShulker, ModConfig::setGlobalNotifyEnabledShulker, ModConfig::isGlobalNotifyEnabledBundle, ModConfig::setGlobalNotifyEnabledBundle);
        ShulkerBundleCommand.registerGlobalSubCommand((LiteralArgumentBuilder<class_2168>)globalCommand, "pickup", ModConfig::isGlobalPickupEnabledShulker, ModConfig::setGlobalPickupEnabledShulker, ModConfig::isGlobalPickupEnabledBundle, ModConfig::setGlobalPickupEnabledBundle);
        ShulkerBundleCommand.registerGlobalSubCommand((LiteralArgumentBuilder<class_2168>)globalCommand, "gui", ModConfig::isGlobalGuiEnabledShulker, ModConfig::setGlobalGuiEnabledShulker, ModConfig::isGlobalGuiEnabledBundle, ModConfig::setGlobalGuiEnabledBundle);
        baseCommand.then((ArgumentBuilder)globalCommand);
        LiteralArgumentBuilder personalCommand = (LiteralArgumentBuilder)class_2170.method_9247((String)"personal").requires(class_2168::method_43737);
        ShulkerBundleCommand.registerPersonalSubCommand((LiteralArgumentBuilder<class_2168>)personalCommand, "notify", PlayerConfig::isNotifyShulkerEnabled, PlayerConfig::setNotifyShulkerEnabled, PlayerConfig::isNotifyBundleEnabled, PlayerConfig::setNotifyBundleEnabled);
        ShulkerBundleCommand.registerPersonalSubCommand((LiteralArgumentBuilder<class_2168>)personalCommand, "pickup", PlayerConfig::isPickupShulkerEnabled, PlayerConfig::setPickupShulkerEnabled, PlayerConfig::isPickupBundleEnabled, PlayerConfig::setPickupBundleEnabled);
        ShulkerBundleCommand.registerPersonalSubCommand((LiteralArgumentBuilder<class_2168>)personalCommand, "gui", PlayerConfig::isGuiShulkerEnabled, PlayerConfig::setGuiShulkerEnabled, PlayerConfig::isGuiBundleEnabled, PlayerConfig::setGuiBundleEnabled);
        baseCommand.then((ArgumentBuilder)personalCommand);
    }

    private static void registerGlobalSubCommand(LiteralArgumentBuilder<class_2168> parent, String name, Function<ModConfig, Boolean> shulkerGetter, BiConsumer<ModConfig, Boolean> shulkerSetter, Function<ModConfig, Boolean> bundleGetter, BiConsumer<ModConfig, Boolean> bundleSetter) {
        parent.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).executes(context -> {
            ShulkerBundleCommand.toggleGlobalSetting((CommandContext<class_2168>)context, "Shulker " + name, shulkerGetter, shulkerSetter);
            ShulkerBundleCommand.toggleGlobalSetting((CommandContext<class_2168>)context, "Bundle " + name, bundleGetter, bundleSetter);
            return 1;
        })).then(class_2170.method_9247((String)"shulker").executes(context -> ShulkerBundleCommand.toggleGlobalSetting((CommandContext<class_2168>)context, "Shulker " + name, shulkerGetter, shulkerSetter)))).then(class_2170.method_9247((String)"bundle").executes(context -> ShulkerBundleCommand.toggleGlobalSetting((CommandContext<class_2168>)context, "Bundle " + name, bundleGetter, bundleSetter))));
    }

    private static int toggleGlobalSetting(CommandContext<class_2168> context, String settingName, Function<ModConfig, Boolean> getter, BiConsumer<ModConfig, Boolean> setter) {
        boolean currentState = getter.apply(ModConfig.getInstance());
        setter.accept(ModConfig.getInstance(), !currentState);
        class_5250 status = !currentState ? class_2561.method_43470((String)"ENABLED").method_27692(class_124.field_1060) : class_2561.method_43470((String)"DISABLED").method_27692(class_124.field_1061);
        ((class_2168)context.getSource()).method_9226(() -> ShulkerBundleCommand.lambda$toggleGlobalSetting$7(settingName, (class_2561)status), true);
        return 1;
    }

    private static void registerPersonalSubCommand(LiteralArgumentBuilder<class_2168> parent, String name, Function<PlayerConfig, Boolean> shulkerGetter, BiConsumer<PlayerConfig, Boolean> shulkerSetter, Function<PlayerConfig, Boolean> bundleGetter, BiConsumer<PlayerConfig, Boolean> bundleSetter) {
        parent.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).executes(context -> {
            ShulkerBundleCommand.togglePersonalSetting((CommandContext<class_2168>)context, "Shulker " + name, shulkerGetter, shulkerSetter);
            ShulkerBundleCommand.togglePersonalSetting((CommandContext<class_2168>)context, "Bundle " + name, bundleGetter, bundleSetter);
            return 1;
        })).then(class_2170.method_9247((String)"shulker").executes(context -> ShulkerBundleCommand.togglePersonalSetting((CommandContext<class_2168>)context, "Shulker " + name, shulkerGetter, shulkerSetter)))).then(class_2170.method_9247((String)"bundle").executes(context -> ShulkerBundleCommand.togglePersonalSetting((CommandContext<class_2168>)context, "Bundle " + name, bundleGetter, bundleSetter))));
    }

    private static int togglePersonalSetting(CommandContext<class_2168> context, String settingName, Function<PlayerConfig, Boolean> getter, BiConsumer<PlayerConfig, Boolean> setter) {
        PlayerConfig playerConfig;
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"This command must be run by a player."));
            return 0;
        }
        boolean currentState = getter.apply(playerConfig = PlayerConfigManager.getOrCreatePlayerConfig(player));
        setter.accept(playerConfig, !currentState);
        class_5250 status = !currentState ? class_2561.method_43470((String)"ENABLED").method_27692(class_124.field_1060) : class_2561.method_43470((String)"DISABLED").method_27692(class_124.field_1061);
        player.method_64398((class_2561)class_2561.method_43470((String)("Personal " + settingName + " is now ")).method_10852((class_2561)status));
        return 1;
    }

    private static int showHelp(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            if (HELP_LINES.isEmpty()) {
                ShulkerBundleCommand.initializeHelp();
                if (HELP_LINES.isEmpty()) {
                    source.method_9213((class_2561)class_2561.method_43470((String)"ShulkerBundle help could not be loaded."));
                    return 0;
                }
            }
            source.method_9226(() -> class_2561.method_43470((String)" "), false);
            for (String line : HELP_LINES) {
                Matcher matcher = HELP_LINE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String mainTextStr = matcher.group(1);
                    String hoverTextStr = matcher.group(2);
                    String actionTypeStr = matcher.group(3);
                    String actionValueStrOriginal = matcher.group(4);
                    class_5250 formattedLine = class_2561.method_43470((String)mainTextStr.replace("&", "\u00a7"));
                    class_2583 currentStyle = formattedLine.method_10866();
                    if (hoverTextStr != null && !hoverTextStr.isEmpty()) {
                        currentStyle = currentStyle.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)hoverTextStr.replace("&", "\u00a7"))));
                    }
                    if (actionTypeStr != null && actionValueStrOriginal != null) {
                        String trimmedActionType = actionTypeStr.trim().toLowerCase();
                        String finalActionValue = actionValueStrOriginal.trim();
                        class_2558.class_10610 clickEvent = null;
                        switch (trimmedActionType) {
                            case "suggest_command": {
                                clickEvent = new class_2558.class_10610(finalActionValue);
                                break;
                            }
                            case "run_command": {
                                clickEvent = new class_2558.class_10609(finalActionValue);
                                break;
                            }
                            case "open_url": {
                                try {
                                    clickEvent = new class_2558.class_10608(new URI(finalActionValue));
                                    break;
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (clickEvent != null) {
                            currentStyle = currentStyle.method_10958((class_2558)clickEvent);
                        }
                    }
                    formattedLine.method_10862(currentStyle);
                    source.method_9226(() -> formattedLine, false);
                    continue;
                }
                source.method_9226(() -> class_2561.method_43470((String)line.replace("&", "\u00a7")), false);
            }
            source.method_9226(() -> class_2561.method_43470((String)" "), false);
            return 1;
        }
        catch (Throwable e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"An internal error occurred displaying help."));
            return 0;
        }
    }

    private static /* synthetic */ class_2561 lambda$toggleGlobalSetting$7(String settingName, class_2561 status) {
        return class_2561.method_43470((String)("Global " + settingName + " is now ")).method_10852(status);
    }
}

