/*
 * Decompiled with CFR 0.152.
 */
package be.andy.shulkerbundle.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ClientConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "shulkerbundle-client.json";
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("shulkerbundle-client.json");
    private boolean spGuiShulkerEnabled = true;
    private boolean spGuiBundleEnabled = true;
    private boolean spPickupShulkerEnabled = true;
    private boolean spPickupBundleEnabled = true;
    private boolean spNotifyShulkerEnabled = true;
    private boolean spNotifyBundleEnabled = true;
    private boolean mpGuiShulkerEnabled = true;
    private boolean mpGuiBundleEnabled = true;
    private boolean mpPickupShulkerEnabled = true;
    private boolean mpPickupBundleEnabled = true;
    private boolean mpNotifyShulkerEnabled = true;
    private boolean mpNotifyBundleEnabled = true;
    private boolean mpDenyPermissionsEnabled = false;
    private static ClientConfig INSTANCE;

    public static ClientConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientConfig();
        }
        return INSTANCE;
    }

    private ClientConfig() {
    }

    public boolean isSpGuiShulkerEnabled() {
        return this.spGuiShulkerEnabled;
    }

    public boolean isSpGuiBundleEnabled() {
        return this.spGuiBundleEnabled;
    }

    public boolean isSpPickupShulkerEnabled() {
        return this.spPickupShulkerEnabled;
    }

    public boolean isSpPickupBundleEnabled() {
        return this.spPickupBundleEnabled;
    }

    public boolean isSpNotifyShulkerEnabled() {
        return this.spNotifyShulkerEnabled;
    }

    public boolean isSpNotifyBundleEnabled() {
        return this.spNotifyBundleEnabled;
    }

    public void setSpGuiShulkerEnabled(boolean spGuiShulkerEnabled) {
        this.spGuiShulkerEnabled = spGuiShulkerEnabled;
    }

    public void setSpGuiBundleEnabled(boolean spGuiBundleEnabled) {
        this.spGuiBundleEnabled = spGuiBundleEnabled;
    }

    public void setSpPickupShulkerEnabled(boolean spPickupShulkerEnabled) {
        this.spPickupShulkerEnabled = spPickupShulkerEnabled;
    }

    public void setSpPickupBundleEnabled(boolean spPickupBundleEnabled) {
        this.spPickupBundleEnabled = spPickupBundleEnabled;
    }

    public void setSpNotifyShulkerEnabled(boolean spNotifyShulkerEnabled) {
        this.spNotifyShulkerEnabled = spNotifyShulkerEnabled;
    }

    public void setSpNotifyBundleEnabled(boolean spNotifyBundleEnabled) {
        this.spNotifyBundleEnabled = spNotifyBundleEnabled;
    }

    public boolean isMpGuiShulkerEnabled() {
        return this.mpGuiShulkerEnabled;
    }

    public boolean isMpGuiBundleEnabled() {
        return this.mpGuiBundleEnabled;
    }

    public boolean isMpPickupShulkerEnabled() {
        return this.mpPickupShulkerEnabled;
    }

    public boolean isMpPickupBundleEnabled() {
        return this.mpPickupBundleEnabled;
    }

    public boolean isMpNotifyShulkerEnabled() {
        return this.mpNotifyShulkerEnabled;
    }

    public boolean isMpNotifyBundleEnabled() {
        return this.mpNotifyBundleEnabled;
    }

    public boolean isMpDenyPermissionsEnabled() {
        return this.mpDenyPermissionsEnabled;
    }

    public void setMpGuiShulkerEnabled(boolean mpGuiShulkerEnabled) {
        this.mpGuiShulkerEnabled = mpGuiShulkerEnabled;
    }

    public void setMpGuiBundleEnabled(boolean mpGuiBundleEnabled) {
        this.mpGuiBundleEnabled = mpGuiBundleEnabled;
    }

    public void setMpPickupShulkerEnabled(boolean mpPickupShulkerEnabled) {
        this.mpPickupShulkerEnabled = mpPickupShulkerEnabled;
    }

    public void setMpPickupBundleEnabled(boolean mpPickupBundleEnabled) {
        this.mpPickupBundleEnabled = mpPickupBundleEnabled;
    }

    public void setMpNotifyShulkerEnabled(boolean mpNotifyShulkerEnabled) {
        this.mpNotifyShulkerEnabled = mpNotifyShulkerEnabled;
    }

    public void setMpNotifyBundleEnabled(boolean mpNotifyBundleEnabled) {
        this.mpNotifyBundleEnabled = mpNotifyBundleEnabled;
    }

    public void setMpDenyPermissionsEnabled(boolean mpDenyPermissionsEnabled) {
        this.mpDenyPermissionsEnabled = mpDenyPermissionsEnabled;
    }

    public static void loadConfig() {
        File configFile = configPath.toFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                INSTANCE = (ClientConfig)GSON.fromJson((Reader)reader, ClientConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new ClientConfig();
                }
            }
            catch (IOException e) {
                INSTANCE = new ClientConfig();
            }
        } else {
            INSTANCE = new ClientConfig();
            ClientConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        File configFile = configPath.toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

