/*
 * Decompiled with CFR 0.152.
 */
package be.andy.shulkerbundle.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "shulkerbundle.json";
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("shulkerbundle.json");
    private boolean globalNotifyEnabledShulker = false;
    private boolean globalNotifyEnabledBundle = false;
    private boolean globalPickupEnabledShulker = false;
    private boolean globalPickupEnabledBundle = false;
    private boolean globalGuiEnabledShulker = false;
    private boolean globalGuiEnabledBundle = false;
    private boolean notifyPlayer = true;
    private static ModConfig INSTANCE;

    public static ModConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    private ModConfig() {
    }

    public boolean isGlobalNotifyEnabledShulker() {
        return this.globalNotifyEnabledShulker;
    }

    public boolean isGlobalNotifyEnabledBundle() {
        return this.globalNotifyEnabledBundle;
    }

    public boolean isGlobalPickupEnabledShulker() {
        return this.globalPickupEnabledShulker;
    }

    public boolean isGlobalPickupEnabledBundle() {
        return this.globalPickupEnabledBundle;
    }

    public boolean isGlobalGuiEnabledShulker() {
        return this.globalGuiEnabledShulker;
    }

    public boolean isGlobalGuiEnabledBundle() {
        return this.globalGuiEnabledBundle;
    }

    public boolean isNotifyPlayerEnabled() {
        return this.notifyPlayer;
    }

    public void setGlobalNotifyEnabledShulker(boolean enabled) {
        this.globalNotifyEnabledShulker = enabled;
        this.saveConfig();
    }

    public void setGlobalNotifyEnabledBundle(boolean enabled) {
        this.globalNotifyEnabledBundle = enabled;
        this.saveConfig();
    }

    public void setGlobalPickupEnabledShulker(boolean enabled) {
        this.globalPickupEnabledShulker = enabled;
        this.saveConfig();
    }

    public void setGlobalPickupEnabledBundle(boolean enabled) {
        this.globalPickupEnabledBundle = enabled;
        this.saveConfig();
    }

    public void setGlobalGuiEnabledShulker(boolean enabled) {
        this.globalGuiEnabledShulker = enabled;
        this.saveConfig();
    }

    public void setGlobalGuiEnabledBundle(boolean enabled) {
        this.globalGuiEnabledBundle = enabled;
        this.saveConfig();
    }

    public void setNotifyPlayerEnabled(boolean enabled) {
        this.notifyPlayer = enabled;
        this.saveConfig();
    }

    public static void loadConfig() {
        File configFile = configPath.toFile();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                INSTANCE = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
                if (INSTANCE == null) {
                    INSTANCE = new ModConfig();
                }
            }
            catch (IOException e) {
                INSTANCE = new ModConfig();
            }
        } else {
            INSTANCE = new ModConfig();
            INSTANCE.saveConfig();
        }
    }

    public void saveConfig() {
        File configFile = configPath.toFile();
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

