/*
 * Decompiled with CFR 0.152.
 */
package be.andy.shulkerbundle.config;

import be.andy.shulkerbundle.config.PlayerConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PlayerConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final ConcurrentHashMap<UUID, PlayerConfig> playerConfigs = new ConcurrentHashMap();
    private static Path configDirPath;

    public static void init(MinecraftServer server) {
        configDirPath = server.method_27050(class_5218.field_24188).resolve("shulkerbundle_player_data");
        File configDirFile = configDirPath.toFile();
        if (!configDirFile.exists()) {
            configDirFile.mkdirs();
        }
    }

    public static PlayerConfig getOrCreatePlayerConfig(class_3222 player) {
        UUID uuid = player.method_5667();
        return playerConfigs.computeIfAbsent(uuid, k -> PlayerConfigManager.loadPlayerConfig(uuid));
    }

    public static void savePlayerConfig(class_3222 player) {
        UUID uuid = player.method_5667();
        PlayerConfig config = playerConfigs.get(uuid);
        if (config != null) {
            try (FileWriter writer = new FileWriter(configDirPath.resolve(uuid.toString() + ".json").toFile());){
                GSON.toJson((Object)config, (Appendable)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static PlayerConfig loadPlayerConfig(UUID uuid) {
        File configFile = configDirPath.resolve(uuid.toString() + ".json").toFile();
        if (configFile.exists()) {
            PlayerConfig playerConfig;
            FileReader reader = new FileReader(configFile);
            try {
                PlayerConfig config = (PlayerConfig)GSON.fromJson((Reader)reader, PlayerConfig.class);
                playerConfig = config != null ? config : new PlayerConfig();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new PlayerConfig();
                }
            }
            reader.close();
            return playerConfig;
        }
        return new PlayerConfig();
    }

    public static void removePlayerConfig(UUID uuid) {
        playerConfigs.remove(uuid);
    }
}

